#include "tasklogin.h"
#include "fmviplogin.h"

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    //connect(this, SIGNAL(TaskLogin::starReader), _window, SLOT(FMVipLogin::onstartreader));
    connect(this, &TaskLogin::starReader, qobject_cast<FMVipLogin*>(_window), &FMVipLogin::onstartreader);
    connect(qobject_cast<FMVipLogin*>(_window), FMVipLogin::login, this, TaskLogin::onLogin);
}

void TaskLogin::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.Member_sign)] = _session->data(PosProps.Member_sign).toString();
}

void TaskLogin::packagePOSRsp()
{
    for (QString prop : {PosProps.StatusCode, PosProps.Msg, PosProps.Fm_open_id}) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 0;
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        closeWindow();
        return;
    }

    // 认证失败
    if(getServerJsonValue(PosProps.StatusCode).toInt() != FM_API_SUCCESS) {
        FMMsgWnd::FailureWnd(serverRspJsonObj[ServerProps(PosProps.Msg)].toString());
        qDebug() << "********************1111";
        emit starReader();
    }
    // 认证成功但限制用支付码
//    else if((session()->data(PosProps.FM_Type).toInt() == FM_Pay) &&
//              (getServerJsonValue(PosProps.CanPay).toInt() != 1)) {
//        FMMsgWnd::FailureWnd(ErrorNeedPayCode);
//    }
    // 认证成功
    else {
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        QString name = getServerJsonValue(PosProps.Name).toString();

        if(session()->data(PosProps.FM_Type).toInt() == FM_Login) {
            FMMsgWnd::LoginSuccess(account,name,birthday);
        } else {
            session()->addData(PosProps.Name, name);
            session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
            session()->addData(PosProps.Birthday, birthday);
            session()->addData(PosProps.Mobile, getServerJsonValue(PosProps.Mobile).toString());
            session()->addData(PosProps.Fm_open_id, account);
            session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());

//            QMap<QString, QVariant> couponMap;
//            for (auto value : getServerJsonValue(PosProps.CouponList).toArray())
//            {
//                QJsonObject couponOb = value.toObject();
//                QString code = couponOb[ServerProps(PosProps.Coupon_code)].toString();
//                double amount = couponOb[ServerProps(PosProps.Coupon_disAmount)].toInt() / 100.0;
//                QString desc = couponOb[ServerProps(PosProps.Coupon_desc)].toString();

//                Coupon c{code, amount, desc};
//                QVariant v;
//                v.setValue(c);
//                couponMap[code] = v;
//            }
//            session()->addData(PosProps.CouponMap, couponMap);
        }
        closeWindow();
    }
    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
