#include "taskfund.h"
#include "fmvipfund.h"
#include "tasklogin.h"
#include <QDateTime>

TaskFund::TaskFund(QJsonObject &jsonObj, Session* session, QObject *parent)
    :FMTask(jsonObj, FM_Fund, session, parent)
{

}

QByteArray TaskFund::doTask()
{
    posReqJsonObj[PosProps.Fm_cmd] = FM_Server_Type[FM_Type()];
    return FMTask::doTask();
}

void TaskFund::setWindow()
{
    _window = new FMVipFund;

    connect(qobject_cast<FMVipFund*>(_window), SIGNAL(fund()), this, SLOT(onFund()));

    session()->addData(PosProps.ChargeAmount, getPosJsonValue(PosProps.ChargeAmount));
}

void TaskFund::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = createTransId();
    serverReqJsonObj[ServerProps(PosProps.AuthAccount)] = "0000000000";
    QJsonObject trans;
    trans[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    trans[ServerProps(PosProps.ChargeAmount)] = session()->data(PosProps.ChargeAmount).toInt();
    trans[ServerProps(PosProps.CashAmount)] = session()->data(PosProps.ChargeAmount).toInt();
    trans[ServerProps(PosProps.ThirdAmount)] = 0;
    trans[ServerProps(PosProps.Pay_transId)]  = "";
    trans[ServerProps(PosProps.Pay_type)] = 2;
    serverReqJsonObj[ServerProps(PosProps.Transaction)] = trans;
}

void TaskFund::packagePOSRsp()
{
    for (QString prop : {PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;

    QJsonObject fund_info;
    for(QString prop : { PosProps.Fm_open_id, PosProps.Fm_id, PosProps.Amount, PosProps.Discount}) {
        fund_info[prop] = getServerJsonValue(prop);
    }

    posRspJsonObj[PosProps.FundInfo] = fund_info;
}

void TaskFund::onFund()
{
    sendToServer(false);
    if(error() != FM_API_SUCCESS) {
        QString msg = "充值失败：\n" + errorString();
        FMMsgWnd::FailureWnd(msg);
    } else if(getServerJsonValue(PosProps.StatusCode).toInt() != FM_API_SUCCESS) {
        QString msg = "充值失败：\n" + getServerJsonValue(PosProps.Msg).toString();
        FMMsgWnd::FailureWnd(msg);
    } else {
        int before_value = getServerJsonValue(PosProps.BeforeValue).toInt();
        int after_value = getServerJsonValue(PosProps.AfterValue).toInt();
        QString before_value_str = DOUBLE_STR(before_value/100.0);
        QString after_value_str = DOUBLE_STR(after_value/100.0);
        QString msg = QString("充值前金额：%1\n充值后金额：%2")
                             .arg(before_value_str)
                             .arg(after_value_str);
        FMMsgWnd::SuccessWnd(msg);
        closeWindow();
    }
    if(_window != nullptr) {
        _window->resetWnd();
    }
}
