#include "taskfinal.h"
#include "fmbackup.h"
#include <QDateTime>
#include <QJsonDocument>

TaskFinal::TaskFinal(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Final, 0, parent)
{
}

void TaskFinal::packageServerReq()
{
    for (auto prop : {PosProps.Fm_id, PosProps.TransId}) {
        serverReqJsonObj[ServerProps(prop)] = getPosJsonValue(prop);
    }

    QJsonObject trans;
    for (auto prop : {PosProps.Fm_open_id, PosProps.OrderAmount, PosProps.PaidAmount}) {
        trans[ServerProps(prop)] = getPosJsonValue(prop);
    }

    QJsonArray coupons = getPosJsonValue(PosProps.Coupons).toArray();

    // 储值金、积分、第三方、代金券
    int codeAmount=0, scoreAmount=0, cashAmount=0, thirdAmount=0;
    trans[ServerProps(PosProps.Pay_type)] = 4;
    trans[ServerProps(PosProps.Pay_transId)] = "";
    for(auto pay_v : getPosJsonValue(PosProps.Pay_ids).toArray())
    {
        QJsonObject pay_ob = pay_v.toObject();
        QString type = pay_ob[PosProps.Pay_id].toString();
        if(type == "24") {
            codeAmount = pay_ob[PosProps.Paid_total_amount].toInt();
        } else if(type == "25") {
            scoreAmount = pay_ob[PosProps.Paid_total_amount].toInt();
        } else if(type == "77") {               // 代金券
            coupons.append(pay_ob[PosProps.Coupon_code].toString());
        } else if(type == "72" || type == "73") {
            thirdAmount = pay_ob[PosProps.Paid_total_amount].toInt();
            trans[ServerProps(PosProps.Pay_transId)] = pay_ob[PosProps.Pay_transId];

            if (type == "72") {                 // 支付宝
                trans[ServerProps(PosProps.Pay_type)] = 1;
            } else if(type == "73") {           // 微信
                trans[ServerProps(PosProps.Pay_type)] = 2;
            }
        }
    }
    trans[ServerProps(PosProps.Coupons)] = coupons;

    cashAmount = getPosJsonValue(PosProps.PaidAmount).toInt() - codeAmount -scoreAmount - thirdAmount;
    trans[ServerProps(PosProps.CodeAmount)] = codeAmount;
    trans[ServerProps(PosProps.ScoreAmount)] = scoreAmount;
    trans[ServerProps(PosProps.CashAmount)] = cashAmount;
    trans[ServerProps(PosProps.ThirdAmount)] = thirdAmount;

    // 产品列表
    QJsonArray propducts;
    for(auto pValue : getPosJsonValue(PosProps.Products).toArray())
    {
        auto po = pValue.toObject();
        QJsonObject spo;
        for(auto prop : {PosProps.ConsumeNum, PosProps.Price, PosProps.ProductId}) {
            spo[ServerProps(prop)] = po[prop];
        }
        propducts.append(spo);
    }
    trans[ServerProps(PosProps.Products)] = propducts;

    serverReqJsonObj[ServerProps(PosProps.Transaction)] = trans;
}

bool TaskFinal::sendToServer(bool isShowMsg)
{
    Q_UNUSED(isShowMsg);
    FMTask::sendToServer(false);

    // 备份
    if(error() == FM_API_NETWORERROR) {

        if(searchJsonValue(serverReqJsonObj,ServerProps(PosProps.CodeAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.ScoreAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.Coupons)).toArray().isEmpty()) {
            QString fm_id = backup();
            if(!fm_id.isEmpty()){
                setError(FM_API_SUCCESS);
                serverRspJsonObj[ServerProps(PosProps.StatusCode)] = FM_API_SUCCESS;
                serverRspJsonObj[ServerProps(PosProps.Msg)] = "结算成功";
                serverRspJsonObj[ServerProps(PosProps.Fm_id)] = fm_id;
                serverRspJsonObj[ServerProps(PosProps.Prompt)] = 1;
                serverRspJsonObj[ServerProps(PosProps.Print1)] = "";
                serverRspJsonObj[ServerProps(PosProps.Print2)] = "";
            }
        }
    }
    bool isOk = (error() == FM_API_SUCCESS);
    if(!isOk)
    {
        FMMsgWnd::FailureWnd(errorString());
    }
    return isOk;
}

void TaskFinal::packagePOSRsp()
{
    for(auto prop : {PosProps.StatusCode, PosProps.Msg, PosProps.Fm_id, PosProps.Print1, PosProps.Print2})
    {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

QString TaskFinal::backup()
{
    int newId = FMBackup::instance()->insertNewRow();
    QString uuid = QString("E%1%2%3%4")
            .arg(getPosJsonValue(PosProps.StoreId).toString())
            .arg(getPosJsonValue(PosProps.PosId).toString().toInt(), 2, 10, QChar('0'))
            .arg(QDateTime::currentDateTime().toString("yyMMdd"))
            .arg(newId, 5, 10, QChar('0'));
    QJsonDocument json(serverReqJsonObj);
    bool isOk = FMBackup::instance()->updateReqData(newId, this->url, json.toJson(QJsonDocument::Compact));
    if(isOk && uuid.length()==20) {
        return uuid;
    }
    return "";
}
