#include "fmtask.h"
#include "fmapicfg.h"
#include "fmnetwork.h"
#include <QDateTime>
#include <QSettings>
#include <QJsonDocument>
#include <QJsonParseError>
#include <QCryptographicHash>

FMTask::FMTask(QJsonObject &jsonObj, FM_TYPE fmType, Session *session, QObject *parent) :
    QObject(parent),
    posReqJsonObj(jsonObj),
    _window(nullptr),
    _FM_Type(fmType),
    preTask(nullptr),
    isCreator(false)
{
    if(session == 0) {
        _session = new Session;
        isCreator = true;
    } else {
        _session = session;
    }
}

FMTask::~FMTask()
{
    del_p(_window);
    del_p(preTask);
    if(isCreator) {
        del_p(_session);
    }
}

QByteArray FMTask::doTask()
{
    qDebug() << __FUNCTION__;
    void (FMTask::*runFuns[])() = {
        copyPros,
        setWindow,
        showWindow,
        packagePOSRsp
    };

    int index = 0;
    for (void(FMTask::*fun)() : runFuns) {
        (this->*fun)();
        qDebug() << "Run over function: " << index++;
        if(error() != FM_API_SUCCESS) {
            qDebug() << QString("Task error %1: %2").arg(error()).arg(errorString());
            return QString(ErrorMsgJson).arg(error()).arg(errorString()).toUtf8();
        }
    }

    QJsonDocument json(posRspJsonObj);
    return json.toJson(QJsonDocument::Compact);
}

void FMTask::stopTask()
{
    qDebug() << __FUNCTION__;
    if(preTask != nullptr) {
        preTask->stopTask();
    }
    closeWindow();

    setError(FM_API_WINDOWCLOSE);
}

void FMTask::copyPros()
{
    qDebug() << __FUNCTION__;
    for (QString posPro : DefaultProps)
    {
        serverReqJsonObj[ServerProps(posPro)] = posReqJsonObj[posPro];
    }
}

void FMTask::showWindow()
{
    qDebug() << __FUNCTION__;
    QString sL[] = {
         PosProps.OperatorId,
         PosProps.BussinessDate,
     };

     for(QString s : sL) {
         _session->addData(s, posReqJsonObj[s].toString());
     }

    if(_window != nullptr) {
        _window->initWnd(this->session());
        int ret = _window->exec();
        if(ret == -1) {
            setError(FM_API_WINDOWCLOSE);
        }
    }
}

bool FMTask::sendToServer(bool isShowMsg)
{
    qDebug() << __FUNCTION__;
    // 固定部分
    serverReqJsonObj[PosProps.AppId] = APP_ID;
    serverReqJsonObj[PosProps.PartnerId] = PARTNER_ID;
    serverReqJsonObj[PosProps.T] = QString::number(QDateTime::currentMSecsSinceEpoch());
    serverReqJsonObj[ServerProps(PosProps.Fm_cmd)] = FM_Server_Type[FM_Type()];
    packageServerReq();

    QJsonDocument json(serverReqJsonObj);
    QByteArray data = json.toJson(QJsonDocument::Compact);

    FMApiCfg cfg;
    url = cfg.GetTransUrlFormat();
    url = url.arg(sign());

    FMNetwork net;
    QByteArray rspData = net.send(&url, &data);

    // 网络错误
    if(net.error() != FM_API_SUCCESS) {
        setError(net.error(), net.errorString());
    } else {
        QJsonParseError jsonErr;
        QJsonDocument rspJson = QJsonDocument::fromJson(rspData, &jsonErr);

        // Json错误
        if(jsonErr.error != QJsonParseError::NoError) {
            setError(FM_API_BADJSON);
        } else {
            serverRspJsonObj = rspJson.object();

            // 服务器返回的错误
            if(serverRspJsonObj.contains("errcode")) {
                setError(FM_API_SERVERERROR, serverRspJsonObj["errcode"].toInt(), serverRspJsonObj["errmsg"].toString());
            }
        }
    }

    qDebug() << "Server rsponse: " << serverRspJsonObj;


    if(_window != nullptr) {
        _window->setIsBusy(false);
    }

    bool isOk = (error() == FM_API_SUCCESS);
    if(!isOk && isShowMsg)
    {
        FMMsgWnd::FailureWnd(errorString());
    }

    return isOk;
}

void FMTask::closeWindow()
{
    if(_window != nullptr) {
        _window->close();
        del_p(_window);
    }
}

QJsonValue FMTask::searchJsonValue(QJsonObject &searchJson, QString searchKey)
{
    if(searchJson.contains(searchKey)) {
        return searchJson[searchKey];
    } else {
        for(QString key : searchJson.keys()) {
            if(searchJson[key].isObject()) {
                QJsonObject ob = searchJson[key].toObject();
                QJsonValue value = searchJsonValue(ob, searchKey);
                if(!value.isNull()){
                    return value;
                }
            }
        }
    }
    return QJsonValue();
}

QJsonValue FMTask::getServerJsonValue(const QString prop)
{
    return searchJsonValue(serverRspJsonObj, ServerProps(prop));
}

QJsonValue FMTask::getPosJsonValue(const QString prop)
{
    return searchJsonValue(posReqJsonObj, prop);
}

QString FMTask::createTransId()
{
    QString storeId = getPosJsonValue(PosProps.StoreId).toString();
    QString posId = getPosJsonValue(PosProps.PosId).toString();
    QString dateTime = QDateTime::currentDateTime().toString("yyyyMMddhhmmss");
    QString transId = dateTime + storeId + posId;
    return transId;
}

QString FMTask::sign() const
{
    qDebug() << __FUNCTION__;
    // 解析JSON插入MAP中按字典排序
    QMap<QString, QString> mapData;

    for (QString word : SignProps) {
        if(serverReqJsonObj[word].isDouble()) {
            mapData[word] = QString::number(serverReqJsonObj[word].toDouble());
        } else {
            mapData[word] = serverReqJsonObj[word].toString();
        }
    }

//    if (serverRspJsonObj[ServerProps(PosProps.Fm_cmd)].toString() == FM_Server_Type[FM_Fund]) {
//        mapData[ServerProps(PosProps.TransId)] = serverReqJsonObj[ServerProps(PosProps.TransId)].toString();
//    }

    // 使用URL键值对的格式拼接
    QString sb = "";
    foreach(QString key , mapData.keys())
    {
        sb += (key + "=" + mapData.value(key) + "&");
    }
    sb.remove(sb.length() - 1, 1);      // 去掉最后一个&

    sb.append(KEY_CODE);

    QByteArray bt;
    bt.append(sb);

    qDebug() << "Sign String: " << bt;

    QByteArray md5Bt = QCryptographicHash::hash(bt, QCryptographicHash::Md5);
    return md5Bt.toHex();
}
