#ifndef READER_HPP
#define READER_HPP

#include "global.h"
#include "readcfg.hpp"
#include "../fmvip_card_reader/fm_mwrf32/fm_mwrf32.h"
#include <QString>
#include <QObject>
#include <QThread>
#include <windows.h>

class Reader : public QObject
{
    Q_OBJECT
public:
    Reader()
    {
        s_end = true;
        r_end = false;
        s_initsuc = false;
        s_reader = NULL;
        this->moveToThread(&m_thread);
        m_thread.start();
    }

public slots:
    bool readVipNO()
    {
        QString vipNo;
        QString error;
        bool sign = false;
        //HANDLE s_reader = NULL;
        r_end = true;

        qDebug() <<  "son:" <<QThread::currentThreadId() << "s_initsuc:" << s_initsuc;

        if(s_end && !s_initsuc)
        {


            do
            {
                QVariantMap map;
                sign = ReadCfg::readvalueforheadlist(CFG_FILENAME, CFG_SECTION_READER, map);

                //qDebug() << map;

                if(sign)
                    sign =  ConnectDevice(map.value(CFG_READER_PORT).toInt(),
                                                 map.value(CFG_READER_BAUD).toInt(),
                                                 map.value(CFG_READER_SECTION).toInt(),
                                                 map.value(CFG_READER_PWD).toString(),
                                                 s_reader,
                                                 error);
                if(!sign)
                    s_reader = NULL;
                else
                   s_initsuc = sign;

                Sleep(500);
            }while(s_end && !sign);

        }

        qDebug() << "s_reader" << s_reader;

        while(s_end && !ReadCard(s_reader, 1, vipNo, error))
            Sleep(500);

        if(!s_end)
        {
            r_end = false;
            return false;
        }

        emit getVipNO(vipNo);
        r_end = false;
    }

    void disconnectReader()
    {
            s_end = false;
            while(r_end)
                Sleep(500);
            if(s_initsuc || s_reader > 0)
            {
                DisConnectDevice(s_reader);
                s_reader = NULL;
                s_initsuc = false;
            }
    }

signals:

    void getVipNO(QString VipNO);

private:
    bool s_end;
    bool r_end;
    bool s_initsuc;
    HANDLE s_reader;
    QThread m_thread;
};

#endif // READER_HPP

