#ifndef READCFG_HPP
#define READCFG_HPP

#include <QDebug>
#include <QString>
#include <QVariantMap>
#include <QSettings>
#include <QCoreApplication>

class ReadCfg
{
public:
    static bool readvalueforkey(const QString &cfgfilename, const QString &section, const QString &key, QString &value)
    {
        QString path = qApp->applicationDirPath() + "/" + cfgfilename;

        qDebug() << "read cfg file path:" << path;

        auto *configIniRead = new QSettings(path, QSettings::IniFormat);
        configIniRead->setIniCodec("utf-8");

        QString akey = "/" + section + "/" + key;
        value = configIniRead->value(akey).toString();

        delete configIniRead;

        return value == "" ? false : true;
    }

    static bool readvalueforheadlist(const QString &cfgfilename, const QString &section, QVariantMap &value)
    {
        QString path = qApp->applicationDirPath() + "/" + cfgfilename;
        QSettings *configIniRead = new QSettings(path, QSettings::IniFormat);
        configIniRead->setIniCodec("utf-8");
        QString akey = "/" + section + "/" + "headlist";
        QStringList keylist = configIniRead->value(akey).toString().split(",");

        if(keylist.size() == 0 || keylist[0] == "")
        {
            qDebug() << QString("read %1 file %2 section for headlist failed").arg(path).arg(section);
            return false;
        }

        foreach (auto key, keylist)
        {
            QString tmpkey = "/" + section + "/" + key;
            if(configIniRead->value(tmpkey).toString() != "")
                value.insert(key, configIniRead->value(tmpkey).toString());
        }

        delete configIniRead;
        return (value.size() == 0)? false : true;
    }
};

#endif // READCFG_HPP

