#ifndef FMHTTPCLIENT_H
#define FMHTTPCLIENT_H

#include <Windows.h>
#include <tchar.h>
#include <winhttp.h>

#include <map>

#include <fmutils/fmutils.hpp>

class FMHttpClient
{
public:
    explicit FMHttpClient(LPCWSTR url);
    explicit FMHttpClient(LPCSTR url);
    ~FMHttpClient();

    enum FMHttpMethod {
        FMHTTP_GET = 11,
        FMHTTP_POST,
        FMHTTP_PUT,
        FMHTTP_DELETE
    };

    BOOL        Send(LPVOID data = NULL, INT data_len = 0, FMHttpMethod method = FMHTTP_GET);
    const char* Read();

    VOID        SetHeaders(LPCWSTR headers);
    LPCWSTR     GetHeaders() const;

private:
    BOOL        _CrackUrl(LPWSTR url);
    HINTERNET   _Connect();
    BOOL        _Request(LPVOID data, INT data_len);

    VOID        _Save();

private:
    HINTERNET   _session;
    HINTERNET   _connection;
    HINTERNET   _request;

    WCHAR       _server[256];
    WCHAR       _object[256];
    WCHAR       _version[16];

    WCHAR       _headers[256];

    WCHAR       _agent[256];
    WCHAR       _accept_types[256];
    WCHAR       _content_type[48];
    USHORT      _port;
    

    INT         _method;
    INT         _status;

    // !Methods
    WCHAR       _method_get[8];
    WCHAR       _method_post[8];
    WCHAR       _method_put[8];
    WCHAR       _method_del[8];

    bool        _is_file;
    TCHAR       _filename[260];
    
    std::map<int, LPWSTR> _method_map;
    // 
    FMBuffer    _response;
};

#endif // FMHTTPCLIENT_H