#ifndef FMAPICFG_H
#define FMAPICFG_H

#include "fmapidef.h"
#include <map>

class FMApiRelay;

typedef std::map<LPCSTR, LPCSTR> FMApiPropMap;

//////////////////////////////////////////////////////////////////////////
//
//! Confituration class
//
//////////////////////////////////////////////////////////////////////////
class FMApiCfgPrivate;

class FMVIP_DECL FMApiCfg
{
    FM_DECLARE_PRIVATE(FMApiCfg)
    friend class FMApiRelay;
public:
    FMApiPropMap           *GetPropsMap();
    const char*             GetTransUrlFormat();
    explicit                FMApiCfg(LPCSTR file = NULL);
    ~FMApiCfg();

private:   
    FMApiCfgPrivate* const  d_ptr;
};

//////////////////////////////////////////////////////////////////////////
class FMApiCfgPrivate
{
    FM_DECLARE_PUBLIC(FMApiCfg)
public:
    explicit FMApiCfgPrivate(FMApiCfg *parent, LPCSTR file = NULL);
    ~FMApiCfgPrivate();

    VOID                Load();

    //! 
    char                _app_name[64];
    char                _sections[2048];
    char                _file[MAX_PATH];
    CRITICAL_SECTION    _cfg_cs;

    //! Properties
    FMApiPropMap        _prop_map;

    char                _trans_url[1024];
    //!
    FMApiCfg * const    q_ptr;
};

#endif //! FMAPICFG_H