﻿#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "../fm_mwrf32/fm_mwrf32.h"
#include <QDebug>
#include <QCryptographicHash>

#define ReadS 4
#if 1
#define ReadP "ffffffffffff"
#else
#define ReadP "313731383132"
#endif

HANDLE handle;
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->pbt1->setEnabled(false);
    ui->pbt1_2->setEnabled(false);
    ui->pbt2->setEnabled(false);

    connect(&m_worker, SIGNAL(activeted(bool, QString)), this, SLOT(onActivated(bool, QString)));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pbt0_clicked()
{
    QString error;
    if(ConnectDevice(0, 115200, ReadS, ReadP, handle, error))
    {
        ui->label->setText("连接设备成功!");
        ui->pbt1->setEnabled(true);
        ui->pbt2->setEnabled(true);
    }else
    {
        ui->label->setText("连接设备失败!" + error);
        qDebug() << error;

    }
}

void MainWindow::on_pbt1_clicked()
{
    m_worker.SetHandle(handle);
    m_worker.start();
    ui->pbt1->setEnabled(false);
    ui->pbt1_2->setEnabled(true);
    ui->pbt2->setEnabled(false);
}

void MainWindow::on_pbt2_clicked()
{
    QString error;
    QString vipNo;
    QString uuid;
    if(ReadCard(handle, ReadS, vipNo, uuid, error))
    {
        ui->label_3->setText(uuid + "###" + vipNo);
    }else
    {
        ui->label_3->setText(error);
    }
}

void MainWindow::onActivated(bool result, QString error)
{
    if(result)
    {
        ui->label_2->setText("激活成功!");
    }else
    {
        ui->label_2->setText(error);
    }
}

void MainWindow::on_pbt1_2_clicked()
{
    m_worker.Stop();
    ui->pbt1->setEnabled(true);
    ui->pbt1_2->setEnabled(false);
    ui->pbt2->setEnabled(true);
}

void MainWindow::on_write_btn_clicked()
{
    QString error;
    if(WriteCard(handle, 2, ui->write_line->text(), error))
    {
        qDebug() << "写入成功";
    } else {
        qDebug() << "写入失败：" << error;
    }
}
