﻿#ifndef FMVIPORDER_H
#define FMVIPORDER_H
#include <QListWidgetItem>
#include "fmvipwnd.h"
#include "global.h"

class FMNumPad;

namespace Ui {
class FMVipOrder;
}

class FMVipOrder : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMVipOrder(QDialog *parent = 0);
    ~FMVipOrder();

    bool initWnd(Session *session);
    void initCouponItems();
    void setWillPayText();

signals:
    void    pay();

public slots:
    void    on_pay_btn_clicked();
//    void    on_pay_chk_clicked(bool checked);

    void    on_clean_numpad();
    void    onItemClicked(QListWidgetItem*);

    void    on_edit_change(QString numkey);
    void    on_delete_clicked();
    void    on_clear_clicked();
    void    on_confirm_clicked();

private slots:
    void on_coupon_prev_btn_clicked();

    void on_coupon_next_btn_clicked();

    void on_pay_edit_textChanged(const QString &text);

    void on_pay_key_clicked();

private:
    class OrderInfo
    {
    public:
        OrderInfo()
        {
            _amountStr = _needPayStr = "";
            _amount = _score = _needPay = _maxWillPay = _useScore = _couponAmount = 0;
        }
        OrderInfo(QString amountStr, int score, QString needPayStr)
        {
            this->_amountStr = amountStr;
            this->_needPayStr = needPayStr;

            _amount = _amountStr.toInt() / 100.0;
            _score = score / 100.0;
            _needPay = _needPayStr.toInt() / 100.0;

            _maxWillPay = _useScore = _couponAmount = 0;
            setMaxWillPay();
        }

        QString getAmountStr()
        {
            return DOUBLE_STR(_amount);
        }

        QString getNeedPayStr()
        {
            return DOUBLE_STR(_needPay);
        }

        QString getScoreAmount()
        {
            return DOUBLE_STR(MIN(_score, _needPay));
        }

        QString getPayAmountStr(QString amountStr)
        {
            double payAmount = MIN(_needPay, (amountStr.toDouble() + _couponAmount + _useScore)) * 100;
            return QString::number(payAmount);
        }

        // 代金券总额超过待付时返回true
        bool enoughCoupon()
        {
            _couponAmount = 0.0;
            for(auto coupon : selectCouponMap)
            {
                _couponAmount += coupon.disAmount;
            }
            bool isEnough = (_couponAmount > _needPay);
            setMaxWillPay();
            return isEnough;
        }

        void setUseScore(bool isUse)
        {
            if(isUse) {
                _useScore = MIN(_score, _needPay);
            } else {
                _useScore = 0;
            }
            setMaxWillPay();
        }

        // 设置付款金额的最大值
        void setMaxWillPay()
        {
            double willPay = _needPay - _useScore - _couponAmount;
            _maxWillPay = MIN(MAX(willPay, 0), _amount);
        }
        double getMaxWillPay()
        {
            return _maxWillPay;
        }

        /// 代金券列表
        void setCouponMap(QMap<QString, Coupon> couponMap)
        {
            this->_couponMap = couponMap;

            _maxPage = (couponMap.count() - 1) / 6 + 1 ;
            _nowPage = -1;
        }

        QMap<QString, Coupon> couponMap()
        {
            return _couponMap;
        }

        QMap<QString, Coupon> selectCouponMap;

    private:
        QString _amountStr, _needPayStr;
        double _amount, _score, _needPay;
        QMap<QString, Coupon> _couponMap;
        int _maxPage, _nowPage;
        // 代金券金额    使用积分金额     余额将付金额
        double _couponAmount, _useScore, _maxWillPay;
    };

private:
    Ui::FMVipOrder *ui;

    FMVipOrder::OrderInfo *orderInfo;

    QString oldPayText;

    FMNumPad *numpad;

};

#endif // FMVIPORDER_H
