﻿#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "fmcouponwidget.h"
#include "ui_fmviporder.h"
#include "fmnumpad.h"
#include <QScrollBar>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    numpad = NULL;
    ui->setupUi(this);
}

FMVipOrder::~FMVipOrder()
{
    del_p(orderInfo);
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
    delete ui;
}

bool FMVipOrder::initWnd(Session *session)
{
    this->_session = session;

    QString operator_id = session->data(PosProps.OperatorId).toString();
    QString business_date = session->data(PosProps.BussinessDate).toString();
    QString fm_id = session->data(PosProps.Account).toString();
    QString name = session->data(PosProps.Name).toString();
    QString birthday = session->data(PosProps.Birthday).toString();

    QString amount_str = QString::number(session->data(PosProps.Amount).toInt());
    QString score_str = QString::number(session->data(PosProps.Score).toInt());

    int needPay = session->data(PosProps.OrderAmount).toInt() - session->data(PosProps.PaidAmount).toInt();
    QString needPay_str = QString::number(needPay);
    double standard_amount = session->data(PosProps.StandardAmount).toInt() / 100.0;

    int socre_value = session->data(PosProps.Score_value).toInt();
    orderInfo = new FMVipOrder::OrderInfo(amount_str, socre_value, needPay_str);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);
    ui->bir_label->setText(birthday);

    initCouponItems();

//    ui->pay_chk->setText(QString("使用积分抵用 %1 元").arg(orderInfo->getScoreAmount()));

    if(standard_amount > 0) {
        ui->standard_label->setText(QString("满 %1 元可享受储值金满额优惠").arg(standard_amount));
    } else {
        ui->standard_label->setText("");
    }

    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    ui->pay_edit->setText(oldPayText);
    QRegExp regexp("^[0-9]+(.[0-9]{2})?$");
    ui->pay_edit->setValidator(new QRegExpValidator(regexp));
    setWillPayText();
    return true;
}

void FMVipOrder::on_pay_btn_clicked()
{
    session()->addData(PosProps.CouponMap, orderInfo->selectCouponMap);
    QString codeAmountStr = orderInfo->getPayAmountStr(ui->pay_edit->text());
    session()->addData(PosProps.CodeAmount, codeAmountStr.toInt());

    this->setEnabled(false);

    setIsBusy(true);

    emit pay();
}

//void FMVipOrder::on_pay_chk_clicked(bool checked)
//{
//    int is = checked ? 1 : 0;
//    session()->addData(ServerProps(PosProps.IsUseScore), is);
//    orderInfo->setUseScore(checked);
//    setWillPayText();
//}

void FMVipOrder::onItemClicked(QListWidgetItem *item)
{
    QString newItemCode = item->data(Qt::UserRole).toString();
    QString oldItemCode = "";
    if(!orderInfo->selectCouponMap.isEmpty()) {
        oldItemCode = orderInfo->selectCouponMap.firstKey();
    };

    // 将原来选中的代金券置为未选中状态，从选中map中移除
    for(int i=0; i<ui->coupon_page->count(); ++i) {
        auto tempItem = ui->coupon_page->item(i);
        if(tempItem->data(Qt::UserRole).toString() == oldItemCode) {
            ui->coupon_page->itemWidget(tempItem)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
            orderInfo->selectCouponMap.remove(oldItemCode);
            orderInfo->enoughCoupon();  // 计算一下当前代金券金额
        }
    }
    if(newItemCode != oldItemCode) {
        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
        orderInfo->selectCouponMap[newItemCode] = orderInfo->couponMap()[newItemCode];
        if(orderInfo->enoughCoupon())
        {
            FMMsgWnd::WarningWnd("请注意代金券总额已超过待付金额！");
        }
    }

//    QString code = item->data(Qt::UserRole).toString();

//    // 如果代金券已被选中则取消，否则选中
//    if(orderInfo->selectCouponMap.contains(code)) {
//        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
//        orderInfo->selectCouponMap.remove(code);
//        orderInfo->enoughCoupon();  // 计算一下当前代金券金额
//    }else{
//        ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
//        orderInfo->selectCouponMap[code] = orderInfo->couponMap()[code];
//        if(orderInfo->enoughCoupon())
//        {
//            FMMsgWnd::WarningWnd("请注意代金券总额已超过待付金额！");
//        }
//    }
    setWillPayText();
}

void FMVipOrder::initCouponItems()
{
    orderInfo->setCouponMap(_session->getCouponMap(PosProps.CouponMap));

    for(Coupon coupon : orderInfo->couponMap().values())
    {
        auto item = new QListWidgetItem();
        item->setData(Qt::UserRole, coupon.code);
        auto itemWidget = new FMCouponWidget(coupon);
        //item大小
        item->setSizeHint (itemWidget->size());

        ui->coupon_page->addItem(item);
        ui->coupon_page->setItemWidget(item, itemWidget);
    }

    if(ui->coupon_page->count() > 0) {
        connect(ui->coupon_page, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(onItemClicked(QListWidgetItem*)));
    }
    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::setWillPayText()
{
    on_pay_edit_textChanged(oldPayText);

    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}

void FMVipOrder::on_pay_edit_textChanged(const QString &text)
{
    double num = text.toDouble();
    double maxPay = orderInfo->getMaxWillPay();
    if (num > maxPay) {
        ui->pay_edit->setText(DOUBLE_STR(maxPay));

        QString maxPay_info = "余额只需支付 %1 元";
        if (maxPay >= orderInfo->getAmountStr().toDouble()) {
            maxPay_info = "余额最多支付 %1 元";
        }
        ui->pay_max->setText(maxPay_info.arg(maxPay));

        ui->pay_edit->setFocus();
        ui->pay_edit->selectAll();
    } else {
        oldPayText = text;
        ui->pay_max->setText("");
    }
}

void FMVipOrder::on_pay_key_clicked()
{
    if(numpad == NULL)
    {
        numpad = new FMNumPad(this);
        connect(numpad, &FMNumPad::finished, this, &FMVipOrder::on_clean_numpad);
        connect(numpad, &FMNumPad::digit_click, this, &FMVipOrder::on_edit_change);
        connect(numpad, &FMNumPad::digit_delete, this, &FMVipOrder::on_delete_clicked);
        connect(numpad, &FMNumPad::digit_clear, this, &FMVipOrder::on_clear_clicked);
        connect(numpad, &FMNumPad::digit_confirm, this, &FMVipOrder::on_confirm_clicked);
        numpad->show();
        numpad->setGeometry(x() + width()/2-20, numpad->y()+100, numpad->width(), numpad->height());
    } else {
        numpad->close();
        delete numpad;
        numpad = NULL;
    }
}

void FMVipOrder::on_clean_numpad()
{
    if(numpad != NULL)
    {
        delete numpad;
        numpad = NULL;
    }
}

void FMVipOrder::on_edit_change(QString numkey)
{
     ui->pay_edit->setText(ui->pay_edit->text() + numkey);
}

void FMVipOrder::on_delete_clicked()
{
    int length = ui->pay_edit->text().size();
    if(length <= 1)
        ui->pay_edit->setText(QString(""));
    else
        ui->pay_edit->setText(ui->pay_edit->text().left(length - 1));
}

void FMVipOrder::on_clear_clicked()
{
    ui->pay_edit->setText(QString(""));
}
void FMVipOrder::on_confirm_clicked()
{
    on_pay_btn_clicked();
}

