﻿#include "taskothers.h"

/// 优惠券查询
TaskCoupon::TaskCoupon(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Coupon, session, parent)
{

}

void TaskCoupon::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);

    QJsonObject transaction;
    transaction[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    transaction[ServerProps(PosProps.PaidAmount)] = getPosJsonValue(PosProps.OrderAmount);
    // 产品列表
    QJsonArray propducts;
    for(auto pValue : getPosJsonValue(PosProps.Products).toArray())
    {
        auto po = pValue.toObject();
        QJsonObject spo;
        for(auto prop : {PosProps.ConsumeNum, PosProps.Price, PosProps.ProductId}) {
            spo[ServerProps(prop)] = po[prop];
        }
        propducts.append(spo);
    }
    transaction[ServerProps(PosProps.Products)] = propducts;

    serverReqJsonObj[ServerProps(PosProps.Transaction)] = transaction;
}

void TaskCoupon::packagePOSRsp()
{
    for(auto prop : {PosProps.Fm_open_id, PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }

    QMap<QString, QVariant> couponMap;
    for (auto value : getServerJsonValue(PosProps.CouponList).toArray())
    {
        QJsonObject couponOb = value.toObject();
        QString code = couponOb[ServerProps(PosProps.Coupon_code)].toString();
        double amount = couponOb[ServerProps(PosProps.Coupon_disAmount)].toInt() / 100.0;
        QString desc = couponOb[ServerProps(PosProps.Coupon_name)].toString();

        Coupon c{code, amount, desc};
        QVariant v;
        v.setValue(c);
        couponMap[code] = v;
    }
    session()->addData(PosProps.CouponMap, couponMap);
}


/// 退款
TaskRefundPay::TaskRefundPay(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Order_Revoke, 0, parent)
{

}

void TaskRefundPay::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.Fm_id)] = getPosJsonValue(PosProps.Fm_id);
}

void TaskRefundPay::packagePOSRsp()
{
    for(auto prop : {PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}


/// 退单
TaskRefundOrder::TaskRefundOrder(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Order_Refund, 0, parent)
{

}

void TaskRefundOrder::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.Fm_id)] = getPosJsonValue(PosProps.Fm_id);
}

void TaskRefundOrder::packagePOSRsp()
{
    for(auto prop : {PosProps.StatusCode, PosProps.Msg}) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}
