﻿#ifndef SESSION_H
#define SESSION_H

#include <QVariant>
#include "global.h"

// 代金券结构体
struct Coupon
{
    QString code;
    double disAmount;
    QString desc;
};
Q_DECLARE_METATYPE(Coupon)      // 使Coupon类型可以和QVariant类型互相转换

class Session
{
public:
    Session();
    Session(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
    }

    ~Session();

    Session &operator =(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
        return *this;
    }

    QVariant data(const QString key) const;

    void addData(const QString key, const QVariant value);
    void addData(const QString key, const QMap<QString, Coupon> couponMap);
    bool contains(const QString key) {return _sessionDataMap.contains(key);}
    QMap<QString, Coupon> getCouponMap(const QString key);

    QMap<QString, QVariant> sessionDataMap() const { return this->_sessionDataMap;}
    void setSessionDataMap(const QMap<QString, QVariant> &dataMap) {this->_sessionDataMap = dataMap;}
private:
    QMap<QString, QVariant>  _sessionDataMap;
};

#endif // SESSION_H
