#ifndef FMTASK_H
#define FMTASK_H
#include "fmvipwnd.h"
#include "fmmsgwnd.h"
#include "session.h"
#include <QObject>
#include <QJsonObject>
#include <QJsonArray>
#include <QDebug>

class FMTask : public QObject
{
    Q_OBJECT
public:
    explicit FMTask(QJsonObject &jsonObj, FM_TYPE fmType, Session *session = 0, QObject *parent = 0);
    ~FMTask();

    virtual QByteArray doTask();
    virtual void stopTask();

    void closeWindow();

    void setFM_Type(const FM_TYPE fmType) {_FM_Type = fmType;}
    FM_TYPE FM_Type() const { return _FM_Type;}

    Session* session() const {return _session;}

    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);
    QString createTransId();

    QJsonObject* getPosRspJsonObj() {return &posRspJsonObj;}

protected:
    // 从配置文件中拷贝数据信息
    void copyPros();
    virtual void setWindow(){}
    virtual void showWindow();
    virtual void packageServerReq() = 0;
    virtual bool sendToServer(bool isShowMsg = true);
    virtual void packagePOSRsp() = 0;

protected:
    QJsonObject posReqJsonObj;
    QJsonObject posRspJsonObj;
    QJsonObject serverReqJsonObj;
    QJsonObject serverRspJsonObj;
    FMVipWnd    *_window;
    Session     *_session;
    FM_TYPE     _FM_Type;

    QString     url;

    FMTask      *preTask;

    bool        isCreator;

private:
    QString sign() const;

    DefError
};

#endif // FMTASK_H
