﻿#include "fmbackup.h"
#include "fmlogger.h"
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlError>
#include <QDir>
#include <QFile>
#include <QApplication>

FMBackup::FMBackup()
{
    connect();
}

FMBackup* FMBackup::instance()
{
    static FMBackup _instance;
    return &_instance;
}

bool FMBackup::connect()
{
    bool isOk;
    QString backupPath = qApp->applicationDirPath()+"/backup/";
    QDir dir;
    if(!dir.exists(backupPath)) {
        dir.mkdir(backupPath);
    }
    QString dbname = backupPath + "backup.db";
    if(!QFile::exists(dbname)) {
        isOk = createTable(dbname);
    } else {
        _db = QSqlDatabase::addDatabase("QSQLITE");
        _db.setDatabaseName(dbname);
        isOk =_db.open();
    }

    FM_INFO() << "连接数据库：" << dbname;
    if(!isOk) {
        setError("连接数据库失败：" + _db.lastError().text());
    }

    return isOk;
}

bool FMBackup::createTable(const QString &dbname)
{
    _db = QSqlDatabase::addDatabase("QSQLITE");
    _db.setDatabaseName(dbname);
    _db.open();
    QSqlQuery query(_db);
    //  创建表
    bool isOk = query.exec("create table tbl_recharge("
                           "id integer PRIMARY KEY autoincrement,"
                           "card_no char(20) NOT NULL,"
                           "inner_no char(20),"
                           "recharge_amount double,"
                           "after_amount double,"
                           "fm_id char(25),"
                           "recharge_date char(10), "
                           "recharge_time char(8))");

    FM_DEBUG() << "创建表：" << dbname;
    if (!isOk) {
        setError("创建表失败：" + query.lastError().text());
    }
    return isOk;
}

bool FMBackup::insert(QString card_no, QString inner_no,
                      double recharge_amount, double after_amount,
                      QString fm_id,
                      QString date, QString time)
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("insert into tbl_recharge("
                                   "'card_no',"
                                   "'inner_no',"
                                   "'recharge_amount',"
                                   "'after_amount',"
                                   "'fm_id',"
                                   "'recharge_date',"
                                   "'recharge_time') values('%1','%2', '%3', '%4', '%5', '%6', '%7');")
                           .arg(card_no)
                           .arg(inner_no)
                           .arg(recharge_amount)
                           .arg(after_amount)
                           .arg(fm_id)
                           .arg(date)
                           .arg(time));
    if(!isOk) {
        setError("插入失败：" + query.lastError().text());
    }

    return isOk;
}

QSqlQuery FMBackup::cardQuery(QString date)
{
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("select * from tbl_recharge where 'date'='%1'").arg(date));
    if(!isOk) {
        setError("查询数据时出现错误：" + query.lastError().text());
    }
    return query;
}

bool FMBackup::reset()
{
    QSqlQuery query(_db);
    bool isOk = query.exec("VACUUM");
    setError("数据库重置: " + isOk ? "成功" : "失败");
    return isOk;
}

void FMBackup::setError(const QString &error)
{
    _error = error;
    FM_ERROR() << error;
}

QString FMBackup::lastError() const
{
    return _error;
}
