﻿#include "fmaboutwnd.h"
#include "ui_fmaboutwnd.h"
#include <QFile>

FMAboutWnd::FMAboutWnd(FMVipWnd *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMAboutWnd)
{
    ui->setupUi(this);
}

FMAboutWnd::~FMAboutWnd()
{
    delete ui;
}

void FMAboutWnd::About()
{
    QString versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        QTextStream in(&versionFile);
        versionInfo = in.readLine();
    } else {
        versionInfo = "未知";
    }
    versionFile.close();
    ui->version_lab->setText("版本：" + versionInfo);
    this->exec();
}

void FMAboutWnd::on_close_btn_clicked()
{
    this->close();
}
