#include "couponkeypad.h"
#include "ui_couponkeypad.h"

CouponKeypad::CouponKeypad(QWidget *parent, Qt::WindowFlags f) :
    QDialog(parent, f),
    ui(new Ui::CouponKeypad)
{
    ui->setupUi(this);
    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);

    connect(ui->d0, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d1, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d2, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d3, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d4, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d5, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d6, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d7, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d8, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
    connect(ui->d9, SIGNAL(clicked(bool)), SLOT(onDigitClicked()));
}

CouponKeypad::~CouponKeypad()
{
    delete ui;
}

void CouponKeypad::on_btnOK_clicked()
{
    code = ui->text->text();
    accept();
}

void CouponKeypad::on_btnCancel_clicked()
{
    reject();
}

void CouponKeypad::on_btnDelete_clicked()
{
    QString text = ui->text->text();
    text = text.mid(0, text.length() - 1);
    ui->text->setText(text);
}

void CouponKeypad::on_btnClear_clicked()
{
    ui->text->setText("");
}

void CouponKeypad::onDigitClicked()
{
    QPushButton *btn = qobject_cast<QPushButton*>(sender());
    ui->text->setText(ui->text->text() + btn->text());
}