﻿#ifndef FMP_REDEEM_H
#define FMP_REDEEM_H

#include "fmtask.h"
#include <QJsonObject>
#include <QJsonArray>
#include <QObject>

class FMPRedeem : public FMTask
{
    Q_OBJECT    
    enum {
        FM_API_SUCCESS = 100,
        FM_API_ERROR,
        FM_API_TIMEOUT,
        FM_API_BADJSON,
        FM_API_NETWORKERROR,
        FM_API_SERVERERROR,
        FM_API_WINDOWCLOSE,
        FM_API_TYPEERROR
    };

public:
    explicit            FMPRedeem(QJsonObject &jsonObj, QObject* parent = 0);
    virtual             ~FMPRedeem();

    QJsonObject         Redeem(const QJsonObject& request); //券码核销
    QJsonObject         Reverse(QJsonObject request);
    QJsonObject         GetRedeemJson()const;
    
    QByteArray          doTask();
    
protected:
    virtual void packageServerReq(){}
    virtual void packagePOSRsp(){}
    
private:
    QJsonObject         SendRequest(const QByteArray &reqData);
    QJsonObject         ShowForUnConsum(QJsonObject json);
    QJsonObject         ShowForHasConsum(QJsonObject json);
    QJsonObject         ShowForInvalid(QJsonObject json);
    QJsonObject         ShowForExpird(QJsonObject json);
    QJsonObject         ShowForErr(QJsonObject json);
    QJsonObject         ShowForMismatch(QJsonObject json);
    int                 ZH_caclChkValue(char * pJsonData, int startPos, int endPos);
    QByteArray          CheckSendArray( QByteArray & jsonArray);
    QJsonValue          SearchJsonObject(QJsonObject& searchJson, QString searchKey);
    QJsonValue          SearchJsonArray(QJsonArray& searchJson, QString searchKey);
private:
    QString             _store_id;
    QString             _station_id;
    QString             _operator_id;
    QString             _coupon;
    int                 _partner_id;
    QString             _url;
    QJsonArray          _products_info;
    QJsonObject         _redeem_json; //存放核销请求字符串
    int                 _clientReqCount;
};

#endif // FMP_REDEEM_H

