﻿#ifndef GLOBAL_H
#define GLOBAL_H
#include <QObject>
#include <QApplication>
#include <string>
#include "fmapicfg.h"
#include "fmapidef.h"

// 商家信息
#define APP_ID           "T008"
#define PARTNER_ID       "17ef7396-4c56-4e08-9f3f-5cba520234d6"
#define KEY_CODE         "ad124d4e-5f5a-450b-aa4b-902dfdb4631e"
//#define PARTNER_ID       "a8bee0dd-09d1-4fa9-a9eb-80cb36d3d611"

#define COUPON_SERVER "Coupon/Server"
#define PAY_PARTNER_ID 1224

// 请求类型链表
const static QStringList FM_Type_List = QString(
            "member_manage_request,"
            "confirm_recharge_request,"
            "member_check_request,"
            "order_request,"
            "integral_request,"
            "order_refund_request").split(",");
// 服务端请求类型
const static QStringList FM_Server_Type = QString(
            "member_manage_request,"
            "order_rechargeprint_request,"
            "member_check_request,"
            "order_request,"
            "integral_request,"
            "order_correct_request,"
            "order_recharge_request,"
            "order_cardlock_request,"
            "order_cardactive_request,"
            "order_coupon_request,"
            "order_refund_request").split(",");

// 请求类型的枚举值
enum FM_TYPE {
    FM_Manage,
    FM_Confirm_Recharge,     // 确认充值结果，获取打印信息
    FM_Login,
    FM_Pay,
    FM_Final,
    FM_Order_Refund,
    FM_Fund,
    FM_Card_Lock,
    FM_Card_Active,
    FM_Coupon,
    FM_Reversal,     // 充值、支付冲正
    FM_NotVipCoupon = 10032 //非VIP卡券核销请求
};

enum Member_Type {
    Unknow = 0,
    PayCode,
    Phone,
    Account,
    EntityCard,
    OriginalCard
};

// 根据POS属性名,从配置文件中读取服务属性名
class FMPropsMap
{
public:
    const static QString get(const QString posProp) {
        return FMPropsMap::get(posProp.toStdString().c_str());
    }
    const static QString get(LPCSTR posProp) {
        static FMApiCfg cfg;
        static FMApiPropMap *pm = cfg.GetPropsMap();

        for (auto iter=pm->begin(); iter!=pm->end(); ++iter) {
            if(strcmp(posProp, iter->first) == 0) {
                return iter->second;
            }
        }
        return posProp;
    }
};
#define ServerProps(posProp) FMPropsMap::get(posProp)

// JSON数据各字段名称
struct{
    const QString AppId             = "appId";
    const QString PartnerId         = "partner_id";
    const QString T                 = "t";
    const QString StoreId           = "store_id";
    const QString PosId             = "pos_id";
    const QString OperatorId        = "operator_id";
    const QString BussinessDate     = "business_date";
    const QString Fm_cmd            = "fm_cmd";
    const QString FM_Type           = "FM_Type";
    const QString TransId           = "trans_id";
    const QString Member_sign       = "member_sign";
    const QString Member_type       = "member_type";
    const QString IsActive          = "is_active";
    const QString Inner_code        = "inner_code";
    const QString Max_recharge_value= "max_recharge_value";
    const QString Min_recharge_value= "min_recharge_value";

    const QString Name              = "name";
    const QString Birthday          = "birthday";
    const QString Amount            = "amount";
    const QString Mobile            = "mobile";
    const QString Account           = "account";
    const QString Fm_open_id        = "fm_open_id";
    const QString Fm_unique_id      = "fm_unique_id";
    const QString CanPay            = "CanPay";

    const QString Score             = "score";
    const QString Score_value       = "score_value";

    const QString StatusCode        = "statusCode";
    const QString Msg               = "msg";
    const QString Prompt            = "prompt";

    const QString Coupon            = "coupon";         // 优惠券查询时的优惠券号

    // 支付
    const QString CodeAmount        = "codeAmount";
    const QString ScoreAmount       = "scoreAmount";
    const QString IsUseScore        = "isUseScore";
    const QString Coupons           = "coupons";
    const QString Transaction       = "transactions";
    const QString OrderAmount       = "order_amount";
    const QString PaidAmount        = "paid_amount";
    const QString NeedAmount        = "need_amount";
    const QString StandardAmount    = "standard_amount";
    const QString UndisAmount       = "undis_amount";
    const QString Fm_id             = "fm_id";
    // 支付方式
    const QString Pay_ids           = "pay_ids";
    const QString Pay_id            = "pay_id";
    const QString Pay_str           = "pay_str";
    const QString Paid_total_amount = "paid_total_amount";
    const QString Pay_type          = "third_pay_type";
    const QString Pay_transId       = "pay_transid";
    const QString CouponList        = "couponList";     // 代金券列表
    const QString Coupon_code       = "code";           // 优惠券 / 代金券编码
    const QString Coupon_disAmount  = "disAmount";      // 代金券抵扣金额
    const QString Coupon_desc       = "desc";           // 代金券描述
    const QString Coupon_name       = "name";           // 优惠券名
    const QString Coupon_compatible = "compatible_flag";// 是否可叠加
    const QString Coupon_limitAmount= "limit_amount";   // 满额条件
    const QString CouponMap         = "payCouponMap";   // 代金券map
    // 产品
    const QString Products          = "products";
    const QString ConsumeNum        = "consume_num";
    const QString Price             = "price";
    const QString ProductId         = "pid";

    const QString Print1            = "print1";
    const QString Print2            = "print2";

    // 充值
    const QString ChargeAmount      = "charge_amount";
    const QString CashAmount        = "cashAmount";
    const QString Print             = "print";
    const QString ThirdAmount       = "thirdAmount";
    const QString AuthAccount       = "auth_account";
    const QString BeforeValue       = "before_value";
    const QString AfterValue        = "after_value";
    const QString FundInfo          = "fund_info";
    const QString Discount          = "discount";
    const QString RechargeStatus    = "recharge_status";

    // 卡激活锁定
    const QString CardUUID          = "CardUUID";
    const QString CardNo            = "card_no";
    const QString CardStatus        = "card_status";
    const QString CardStatusDesc    = "card_status_desc";
    const QString Passward          = "passward";

}PosProps;

// 签名字段
const static QString SignProps[] = {
    PosProps.AppId,
    PosProps.PartnerId,
    PosProps.T,
    ServerProps(PosProps.Fm_cmd),
    ServerProps(PosProps.StoreId),
    ServerProps(PosProps.PosId),
    ServerProps(PosProps.OperatorId)
};

// 默认要从POS请求中拷贝到服务请求的字段
const static QString DefaultProps[] = {
    PosProps.StoreId,
    PosProps.PosId,
    PosProps.OperatorId,
    PosProps.BussinessDate
};

// 删除指针宏
#define del_p(p)                \
        if ((p) != nullptr) {   \
            delete p;           \
            p = nullptr;        \
        }                       \

// 错误信息
typedef unsigned int FMError;
#define DefError                                                    \
    public:                                                         \
        FMError error() const {return _error;}                      \
        void setError(const FMError error)                          \
        { _error = error; _errorMsg = "";}                          \
        void setError(const FMError error, const QString errorMsg)  \
        { _error = error; _errorMsg = errorMsg;}                    \
        void setError(const FMError error, const int errorCode, const QString errorMsg)     \
        { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}      \
        QString errorString() {                                     \
            if(fm_error.find(_error) == fm_error.end()) {           \
                return "Undefine Error";                            \
            } else {                                                \
                if(_errorMsg != "")                                 \
                    return _errorMsg;                               \
                return fm_error.at(_error);                         \
            }                                                       \
        }                                                           \
    private:                                                        \
        FMError _error = FM_API_SUCCESS;                            \
        QString _errorMsg;

// 返回错误信息的json
#define ErrorMsgJson    "{\"statusCode\":%1,\"msg\":\"%2\",\"prompt\":0}"
#define ErrorNeedPayCode "fmv:请使用支付码付款"

#define AppDirPath qApp->applicationDirPath()

#define QuitCMD "{\"reqType\":-1}"

#define MIN(a,b) ((a<b) ? a : b)
#define MAX(a,b) ((a<b) ? b : a)
#define DOUBLE_STR(num) QString::number((num), 'f', 2)

#endif // GLOBAL_H
