﻿#ifndef FMVIPDISPATCHER_H
#define FMVIPDISPATCHER_H

#include <QObject>
#include <QMutex>
#include <QWaitCondition>
#include <QSystemTrayIcon>
#include <QJsonObject>
#include "fmapirelay.h"

class FMTask;

class FMVipDispatcher : public QObject, public FMApiRelay
{
    Q_OBJECT
public:
    explicit FMVipDispatcher(QObject *parent = 0);
    ~FMVipDispatcher();

    void createSysIcon();

private:
    QMutex mutex;
    QWaitCondition condition;
    QByteArray reqData;
    QByteArray rspData;

    QSystemTrayIcon _sysIcon;

    QTimer *_posSocketTimer;
    QTimer *_confirmRechageTimer;
    FMTask *fmTask;

    QJsonObject backupReqObj;
protected:
    BOOL Transfer(LPSTR data, LPSTR &rsp, UINT &rsp_len);

signals:
    void doTask();
    void startSocketTimer();
    void stopSocketTimer();

public slots:
    void onDoTask();
    void onQuit();
    void onSetting();
    void onAbout();

    void onCheckSocket();
    void onDisconnected();

    void onConfirmRechageTimeOut();
};

#endif // FMVIPDISPATCHER_H
