﻿#include "fmnetwork.h"
#include "global.h"
#include "fmsetting.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QEventLoop>
#include <QTimer>
#include <QSettings>
#include <QDebug>

FMNetwork::FMNetwork(QObject *parent) :
    QObject(parent),
    _nam(new QNetworkAccessManager),
    _req(new QNetworkRequest)
{

}

FMNetwork::~FMNetwork()
{
    del_p(_nam);
    del_p(_req);
}

QByteArray FMNetwork::send(const QString *url, const QByteArray *data)
{
    qDebug() << "Send Url: " << *url;
    qDebug() << "Send Data: " << (*data).data();

    _req->setUrl(*url);

    // 设置请求头
    _req->setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    _req->setHeader(QNetworkRequest::ContentLengthHeader, data->length());

    auto reply = _nam->post(*_req, *data);

    // 使用定时器处理超时
    QEventLoop loop;
    connect(_nam, SIGNAL(finished(QNetworkReply*)), &loop, SLOT(quit()));
    QTimer timer;
    timer.setSingleShot(true);
    connect(&timer, SIGNAL(timeout()),&loop,SLOT(quit()));
    timer.start(1000 * 30);
    loop.exec();

    QByteArray rspData;
    if(timer.isActive())
    {
        timer.stop();

        if (reply->error() == QNetworkReply::NoError) {
            rspData = reply->readAll();
        } else {
            int err = reply->error();
            setError(FM_API_NETWORERROR, err, netErrInfo(err));
            qDebug() << QString::fromLocal8Bit("Network error: (%1) %2").arg(err).arg(reply->errorString());
            qDebug() << QString::fromLocal8Bit("Network reply: %1.").arg(QString::fromUtf8(reply->readAll()));
        }
    }else{
        setError(FM_API_TIMEOUT);
        qDebug() << QString::fromLocal8Bit("Timeout.");
    }
    return rspData;
}

QString FMNetwork::netErrInfo(int code)
{
    QSettings setting(AppDirPath+"/FMVip.cfg", QSettings::IniFormat);
    setting.setIniCodec("GBK");
    setting.beginGroup("NetworkError");
    QString key = QString::number(code);
    if(!setting.contains(key)) {
        key = "default";
    }
    QString errInfo = setting.value(key).toString();
    setting.endGroup();
    return errInfo;
}
