#ifndef FMAPIRELAY_H
#define FMAPIRELAY_H

#include "fmapidef.h"
#include "fmapicfg.h"

#include <Windows.h>
#include <tchar.h>


//////////////////////////////////////////////////////////////////////////
//
//! Class FMApiRelay
//
//////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif

class FMVIP_DECL FMApiRelay
{
public:
    explicit FMApiRelay();
    ~FMApiRelay();
    const char *        Request() { return _request; }
    const char *        Response() { return _response; }
    virtual BOOL        Transfer(LPSTR data, LPSTR &rsp, UINT &rsp_len);
    void                SetSocketDescriptor(const SOCKET s);
    SOCKET              GetSocketDescriptor() const;
protected:
    virtual INT         _ParseRequest(LPSTR data);
    virtual BOOL        _GetResponse(LPSTR &rsp, UINT &len);
    virtual BOOL        _SimpleResponse(int code, LPSTR &rsp, UINT &len);

protected:
    char               *_response;
    char               *_request;
    FMApiCfg            _cfg;
    SOCKET              _socket;
};

#ifdef __cplusplus
}
#endif


#endif // FMAPIRELAY_H
