﻿#include "fmsetting.h"
#include <QSettings>
#include <QApplication>

FMSetting::FMSetting()
{
    _sets = new QSettings(qApp->applicationName()+".ini", QSettings::IniFormat);
    _sets->setIniCodec("UTF-8");
}

FMSetting *FMSetting::Instance()
{
    static FMSetting instance;
    return &instance;
}

QVariant FMSetting::getValue(const QString &k, QVariant default_val)
{
    return _sets->value(k, default_val);
}

bool FMSetting::setValue(const QString &k, QVariant v)
{
    _sets->setValue(k, v);
    return (_sets->value(k) == v);
}

QVariant FMSetting::GetValue(const QString &k, QVariant default_val)
{
    return FMSetting::Instance()->getValue(k, default_val);
}

bool FMSetting::SetValue(const QString &k, QVariant v)
{
    return FMSetting::Instance()->setValue(k, v);
}
