﻿#include "fmnetwork.h"
#include "fmlogger.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QEventLoop>
#include <QTimer>

FMNetwork::FMNetwork(QObject *parent) :
    QObject(parent),
    _nam(new QNetworkAccessManager),
    _req(new QNetworkRequest)
{

}

FMNetwork::~FMNetwork()
{
    delete _nam;
    delete _req;
}

bool FMNetwork::send(const QString &url, const QByteArray &reqData, QByteArray &rspData, QString &error)
{
    bool isOk = false;
    FM_INFO() << "Send Url: " << url;
    FM_INFO() << "Send Data: " << reqData;

    _req->setUrl(url);

    // 设置请求头
    _req->setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    _req->setHeader(QNetworkRequest::ContentLengthHeader, reqData.length());

    auto reply = _nam->post(*_req, reqData);

    // 使用定时器处理超时
    QEventLoop loop;
    connect(_nam, SIGNAL(finished(QNetworkReply*)), &loop, SLOT(quit()));
    QTimer timer;
    timer.setSingleShot(true);
    connect(&timer, SIGNAL(timeout()),&loop,SLOT(quit()));
    timer.start(1000 * 30);
    loop.exec();

    if(timer.isActive())
    {
        timer.stop();
        if (reply->error() == QNetworkReply::NoError) {
            isOk = true;
            rspData = reply->readAll();
        } else {
            error = reply->errorString();
        }
    }else{
        error = "请求超时";
    }
    return isOk;
}
