﻿#include "fmmsgwnd.h"
#include "ui_fmmsgwnd.h"

FMMsgWnd::FMMsgWnd(FMVipWnd *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMMsgWnd)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
}

FMMsgWnd::~FMMsgWnd()
{
    delete ui;
}

void FMMsgWnd::show(InfoType type, const QString &info)
{
    QString iconUrl;
    switch (type) {
    case InfoType::T_Normal:
        iconUrl = "";
        break;
    case InfoType::T_Success:
        iconUrl = ":/img/tip_ok.png";
        break;
    case InfoType::T_Failure:
        iconUrl = ":/img/tip_error.png";
        break;
    case InfoType::T_Warning:
        iconUrl = ":/img/tip_warning.png";
        break;
    default:
        iconUrl = "";
        break;
    }

    if(iconUrl != ""){
        QPixmap icon(iconUrl);
        ui->alertIconLab->setPixmap(icon);
    }

    ui->alertLabMsg->setText(info);
    QDialog::exec();
}

void FMMsgWnd::FailureWnd(const QString &info)
{
    FMMsgWnd window;
    window.show(FMMsgWnd::T_Failure, info);
}
void FMMsgWnd::WarningWnd(const QString &info)
{
    FMMsgWnd window;
    window.show(FMMsgWnd::T_Warning, info);
}
void FMMsgWnd::SuccessWnd(const QString &info)
{
    FMMsgWnd window;
    window.show(FMMsgWnd::T_Success, info);
}

void FMMsgWnd::on_alertBtnOk_clicked()
{
    this->close();
}
