﻿#ifndef FMBACKUP_H
#define FMBACKUP_H
#include <QSqlDatabase>
#include <QSqlRecord>

class FMBackup
{
public:
    static FMBackup* instance();
    QSqlDatabase database() { return _db;}
    bool insert(QString card_no, QString inner_no, double recharge_amount, double after_amount, QString fm_id, QString date, QString time);
    QSqlQuery cardQuery(QString date);
    bool reset();

    QString lastError() const;
private:
    FMBackup();
    QSqlDatabase _db;
    QString _error;

    bool connect();
    bool createTable(const QString &dbname);

    void setError(const QString &error);
};

#endif // FMBACKUP_H
