﻿#include "refuseForm.h"
#include "ui_refuseForm.h"
#include <QDebug>
#include "QsLog.h"

RefuseForm::RefuseForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RefuseForm),
    m_orderObject(NULL)
{
    ui->setupUi(this);
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    this->setModal(true);
    ui->refuseBtnOk->setEnabled(false);
    m_refDishesForm = new refDishesForm(this);
}

RefuseForm::~RefuseForm()
{ 
    QLOG_INFO() << QString("[<<<<---RefuseForm::~RefuseForm: begin--->>>>]");
    delete ui;
    // m_refDishesForm->deleteLater();  // New 时指定了父类对象指针;
    QLOG_INFO() << QString("[<<<<---RefuseForm::~RefuseForm: end--->>>>]");
}

void RefuseForm::SetOrderInfo(OrderObject *obj)
{
    _Init();
    m_orderObject = obj;
}


void RefuseForm::on_refuseBtnCancle_clicked()
{
    this->reject();
}

void RefuseForm::on_refuseBtnOk_clicked()
{
    this->accept();
}

void RefuseForm::on_reason1_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("门店已打烊");
        m_reasonCode=1;
    }
}

void RefuseForm::on_reason2_toggled(bool checked)
{
    //TODO
    QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: check:%1--->>>>]")<<checked;
    if(m_orderObject!=NULL&&checked)
    {
        m_refDishesForm->InitData(m_orderObject);
        if(QDialog::Accepted == m_refDishesForm->exec())
        {
            ui->refuseBtnOk->setEnabled(true);
            m_reasonStr=QString::fromLocal8Bit("产品已售完");
            m_reasonCode=2;

            QMap<QString,int>::iterator it; //遍历map
            for(it = m_refDishesForm->m_dishesMap.begin(); it != m_refDishesForm->m_dishesMap.end(); ++it) {
                m_refundDishesList.append(it.key());
            }
            m_refundDishesListString = m_refundDishesList.join(";");
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: m_refDishesForm->m_dishesMap:%1--->>>>]")<<m_refDishesForm->m_dishesMap;
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled: m_refundDishesList:%1--->>>>]")<<m_refundDishesList;
            on_refuseBtnOk_clicked();
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_refuseBtnOk_clicked--->>>>]");
        } else {
            QLOG_INFO() << QString("[<<<<---RefuseForm::on_reason2_toggled:  QDialog::Accepted != m_refDishesForm->exec()--->>>>]");
            _Init();
        }
    }
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("产品已售完");
        m_reasonCode=2;
    }
}

void RefuseForm::on_reason3_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("门店太忙");
        m_reasonCode=3;
    }
}

void RefuseForm::on_reason4_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("联系不上客户");
        m_reasonCode=4;
    }
}

void RefuseForm::on_reason5_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("无人配送");
        m_reasonCode=5;
    }
}

void RefuseForm::on_reason6_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("留言无法打印");
        m_reasonCode=17;
    }
}

void RefuseForm::on_reason7_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonStr=QString::fromLocal8Bit("生活馆到店退单");
        m_reasonCode=20;
    }
}

void RefuseForm::_Init()
{
    qDebug() << __FUNCTION__;
    clearAllRadioBtnCheck();
    m_refundDishesList.clear();
    m_refundDishesListString.clear();
    ui->refuseBtnOk->setEnabled(false);
}


void  RefuseForm::clearAllRadioBtnCheck(){
    QLOG_INFO() << QString("[<<<<---RefuseForm::clearAllRadioBtnCheck  Clear All Check --->>>>]");
    ui->reason1->setAutoExclusive(false);
    ui->reason1->setChecked(false);
    ui->reason1->setAutoExclusive(true);

    ui->reason2->setAutoExclusive(false);
    ui->reason2->setChecked(false);
    ui->reason2->setAutoExclusive(true);

    ui->reason3->setAutoExclusive(false);
    ui->reason3->setChecked(false);
    ui->reason3->setAutoExclusive(true);

    ui->reason4->setAutoExclusive(false);
    ui->reason4->setChecked(false);
    ui->reason4->setAutoExclusive(true);

    ui->reason5->setAutoExclusive(false);
    ui->reason5->setChecked(false);
    ui->reason5->setAutoExclusive(true);

    ui->reason6->setAutoExclusive(false);
    ui->reason6->setChecked(false);
    ui->reason6->setAutoExclusive(true);

    ui->reason7->setAutoExclusive(false);
    ui->reason7->setChecked(false);
    ui->reason7->setAutoExclusive(true);

}

void  RefuseForm::hideSelectProductFrom(){
    if ( m_refDishesForm && m_refDishesForm->isVisible() ) {
        QLOG_INFO() << QString("[<<<<---RefuseForm::hideSelectProductFrom   Before m_refDishesForm->reject(); --->>>>]");
        m_refDishesForm->reject();
        /*
        if ( m_refDishesForm ) {
            m_refDishesForm->deleteLater();
            QLOG_INFO() << QString("[<<<<---RefuseForm::hideSelectProductFrom   m_refDishesForm->deleteLater(); --->>>>]");
        }
        */
        QLOG_INFO() << QString("[<<<<---RefuseForm::hideSelectProductFrom   After  m_refDishesForm->reject(); --->>>>]");
    } else {
        QLOG_INFO() << QString("[<<<<---RefuseForm::hideSelectProductFrom  Finished --->>>>]");
    }

}
