﻿#include "padForm.h"
#include "ui_padForm.h"

PadForm::PadForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PadForm)
{
    ui->setupUi(this);

    this->setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
}

PadForm::~PadForm()
{
    delete ui;
}

void PadForm::onNumClicked()
{
    QPushButton *btn = (QPushButton*)sender();
    emit numClicked(btn->property("num").toString());
}

void PadForm::on_padBtnDel_clicked()
{
    emit numDelete();
}

void PadForm::on_padBtnClose_clicked()
{
    emit numClear();
    hide();
}


void PadForm::on_padBtnEcMop_clicked()
{
    hide();
    emit getEcMopOrder();
}
