﻿#ifndef FLOATFORM_H
#define FLOATFORM_H

#include <QDialog>
#include <QMouseEvent>
#include <QTimer>
#include <QSize>
#include <QPropertyAnimation>
#include <QSound>

namespace Ui {
class FloatForm;
}

class FloatForm : public QDialog
{
    Q_OBJECT

public:
    explicit FloatForm(QWidget *parent = 0);
    ~FloatForm();

protected:
    void mouseMoveEvent(QMouseEvent * event);
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent * event);

private:
    Ui::FloatForm *ui;
    // 记录左键按下去后是否移动过
    bool m_bMouseMove;
    // 记录左键是否按下去
    bool m_bMousePress;
    // 拖动前鼠标坐标
    QPoint m_lastMousePos;
    // 此次拖动一共移动的距离
    QPoint m_absMove;

    // 记录门店营业状态
    bool m_bStoreStatus;

    // 记录提示状态图片的大小
    QSize m_imgRemindSize;
    // 三个渠道的门店营业状态;
    QSize m_imgStoreBusiStatSize;
    // 记录是否正在提示
    bool m_bReminding;
    // 闪烁动画
    QPropertyAnimation m_animation;
    // 记录音频文件
    QString m_remindWav;
    // 声音的间隔
    int m_wavPlayInterval;
    // 置顶定时器
    QTimer m_raiseTimer;
    //QTimer m_remindTimer;  //取消此定时器使用

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();

private slots:
    /* 功能:闪烁
     * 参数:NULL
     * 返回:NULL
     * */
    void _Blink();
    /* 功能:声音
     * 参数:NULL
     * 返回:NULL
     * */
    void _PlayWav();

signals:
    /* 功能:通知主窗口显示
     * 参数:NULL
     * 返回:NULL
     * */
    void showMainForm();

public slots:
    /* 功能:开启提示
     * 参数:[1]提示类型 0新订单1申请退款
     * 返回:NULL
     * */
    void onStartRemind(int type);
    /* 功能:关闭提示
     * 参数:NULL
     * 返回:NULL
     * */
    void onStopRemind();
    /* 功能:显示窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onShow();

    /* 功能:显示窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onHide();

    /* 功能:锁住窗口:enable(false);
     * 参数:NULL
     * 返回:NULL
     * */
    void onLockFloatForm();

    /* 功能:解锁窗口:enable(true);
     * 参数:NULL
     * 返回:NULL
     * */
    void onUnLockFloatForm();

    /* 功能:变更门店营业状态;
     * 参数:1 [ele开关店状态] 2[MOD开关店状态] 3[MOP开关店状态]
     * 返回:NULL
     * */
    void onUpdateStoreStatus(int eleStoreStatus, int modStoreStatus,int mopStoreStatus);

    /* 功能:更新多渠道门店营业状态显示;
     * 参数:1 [ele开关店状态] 2[MOD开关店状态] 3[MOP开关店状态]
     * 返回:NULL
     * */
    void RefreshStoreStatus(int eleStoreStatus=0, int modStoreStatus=0,int mopStoreStatus=0);

    /* 功能:新订单到POS更新悬浮框显示;
     * 参数:1 [是否存在新订单]
     * 返回:NULL
     * */
    void RefreshOrderManagerStatus(int existNewOrder=0);

};

#endif // FLOATFORM_H
