﻿#include "dishesItem.h"
#include "ui_dishesItem.h"
#include <QDebug>
#include "Control/flowControl.h"

dishesItem::dishesItem(QString channelCode, QString sku, int status, QString name, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dishesItem)
{
    ui->setupUi(this);

    Init(sku, status, name);
    m_channelCode = channelCode;

    setAttribute(Qt::WA_TranslucentBackground);

    connect(this, &dishesItem::doUpdDishes, &FlowControl::GetInstance(), &FlowControl::onUpdDishes);
    connect(&FlowControl::GetInstance(), &FlowControl::processDishiesSuccssful, this, &dishesItem::onUpdDishesFinsh);
}

dishesItem::~dishesItem()
{
    delete ui;
}

void dishesItem::Init(QString sku, int status, QString name)
{
    m_sku = sku;
    m_status = status;
    m_name = name;

    ui->disItemLabSku->setText(sku);
    ui->disItemLabName->setText(name);

    if(status == 0)
    {
        ui->disItemLabStatus->setText("<font color='#ff0000'>停售</font>");
        ui->disItemBtn->setText("上架");
    }else
    {
        ui->disItemLabStatus->setText("<font color='#55aa00'>在售</font>");
        ui->disItemBtn->setText("下架");
    }
}

void dishesItem::on_disItemBtn_clicked()
{
    QMap<QString, int> map;
    map.insert(m_sku, m_status==0?1:0);

    emit doUpdDishes(m_channelCode, map);
}

void dishesItem::onUpdDishesFinsh(QString channelCode, QMap<QString, int> dishes)
{
    if(!channelCode.compare(m_channelCode))
    {
        if(dishes.contains(m_sku))
        {
            m_status = dishes.value(m_sku);
            if(m_status == 0)
            {
                ui->disItemLabStatus->setText("<font color='#ff0000'>停售</font>");
                ui->disItemBtn->setText("上架");
            }else
            {
                ui->disItemLabStatus->setText("<font color='#55aa00'>在售</font>");
                ui->disItemBtn->setText("下架");
            }
        }
    }
}
