﻿#include "alertForm.h"
#include "ui_alertForm.h"

AlertForm::AlertForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AlertForm)
{
    ui->setupUi(this);
    m_timer =new QTimer(this);
    m_timer->setSingleShot(true);
    connect(m_timer,&QTimer::timeout,this,&AlertForm::hideForm);
    _Init();
}

AlertForm::~AlertForm()
{
    delete ui;
}

void AlertForm::SetContent(AlertForm::Type type, const QString &msg)
{
    switch(type)
    {
    case SUCCESS:
        ui->alertBtnOk->show();
        ui->alertLabOk->show();
        ui->alertLabIng->hide();
        ui->alertLabWarn->hide();
        ui->alertLabError->hide();
        break;
    case MSGERROR:
        ui->alertBtnOk->show();
        ui->alertLabOk->hide();
        ui->alertLabIng->hide();
        ui->alertLabWarn->hide();
        ui->alertLabError->show();
        break;
    case LOADING:
        ui->alertBtnOk->hide();
        ui->alertLabOk->hide();
        ui->alertLabIng->show();
        ui->alertLabWarn->hide();
        ui->alertLabError->hide();
        break;
    case BRIEF_TIPS:
        ui->alertBtnOk->hide();
        ui->alertLabOk->hide();
        ui->alertLabIng->show();
        ui->alertLabWarn->hide();
        ui->alertLabError->hide();
        break;
    case SYNCDATA:
        ui->alertBtnOk->hide();
        ui->alertLabOk->hide();
        ui->alertLabIng->show();
        ui->alertLabWarn->hide();
        ui->alertLabError->hide();
        m_timer->stop();
        m_timer->start(20000);
        break;
    case WARNNING:
        ui->alertBtnOk->show();
        ui->alertLabOk->hide();
        ui->alertLabIng->hide();
        ui->alertLabWarn->show();
        ui->alertLabError->hide();
        break;
    }

    if ( type == WARNNING ) {        
        ui->alertLabMsg->hide();

        QStringList mopExceptInfoList = msg.split(';');
        if ( mopExceptInfoList.size() >4 ) {
            ui->alertLabWarn1->setText( mopExceptInfoList[0] );
            ui->alertLabWarn1->setAlignment(Qt::AlignCenter);
            QFont    font1 ( "Microsoft YaHei",  14,   QFont::Bold);
            ui->alertLabWarn1->setFont(font1);
            ui->alertLabWarn1->show();

            ui->alertLabWarn_space->show();

            ui->alertLabWarn2->setText( mopExceptInfoList[1] );
            ui->alertLabWarn2->setAlignment(Qt::AlignLeft);
            QPalette palette2;
            palette2.setColor(QPalette::WindowText,Qt::red);
            ui->alertLabWarn2->setPalette(palette2);
            ui->alertLabWarn2->show();

            ui->alertLabWarn3->setText( mopExceptInfoList[2] );
            ui->alertLabWarn3->setAlignment(Qt::AlignLeft);
            QPalette palette3;
            palette3.setColor(QPalette::WindowText,Qt::black);
            ui->alertLabWarn3->setPalette(palette3);
            ui->alertLabWarn3->show();

            ui->alertLabWarn4->setText( mopExceptInfoList[3] );
            ui->alertLabWarn4->setAlignment(Qt::AlignLeft);
            ui->alertLabWarn4->setPalette(palette2);
            ui->alertLabWarn4->show();

            ui->alertLabWarn5->setText( mopExceptInfoList[4] );
            ui->alertLabWarn5->setAlignment(Qt::AlignLeft);
            ui->alertLabWarn5->setPalette(palette3);
            ui->alertLabWarn5->show();

        } else {
            ui->alertLabMsg->setText(msg);
        }

    } else {
       ui->alertLabWarn_space->hide();
       ui->alertLabWarn1->hide();
       ui->alertLabWarn2->hide();
       ui->alertLabWarn3->hide();
       ui->alertLabWarn4->hide();
       ui->alertLabWarn5->hide();
       ui->alertLabMsg->setText(msg);
    }

    if ( type == WARNNING ) {
            m_timer->stop();
    } else if ( type == BRIEF_TIPS ) {
        if(!m_timer->isActive() )
            m_timer->start(3000);
    } else {
        if(!m_timer->isActive() )
            m_timer->start(20000);
    }

    return;
}

void AlertForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

    // 初始化Gif动画
    m_movie = new QMovie(this);
    m_movie->setFileName(":loading.gif");
    ui->alertLabIng->setMovie(m_movie);
    ui->alertLabIng->setScaledContents(true);
    m_movie->start();

    ui->alertLabOk->hide();
    ui->alertLabIng->hide();
    ui->alertLabError->hide();
}

void AlertForm::hideForm()
{
    this->hide();
}

void AlertForm::on_alertBtnOk_clicked()
{
    this->hide();
    return;
}
