﻿#ifndef BILLSOCKET_H
#define BILLSOCKET_H

#include <QJsonObject>
#include <QJsonDocument>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QUrl>

/* 类名：BillSocket [账单socket];
 * 功能：Socket通用型的http通信请求;
 * */
class BillSocket : public QObject
{
    Q_OBJECT
public:
    explicit BillSocket(QObject *parent=0);
    ~BillSocket();

    /* 功能:带json参数的Http请求 [POST请求]:
     * 参数:1、json数据入参；2、接受返回json数据的Buff；3、error字符串；
     * 返回:TRUE[请求成功] / FALSE[请求失败]；
     * */
    bool PostRequest(const QJsonObject& requestJson, QJsonObject& recvJson, QString& error);

    /* 功能:不带参数的Http请求 [GET请求]:
     * 参数:1、接受返回json数据的Buff；3、error字符串；
     * 返回:TRUE[请求成功] / FALSE[请求失败]；
     * */
    bool GetRequest(QJsonObject& recvJson, QString& error);

    /* 功能:设置Http请求的 URL地址:
     * 参数:1、URL地址；
     * 返回:void；
     * */
    void SetUrl(QUrl& url);

    /* 功能:获取Http请求的 URL地址:
     * 返回:URL地址；
     * */
    QUrl GetUrl() const;

    /* 功能:设置Http请求的 ssl配置:
     * 参数:void；
     * 返回:void；
     * */
    void SetSslConfig();

private:
    /*
    * http请求管理成员变量：用户维护Http请求队列；
    */
    QNetworkAccessManager m_networkManger;
    /*
    * http请求成员变量：用于绑定请求的相关数据；
    */
    QNetworkRequest m_networkRequest;
};

#endif // BILLSOCKET_H
