﻿#include "billSocket.h"

#include <QtNetwork/QNetworkReply>
#include "preDefine.h"
#include <QEventLoop>
#include <QTimer>
#include <QFile>
#include <QSslConfiguration>
#include "QsLog.h"

BillSocket::BillSocket(QObject *parent)
    : QObject(parent)
{
    //设置Http请求的 请求头；
    m_networkRequest.setRawHeader("Content-Type","application/json");
}

BillSocket::~BillSocket()
{

}

bool BillSocket::PostRequest(const QJsonObject &requestJson, QJsonObject &recvJson, QString &error)
{
    //设置Http请求管理的网络访问权限设置；
    //QLOG_INFO()<<QString("[<<<PostRequest: request: >>>>]")<< requestJson;
    if(QNetworkAccessManager::Accessible != m_networkManger.networkAccessible()) {
        m_networkManger.setNetworkAccessible(QNetworkAccessManager::Accessible);
    }
    //设置Http请求的请求参数：requestJson；
    QByteArray sendArray = QJsonDocument(requestJson).toJson(QJsonDocument::Compact);
    QEventLoop eventLoop;
    //QLOG_INFO()<<QString("[<<<PostRequest: sendArray: >>>>]")<< sendArray;
    QNetworkReply *reply = m_networkManger.post(m_networkRequest , sendArray);
    //QLOG_INFO()<<QString("[<<<PostRequest: reply : >>>>]")<< reply;
    connect(&m_networkManger, SIGNAL(networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(finished()), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)), &eventLoop, SLOT(quit()));
    // 加用定时器防止网络出现异常长时间不返回导致的阻塞
    QTimer::singleShot(VALUE_NETTIMEOUT, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();
    //QLOG_INFO()<<QString("[<<<PostRequest: jiexi ding dan shuju: >>>>]")<< reply;

    //获取Http请求的返回json数据；
   if(reply->error() != QNetworkReply::NoError) {
       QLOG_INFO()<<QString("[<<<PostRequest: reply->error(): >>>>]")<< reply->error();
       error = reply->errorString();
       return false;
   }
   QByteArray recvArray = reply->readAll();
   //QLOG_INFO()<<QString("[<<<PostRequest: reply->readAll(): >>>>]")<< recvArray;
   if(recvArray.size() == 0) {
       error = "nothing recved";
       return false;
   }
   recvJson = QJsonDocument::fromJson(recvArray).object();
   //QLOG_INFO()<<QString("[<<<PostRequest: recvJson: >>>>]")<< recvJson;
   reply->deleteLater();
   return true;
}

bool BillSocket::GetRequest( QJsonObject &recvJson, QString &error)
{
    if(QNetworkAccessManager::Accessible != m_networkManger.networkAccessible()) {
        m_networkManger.setNetworkAccessible(QNetworkAccessManager::Accessible);
    }
    QEventLoop eventLoop;
    QNetworkReply *reply = m_networkManger.get(m_networkRequest);
    connect(&m_networkManger, SIGNAL(networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(finished()), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)), &eventLoop, SLOT(quit()));
    // 加用定时器防止网络出现异常长时间不返回导致的阻塞
    QTimer::singleShot(VALUE_NETTIMEOUT, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();
   if(reply->error() != QNetworkReply::NoError) {
       error = reply->errorString();
       return false;
   }
   QByteArray recvArray = reply->readAll();
   if(recvArray.size() == 0) {
       error = "nothing recved";
       return false;
   }
   recvJson = QJsonDocument::fromJson(recvArray).object();
   reply->deleteLater();
   return true;
}

void BillSocket::SetUrl(QUrl &url)
{
    m_networkRequest.setUrl(url);
}

QUrl BillSocket::GetUrl() const{
    return m_networkRequest.url();
}

void BillSocket::SetSslConfig()
{
    QSslConfiguration m_sslConfig = QSslConfiguration::defaultConfiguration();
    //QSslConfiguration m_sslConfig = m_networkRequest.setSslConfiguration();
    m_sslConfig.setPeerVerifyMode(QSslSocket::VerifyNone);
    m_sslConfig.setProtocol(QSsl::AnyProtocol);
    m_networkRequest.setSslConfiguration(m_sslConfig);
    /*
    QSslConfiguration m_sslConfig = QSslConfiguration::defaultConfiguration();
    QString keyDir = QGuiApplication::applicationDirPath() + "/key/";
    // 创建客户端证书
    QFile fileCrt(keyDir+"客户端证书.pem");
    if (!fileCrt.open(QIODevice::ReadOnly))
         qDebug() << "!fileCrt.open==" ;
    const QSslCertificate certificate(&fileCrt, QSsl::Pem);
    fileCrt.close();

    // 创建客户端私钥
    QFile fileKey(keyDir+"key.pem");
    fileKey.open(QIODevice::ReadOnly);
    const QSslKey prvateKey(&fileKey, QSsl::Rsa);
    fileKey.close();

    m_sslConfig.setPeerVerifyMode(QSslSocket::VerifyNone);
    m_sslConfig.setProtocol(QSsl::TlsV1_0);
    m_sslConfig.setPrivateKey(prvateKey);
    m_sslConfig.setLocalCertificate(certificate);
    //加入ssl配置信息
    m_networkRequest.setSslConfiguration(m_sslConfig);
    m_networkR
    */

}
