#ifndef THREADSOCKET_H
#define THREADSOCKET_H

#include <QObject>
#include <QEventLoop>
#include <QJsonObject>
#include <QTimer>

#define EVENTWAIT(timer) do{                                \
        QEventLoop loop;                                    \
        QTimer::singleShot(timer, &loop, SLOT(quit()));     \
        loop.exec();                                        \
    } while(0)


class ThreadSocket : public QObject
{
    Q_OBJECT
public:
    explicit ThreadSocket(QObject *parent = 0);

    ~ThreadSocket();
    /* 功能:重载移动到线程的方法
     * 参数:[1]线程编号[2]是否在退出时触发线程退出
     * 返回:void
     * */
    void moveToThread(QThread *thread, bool with_thread_start);

    bool S_PostRequest(const QJsonObject &requestJson, QJsonObject &recvJson, QString url, QString &error, QByteArray contentype = QByteArray("application/json"));

    bool S_GetRequest(const QString& url, QByteArray& out,QString& error);
signals:
    /* 功能:触发QThread退出的信号
     * 参数:NULL
     * 返回:void
     * */
    void threadClose();

    void quit();

public slots:
    virtual void threadStart();

protected:
    bool _stopFlag;
    bool _stoped;
    QThread * _thread;
};

#endif // THREADSOCKET_H
