﻿#include "singleProductObject.h"

SingleProductObject::SingleProductObject(const SingleProductObject &singleProduct, QObject *parent):QObject(parent)
{
    const QMetaObject *m = singleProduct.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = singleProduct.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

SingleProductObject& SingleProductObject::operator =(const SingleProductObject& singleProduct)
{
    const QMetaObject *m = singleProduct.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = singleProduct.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void SingleProductObject::FetchDataFromJson(const QJsonObject &json)
{
    foreach(QString key,  json.keys())
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }
    return;
}
