#ifndef PAYMENTOBJECT_H
#define PAYMENTOBJECT_H

#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>

class PaymentObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString paymentFmId READ getPaymentFmId WRITE setPaymentFmId)
    Q_PROPERTY (QString payMethodId READ getPayMethodId WRITE setPayMethodId)
    Q_PROPERTY (int paymentMoney READ getPaymentMoney WRITE setPaymentMoney)

public:
    explicit PaymentObject(QObject *parent = 0):QObject(parent){}
    PaymentObject(const PaymentObject& payments,QObject* parent=0);
    PaymentObject& operator =(const PaymentObject& payments);
    void FetchDataFromJson(const QJsonObject &json);
    QString paymentFmId; //支付方式对应的Upp FmId;
    QString payMethodId;
    int paymentMoney;

protected:
    inline QString getPaymentFmId(){ return paymentFmId; }
    inline void setPaymentFmId(const QString& v){ paymentFmId = v; }

    inline QString getPayMethodId(){ return payMethodId; }
    inline void setPayMethodId(const QString& v){ payMethodId = v; }

    inline int getPaymentMoney(){ return paymentMoney; }
    inline void setPaymentMoney(const int& v){ paymentMoney = v; }

};

#endif // PAYMENTOBJECT_H
