﻿#ifndef COUPONSOBJECT_H
#define COUPONSOBJECT_H

#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>
#include <Model/singleProductObject.h>
#include <Model/PromotionItemObject.h>

class CouponsObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString couponSeq READ getCouponSeq WRITE setCouponSeq)
    Q_PROPERTY (QString code READ getCode WRITE setCode)
    Q_PROPERTY (QString couponName READ getCouponName WRITE setCouponName)
    Q_PROPERTY (QString menuItem READ getMenuItem WRITE setMenuItem)
    Q_PROPERTY (QString couponType READ getCouponType WRITE setCouponType)
    Q_PROPERTY (bool storeChannel READ getStoreChannel WRITE setStoreChannel)
    Q_PROPERTY (QString payMethodId READ getPayMethodId WRITE setPayMethodId)
    Q_PROPERTY (QString payMethodName READ getPayMethodName WRITE setPayMethodName)
    Q_PROPERTY (int consumeFactAmount READ getConsumeFactAmount WRITE setConsumeFactAmount)
    Q_PROPERTY (int consumeDiscountAmount READ getConsumeDiscountAmount WRITE setConsumeDiscountAmount)
    Q_PROPERTY (QString discount READ getDiscount WRITE setDiscount)
    Q_PROPERTY (QString discountName READ getDiscountName WRITE setDiscountName)

    Q_PROPERTY (int isShowGiver READ getIsShowGiver WRITE setIsShowGiver)
    Q_PROPERTY (QString giverName READ getGiverName WRITE setGiverName)
    Q_PROPERTY (QString blessingWords READ getBlessingWords WRITE setBlessingWords)

public:
    explicit CouponsObject(QObject *parent = 0):QObject(parent){}
    CouponsObject(const CouponsObject& coupons,QObject* parent=0);
    CouponsObject& operator =(const CouponsObject& coupons);
    void FetchDataFromJson(const QJsonObject &json);
    QString couponSeq;  //券序号
    QString code;            //券ID号
    QString couponName;    //券名
    QString menuItem;         // 菜单分类
    QString couponType;     //券类型
    bool  storeChannel;        //是否门店券;
    QString payMethodId;    //券支付方式ID
    QString payMethodName;    //券支付方式名
    int consumeFactAmount;    //券实际售卖金额
    int consumeDiscountAmount;   //券折扣金额
    QString discount;                     //券折扣码
    QString discountName;             //券折扣名

    int isShowGiver;               //是否显示 券赠送者
    QString giverName ;                //券赠送者
    QString blessingWords ;          //券赠送祝福

    QList<SingleProductObject*> skus;
    QList<PromotionItemObject*> itemsDiscount;

protected:
    inline QString getCouponSeq(){ return couponSeq; }
    inline void setCouponSeq(const QString& v){ couponSeq = v; }

    inline QString getCode(){ return code; }
    inline void setCode(const QString& v){ code = v; }

    inline QString getCouponName(){ return couponName; }
    inline void setCouponName(const QString& v){ couponName = v; }

    inline QString getMenuItem(){ return menuItem; }
    inline void setMenuItem(const QString& v){ menuItem = v; }

    inline QString getCouponType(){ return couponType; }
    inline void setCouponType(const QString& v){ couponType = v; }

    inline bool getStoreChannel(){ return storeChannel; }
    inline void setStoreChannel(const bool& v){ storeChannel = v; }

    inline QString getPayMethodId(){ return payMethodId; }
    inline void setPayMethodId(const QString& v){ payMethodId = v; }

    inline QString getPayMethodName(){ return payMethodName; }
    inline void setPayMethodName(const QString& v){ payMethodName = v; }

    inline int getConsumeFactAmount(){ return consumeFactAmount; }
    inline void setConsumeFactAmount(const int& v){ consumeFactAmount = v; }

    inline int getConsumeDiscountAmount(){ return consumeDiscountAmount; }
    inline void setConsumeDiscountAmount(const int& v){ consumeDiscountAmount = v; }

    inline QString getDiscount(){ return discount; }
    inline void setDiscount(const QString& v){ discount = v; }

    inline QString getDiscountName(){ return discountName; }
    inline void setDiscountName(const QString& v){ discountName = v; }

    inline int getIsShowGiver(){ return isShowGiver; }
    inline void setIsShowGiver(const int& v){ isShowGiver = v; }

    inline QString getGiverName(){ return giverName; }
    inline void setGiverName(const QString& v){ giverName = v; }

    inline QString getBlessingWords(){ return blessingWords; }
    inline void setBlessingWords(const QString& v){ blessingWords = v; }

};

#endif // COUPONSOBJECT_H
