#include "couponsObject.h"

#include "preDefine.h"
#include <QJsonArray>

CouponsObject::CouponsObject(const CouponsObject &coupons, QObject *parent):QObject(parent)
{
    qDeleteAll(skus);
    skus.clear();

    qDeleteAll(itemsDiscount);
    itemsDiscount.clear();

    const QMetaObject *m = coupons.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = coupons.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }

    foreach (auto ptr, coupons.skus) {
        SingleProductObject *singleProduct=new SingleProductObject(*ptr,this);
        this->skus.append(singleProduct);
    }

    foreach (auto ptr, coupons.itemsDiscount) {
        PromotionItemObject *promotionItem=new PromotionItemObject(*ptr,this);
        this->itemsDiscount.append(promotionItem);
    }

}

CouponsObject& CouponsObject::operator =(const CouponsObject& coupons)
{
    qDeleteAll(skus);
    skus.clear();

    qDeleteAll(itemsDiscount);
    itemsDiscount.clear();

    const QMetaObject *m = coupons.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = coupons.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }

    foreach (auto ptr, coupons.skus) {
        SingleProductObject *singleProduct=new SingleProductObject(*ptr,this);
        this->skus.append(singleProduct);
    }

    foreach (auto ptr, coupons.itemsDiscount) {
        PromotionItemObject *promotionItem=new PromotionItemObject(*ptr,this);
        this->itemsDiscount.append(promotionItem);
    }

    return *this;
}

void CouponsObject::FetchDataFromJson(const QJsonObject &json)
{
    foreach(QString key,  json.keys())
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }

    qDeleteAll(skus);
    skus.clear();

    qDeleteAll(itemsDiscount);
    itemsDiscount.clear();

    QJsonArray singleProductsArray = json[JSON_COUPONPRODUCTS].toArray();
    foreach(QJsonValue singleProduct, singleProductsArray)
    {
        SingleProductObject *item = new SingleProductObject(this);
        //初始商品配料数据信息;
        item->isCoupon=false;
        item->code="";
        item->qty=0;
        item->price=0;
        item->FetchDataFromJson(singleProduct.toObject());
        this->skus.append(item);
    }

    QJsonArray itemsDiscountArray = json[JSON_ITEMSDISCOUNT].toArray();
    foreach(QJsonValue itemDiscount, itemsDiscountArray)
    {
        PromotionItemObject *item = new PromotionItemObject(this);
        //初始商品配料数据信息;
        item->promotionSku="";
        item->promotionName="";
        item->promotionQty=0;
        item->discountFee=0;
        item->type=0;
        item->FetchDataFromJson(itemDiscount.toObject());
        itemsDiscount.append(item);
    }

    return;
}
