#ifndef PROMOTIONITEMOBJECT_H
#define PROMOTIONITEMOBJECT_H

#include <QObject>
#include <QJsonObject>
#include <QVariant>
#include <QMetaProperty>

class PromotionItemObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString promotionSku READ getPromotionSku WRITE setPromotionSku)
    Q_PROPERTY (QString promotionName READ getPromotionName WRITE setPromotionName)
    Q_PROPERTY (int promotionQty READ getPromotionQty WRITE setPromotionQty)
    Q_PROPERTY (int discountFee READ getDiscountFee WRITE setDiscountFee)
    Q_PROPERTY (int type READ getType WRITE setType)

public:
    explicit PromotionItemObject(QObject *parent = 0):QObject(parent){}
    PromotionItemObject(const PromotionItemObject& promotionItem,QObject* parent=0);
    PromotionItemObject& operator =(const PromotionItemObject& promotionItem);
    void FetchDataFromJson(const QJsonObject &json);

    QString promotionSku;
    QString promotionName;
    int promotionQty;
    int discountFee;
    int type;    // 1:万能优惠   2:星星优惠   3:B账号优惠;

protected:
    inline QString getPromotionSku(){ return promotionSku; }
    inline void setPromotionSku(const QString& v){ promotionSku = v; }

    inline QString getPromotionName(){ return promotionName; }
    inline void setPromotionName(const QString& v){ promotionName = v; }

    inline int getPromotionQty(){ return promotionQty; }
    inline void setPromotionQty(const int& v){ promotionQty = v; }

    inline int getDiscountFee(){ return discountFee; }
    inline void setDiscountFee(const int& v){ discountFee = v; }

    inline int getType(){ return type; }
    inline void setType(const int& v){ type = v; }
};

#endif // PROMOTIONITEMOBJECT_H
