#include "PromotionItemObject.h"

PromotionItemObject::PromotionItemObject(const PromotionItemObject &promotionItem, QObject *parent):QObject(parent)
{
    const QMetaObject *m = promotionItem.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = promotionItem.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

PromotionItemObject& PromotionItemObject::operator =(const PromotionItemObject& promotionItem)
{
    const QMetaObject *m = promotionItem.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = promotionItem.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void PromotionItemObject::FetchDataFromJson(const QJsonObject &json)
{
    foreach(QString key,  json.keys())
    {
        setProperty(key.toUtf8(), json[key].toVariant());
    }
    return;
}
