﻿#include "util.h"
#include "preDefine.h"

QString Penny2Dollar(int penny)
{
    double dollar = (double)penny/100;
    return QString::number(dollar,'f',2);
}

double Penny2Dollar2Double(int penny)
{
    double dollar = (double)penny/100;
    return QString::number(dollar,'f',2).toDouble();
}

QString GetOperByStatus(int status, bool bRefuse)
{
    switch(status)
    {
    case 1:
        if(bRefuse)
        {
            return OPERATION_REFUSE;
        }
        return OPERATION_GETDELIVERS;
        break;
    case 2:
        if(bRefuse)
        {
            return OPERATION_REFUNDORDER;
        }
        return OPERATION_SENDOUT;
        break;

    case 3:
        if(bRefuse)
        {
            return OPERATION_REFUNDORDER;
        }
        return OPERATION_SENDOUT;
        break;

    case 5:
    case 4:
        if(bRefuse)
        {
            return OPERATION_REFUNDORDER;
        }
        return OPERATION_COMPLETE;
        break;
    case 6:
    case 200:
        return "NULL";
        break;
    case 20:
        if(bRefuse)
        {
            return OPERATION_REFUSEREFUND;
        }
        return OPERATION_REFUNDORDER;
        break;
    default:
        return "NULL";
        break;
    }
}

QString GetOperNameByStatus(int status, bool bRefuse)
{
    switch(status)
    {
    case 1:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUSE);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_GETDELIVERS);
        break;
    case 2:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_SENDOUT);
        break;

    case 3:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_SENDOUT);
        break;
    case 5:
    case 4:
        if(bRefuse)
        {
            return  QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_COMPLETE);
        break;
    case 6:
    case 200:
        return "NULL";
        break;
    case 20:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUSEREFUND);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        break;
    case 50:
        return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        break;
    default:
        return "NULL";
        break;
    }
}
