﻿/******************
*进行sql server操作
******************/
#ifndef PRINTSUMBILLPOSDB_H
#define PRINTSUMBILLPOSDB_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include <Model/orderObject.h>
#include "alertForm.h"
#include "preDefine.h"
#include "windows.h"

class PrintSumBillPosDB : public QObject
{
    Q_OBJECT
public:
    // explicit PrintSumBillPosDB(QObject *parent = 0);

    static PrintSumBillPosDB& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initPrintSumBillPosDB();


    /**
    *功能:新增pos本地数据库打印小票信息表中字段;
    *参数:[无]
    *返回:true:新增成功，false:新增字段失败
    **/
    bool alterTablePrintSumBillPosDB();

    /**
    *功能:检查pos本地数据库打印小票信息表中字段;
    *参数:[无]
    *返回:true:检查字段完整性成功，false:检查字段完整性失败
    **/
    bool alterTablePrintSumBillPosDBAndCheck();

    /**
    *功能:新增pos本地数据库打印小票信息表中字段;
    *参数:[无]
    *返回:true:新增成功，false:新增字段失败
    **/
    bool alterTablePrintSumBillPosDB20();

    /**
    *功能:新增pos本地数据库打印小票信息表中字段;
    *参数:[无]
    *返回:true:新增成功，false:新增字段失败
    **/
    bool alterTablePrintSumBillPosDB21();


    /**
    *功能:变更pos本地数据库打印小票信息表中 store_name store_address 两个字段 长度;
    *参数:[无]
    *返回:true: 变更成功，false: 变更失败
    **/
    bool alterTablePrintSumBillPosDBLength();

    /**
    *功能:插入一条汇总单信息到pos本地数据库中;
    *参数:[1]订单对象指针 [2]小票号 [3]Pos机实际开单时间
    *返回:true操作成功，false失败
    **/
    bool insertOrderSumBill(OrderObject* orderObj, const QString& posCheckNo, const QString& posCheckTime);

    /**
    *功能:为了解耦POS, 需要提前将汇总单信息插入到pos本地数据库中,小票号+开单时间等信息需要真实入机后进行更新;
    *参数:[1]订单对象指针 [2]小票号 [3]Pos机实际开单时间
    *返回:true操作成功，false失败
    **/
    bool updateSumBillCknoAndCktime(OrderObject* orderObj, const QString& posCheckNo, const QString& posCheckTime);

    /**
    *功能: 根据订单对象指针  同步pos本地数据库中数据;
    *参数:[1]订单对象指针
    *返回:  0: 同步失败；1: 无需同步；2: 同步成功;
    **/
    int syncOrderDataToDB(OrderObject* orderObj);

    /**
    *功能: 根据订单对象 同步pos数据库中汇总单中的预约信息;
    *参数:[1]订单对象指针
    *返回: 0: 同步失败；1: 无需同步；2: 同步成功;
    **/
    int syncOrderTimeInfo(OrderObject* orderObj);

    /**
    *功能: 根据订单对象指针  更新pos本地数据库中数据;
    *参数:[1]订单对象指针
    *返回:  0: 更新失败；1: 无需更新； 2: 更新成功;
    **/
    int updateOrderDataToDB(OrderObject* orderObj,  const QString &cloumnName);

    /**
    *功能: 根据订单对象 更新 pos数据库中汇总单中的预约信息;
    *参数:[1]订单号
    *返回:true操作成功，false失败
    **/
    bool updateOrderTimeInfo(OrderObject* orderObj);

    /**
    *功能: 根据订单ID 更新 pos本地数据库中汇总单状态信息;
    *参数:[1]订单号[2] [3] [4] [5] [6]
    *返回:true操作成功，false失败
    **/
    bool updateOrderSumBillStatus(OrderObject* orderObj, const int &OrderStatus);

    /**
    *功能:查询 订单号和小票号 的汇总账单是否存在本地的POS系统中;
    *参数:[1]订单号 [2]小票号
    *返回:true是，false否
    **/
    bool isOrderAndCknoSumBillExist(const QString& orderId,const QString& posCheckNo);

    /**
    *功能:查询订单的汇总账单是否存在本地的POS系统中;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderSumBillExist(OrderObject* orderObj);

    /**
    *功能:清除汇总账单DB 中过期记录;
    *参数:[1]记录创建时间
    *返回:true是，false否
    **/
    bool deleteSumBillRecord(QString creatTime);

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);
    bool queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result);

private:
    QMutex m_mutex;
    PrintSumBillPosDB();
    PrintSumBillPosDB(PrintSumBillPosDB const&);
    PrintSumBillPosDB& operator=(PrintSumBillPosDB const&);
    QSqlDatabase m_sqlDb;

signals:
    void triggerFlowContrlAlert(AlertForm::Type alterType, const QString msg);

public slots:
};

#endif // PRINTSUMBILLPOSDB_H
