﻿#include "printSumBillPosDB.h"
#include "QsLog.h"
#include <QDateTime>
#include "Control/flowControl.h"

PrintSumBillPosDB::PrintSumBillPosDB()
{
    QLOG_INFO()<<"[<<<<---PrintSumBillPosDB:: Structure POS Print CheckNo INFO DataBase--->>>>]";

    // 为了发出告警消息;  注册信号槽参数
    qRegisterMetaType<AlertForm::Type>("AlertForm::Type");

    connect(this, &PrintSumBillPosDB::triggerFlowContrlAlert, &FlowControl::GetInstance(), &FlowControl::onTriggerFlowContrlAlert);
}


bool PrintSumBillPosDB::initPrintSumBillPosDB(){
    //QString dbPath = QString(ConfigManage::Instance().databasePath());
    bool bRet = false, bRet20 = false, bRet21 = false;
    bool bRetCheckColumn = false;
    bool bRetChangeLength = false;
    m_sqlDb = QSqlDatabase::addDatabase("QODBC","PrintSumBillPosDB");   //数据库驱动类型为SQL Server
    if ( m_sqlDb.isValid() ) {
        QLOG_INFO()<<"[<<<<---SqlServer ODBC driver is valid--->>>>]";
        QString dsn="DRIVER={SQL SERVER};SERVER=127.0.0.1\\sqlexpress;DATABASE=MMXBenefits";
        m_sqlDb.setDatabaseName(dsn);                            //设置数据源名称
        m_sqlDb.setUserName("sa");                               //登录用户
        m_sqlDb.setPassword("SIM29@123");
        if(!m_sqlDb.open()) {                                      //打开数据库
            QLOG_ERROR()<<"[<<<<---SqlServer Open Database error:--->>>>]"<<m_sqlDb.lastError().text();
            bRet = false;
        } else {
            QLOG_INFO()<<"[<<<<---SqlServer Test Open database success!:--->>>>]";
            m_sqlDb.close();
            bRet = true;
        }
    } else {
        QLOG_ERROR()<<"[<<<<---SqlServer ODBC driver no valid--->>>>]";
        bRet = false;
    }

    bRet = alterTablePrintSumBillPosDB();
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM TakeOut Plugin Version:2.20181130.1 Begin Add New Column  Result: %1--->>>>]").arg(bRet?1:0);

    bRetCheckColumn = alterTablePrintSumBillPosDBAndCheck();
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM TakeOut Plugin Version:2.2019.520.1 Begin Alter table tb_msr_customer_info Column Result: %1--->>>>]")
                 .arg(bRetCheckColumn?1:0);

    bRet20 = alterTablePrintSumBillPosDB20();
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM TakeOut Plugin Version:2.2020.5.12  Begin Add New Column  Result: %1--->>>>]").arg(bRet20?1:0);

    bRetChangeLength = alterTablePrintSumBillPosDBLength();
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM TakeOut Plugin Version:2.2020.9.28 Begin Change Store Column  Result: %1--->>>>]")
                 .arg(bRetChangeLength?1:0);

    bRet21 = alterTablePrintSumBillPosDB21();
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM TakeOut Plugin Version:2.2021.8.2  Begin Add New Column  Result: %1--->>>>]").arg(bRet21?1:0);

    return (bRet && bRetCheckColumn && bRet20 && bRetChangeLength && bRet21 );
}

bool PrintSumBillPosDB::alterTablePrintSumBillPosDB() {
    QMutexLocker mutex(&m_mutex);
    int addSuccessNum = 0;
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    // Alter Table disPlateformFee;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='disPlateformFee'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add disPlateformFee int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info disPlateformFee Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table memo;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='memo'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add memo varchar(400) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info memo Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve0;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve0'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve0  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve0 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve1;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve1'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve1  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve1 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve2;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve2'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve2  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve2 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve3;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve3'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve3  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve3 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    }  else { addSuccessNum++;}
    // Alter Table reserve4;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve4'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve4  varchar(200) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve4 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve5;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve5'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve5  varchar(400) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve5 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    m_sqlDb.close();
    if (8 == addSuccessNum) {
        QLOG_INFO()<<"[<<<<---alterTablePrintSumBillPosDB::addSuccessNum = 8 --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB::addSuccessNum<8 = --->>>>]"<<addSuccessNum;
        return false;
    }
}


bool PrintSumBillPosDB::alterTablePrintSumBillPosDBAndCheck() {
    QMutexLocker mutex(&m_mutex);
    int checkSuccessNum = 0;
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDBAndCheck::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    // Alter Table accept_name;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='accept_name'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add accept_name varchar(400) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info accept_name Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table accept_address ;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='accept_address'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add accept_address varchar(800) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info accept_address Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table accept_phone;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='accept_phone'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add accept_phone varchar(20) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info accept_phone Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table order_id;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='order_id'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add order_id varchar(50) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info order_id Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table order_status;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='order_status'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add order_status int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info order_status Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table waybill_id;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='waybill_id'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add waybill_id varchar(50) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info waybill_id Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    }  else { checkSuccessNum++;}
    // Alter Table take_no;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='take_no'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add take_no int null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info take_no Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}
    // Alter Table deliver_phone;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='deliver_phone'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add deliver_phone varchar(20) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info deliver_phone Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}

    // Alter Table deliver_name;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='deliver_name'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add deliver_name varchar(400) null";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info deliver_name Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { checkSuccessNum++; }
    } else { checkSuccessNum++;}

    m_sqlDb.close();
    if (9 == checkSuccessNum) {
        QLOG_INFO()<<"[<<<<---alterTablePrintSumBillPosDBAndCheck::checkSuccessNum = 9 --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDBAndCheck::checkSuccessNum < 9 = --->>>>]"<<checkSuccessNum;
        return false;
    }
}

bool PrintSumBillPosDB::alterTablePrintSumBillPosDB20() {
    QMutexLocker mutex(&m_mutex);
    int addSuccessNum = 0;
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB20::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }

    // Alter Table appointed_time;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='appointed_time'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add appointed_time datetime default  NULL ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info appointed_time Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table appointed_remindTemplate;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='appointed_remindTemplate'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add appointed_remindTemplate varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info appointed_remindTemplate Faild--->>>>]" <<
                           query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table order_type;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='order_type'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add order_type  int default  NULL ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info order_type Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table channel;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='channel'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add channel  varchar(20) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info channel Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table platform_source;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='platform_source'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add platform_source  varchar(10) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info platform_source Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table pay_way;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='pay_way'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add pay_way  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info pay_way Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    }  else { addSuccessNum++;}

    // Alter Table customer_id;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='customer_id'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add customer_id  varchar(50) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info customer_id Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table customer_name;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='customer_name'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add customer_name  varchar(50) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info customer_name Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}


    // Alter Table msr_no;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='msr_no'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add msr_no  varchar(50) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info msr_no Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table store_id;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='store_id'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add store_id  varchar(20) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_id Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table sub_store_id;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='sub_store_id'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add sub_store_id  varchar(20) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info sub_store_id Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table store_name;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='store_name'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add store_name  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_name Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table store_address;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='store_address'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add store_address  varchar(600) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_address Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table is_package;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='is_package'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add is_package  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info is_package Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table order_discount;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='order_discount'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add order_discount int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info order_discount Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table total_price;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='total_price'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add total_price  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info total_price Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve6;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve6'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve6  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve6 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve7;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve7'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve7  int null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve7 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve8;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve8'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve8  varchar(80) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve8 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve9;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve9'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve9  varchar(80) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve9 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve10;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve10'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve10  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve10 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve11;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve11'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve11  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve11 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve12;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve12'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve12  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve12 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve13;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve13'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve13  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve13 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve14;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve14'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve14  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve14 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}
    // Alter Table reserve15;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve15'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve15  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve15 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    m_sqlDb.close();
    if (26 == addSuccessNum) {
        QLOG_INFO()<<"[<<<<---alterTablePrintSumBillPosDB::addSuccessNum = 26 --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB::addSuccessNum< 26 --->>>>]"<<addSuccessNum;
        return false;
    }
}


bool PrintSumBillPosDB::alterTablePrintSumBillPosDB21() {
    QMutexLocker mutex(&m_mutex);
    int addSuccessNum = 0;
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB21::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }

    // Alter Table reserve16;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve16'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve16  varchar(80) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve16 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve17;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve17'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve17  varchar(80) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve17 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve18;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve18'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve18  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve18 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve19;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve19'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve19  varchar(100) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve19 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve20;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve20'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve20  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve20 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve21;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve21'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add reserve21  varchar(150) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info reserve21 Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table reserve22 ~ reserve40;
    for ( int index = 22 ; index < 41 ; index++) {
        selectsql = QString("select * from syscolumns where id=object_id('tb_msr_customer_info') and name='reserve%1'").arg(index);
        query.exec(selectsql);
        if(!query.next()){
            selectsql = QString("alter table tb_msr_customer_info add reserve%1  int null ").arg(index);
            if(!query.exec(selectsql)){
                QLOG_ERROR()<< QString("[<<<<---alter table tb_msr_customer_info reserve%1 Faild--->>>>]").arg(index) <<query.lastError().text()<<QString::number(query.lastError().type());
            } else { addSuccessNum++; }
        } else { addSuccessNum++;}

    }

    m_sqlDb.close();
    if (25 == addSuccessNum) {
        QLOG_INFO()<<"[<<<<---alterTablePrintSumBillPosDB21::addSuccessNum = 25 --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDB21::addSuccessNum< 25 --->>>>]"<<addSuccessNum;
        return false;
    }

}


bool PrintSumBillPosDB::alterTablePrintSumBillPosDBLength(){
    QMutexLocker mutex(&m_mutex);
    int changeSuccessNum = 0;
    int addSuccessNum = 0;
    QSqlQuery query(m_sqlDb);
    QString selectsql;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDBAndCheck::SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }

    // Alter Table store_name Length 80 ->150;
    selectsql = "select length  from syscolumns where id=object_id('tb_msr_customer_info') and name='store_name'";
    query.exec(selectsql);
    if(!query.next()){
        QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_name  not exist--->>>>]" <<
                       query.lastError().text()<<QString::number(query.lastError().type());
    } else {
        int columnLength = query.value(0).toInt();
        if ( columnLength < 150 ) {
            selectsql = "alter table tb_msr_customer_info alter column store_name  varchar(150) ";
            if(!query.exec(selectsql)){
                QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_name alter Length Failed--->>>>]" <<
                               query.lastError().text()<<QString::number(query.lastError().type());
            } else { changeSuccessNum++; }
        } else { changeSuccessNum++; }
    }

    // Alter Table store_address Length 200 ->600;
    selectsql = "select length from syscolumns where id=object_id('tb_msr_customer_info') and name='store_address'";
    query.exec(selectsql);
    if(!query.next()){
       QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_address not exist--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
    } else {
        int columnLength = query.value(0).toInt();
        if ( columnLength < 600 ) {
            selectsql = "alter table tb_msr_customer_info alter column store_address  varchar(600) ";
            if(!query.exec(selectsql)){
                QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info store_address alter Length Faild--->>>>]" <<
                               query.lastError().text()<<QString::number(query.lastError().type());
            } else { changeSuccessNum++; }
        } else { changeSuccessNum++; }
    }


    // Alter Table orderPayType;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='orderPayType'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add orderPayType int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info orderPayType Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table sbkAppPayType;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='sbkAppPayType'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add sbkAppPayType int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info sbkAppPayType Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table sbkAppPayValue;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='sbkAppPayValue'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add sbkAppPayValue varchar(60) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info sbkAppPayValue Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table sbkAppRefundPayValue;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='sbkAppRefundPayValue'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add sbkAppRefundPayValue varchar(60) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info sbkAppRefundPayValue Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table orderTransFlowNo;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='orderTransFlowNo'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add orderTransFlowNo varchar(60) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info orderTransFlowNo Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table orderRefundTransFlowNo;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='orderRefundTransFlowNo'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add orderRefundTransFlowNo varchar(60) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info orderRefundTransFlowNo Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table pluginVersion;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='pluginVersion'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add pluginVersion varchar(20) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info pluginVersion Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table packageSku;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='packageSku'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add packageSku varchar(20) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info packageSku Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table thirdPartyOrderId;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='thirdPartyOrderId'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add thirdPartyOrderId varchar(60) null ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info thirdPartyOrderId Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table packFee;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='packFee'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add packFee  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info packFee Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table packDiscount;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='packDiscount'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add packDiscount  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info packDiscount Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table deliveryFee;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='deliveryFee'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add deliveryFee  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info deliveryFee Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table deliveryDiscount;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='deliveryDiscount'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add deliveryDiscount  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info deliveryDiscount Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}

    // Alter Table discountShopFee;
    selectsql = "select * from syscolumns where id=object_id('tb_msr_customer_info') and name='discountShopFee'";
    query.exec(selectsql);
    if(!query.next()){
        selectsql = "alter table tb_msr_customer_info add discountShopFee  int default  0 ";
        if(!query.exec(selectsql)){
            QLOG_ERROR()<< "[<<<<---alter table tb_msr_customer_info discountShopFee Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
        } else { addSuccessNum++; }
    } else { addSuccessNum++;}


    m_sqlDb.close();
    if (2 == changeSuccessNum && 14 == addSuccessNum) {
        QLOG_INFO()<<"[<<<<---alterTablePrintSumBillPosDBLength:: changeSuccessNum = 2 && addSuccessNum = 14  --->>>>]";
        return true;
    } else {
        QLOG_ERROR()<<"[<<<<---alterTablePrintSumBillPosDBLength:: changeSuccessNum < 2 or addSuccessNum < 14 --->>>>]"
                   <<changeSuccessNum;
        return false;
    }
}

PrintSumBillPosDB &PrintSumBillPosDB::getInstance()
{
    static PrintSumBillPosDB printSumBillPosDB;
    return printSumBillPosDB;
}

bool PrintSumBillPosDB::insertOrderSumBill(OrderObject* orderObj, const QString& posCheckNo, const QString& posCheckTime){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;

    //刷新 存储订单 销售退货状态的内存标识;
    orderObj->orderSaleRefundStatus = orderObj->orderStatus == 6 ? 6 : 3 ;

    QSqlQuery query(m_sqlDb);
    query.prepare("INSERT INTO tb_msr_customer_info(chk_num, last_name, full_name, gender, "
                  " is_birthday, create_datetime, created_by, modify_datetime, modified_by, accept_name, accept_address, accept_phone, order_id, "
                  " order_status, waybill_id, take_no, deliver_phone, deliver_name, disPlateformFee, memo, reserve3, reserve4, reserve0, reserve2, reserve6, reserve7, reserve5,"
                  " appointed_time, appointed_remindTemplate, order_type, channel, platform_source,"
                  " pay_way, customer_id, customer_name, msr_no, store_id, sub_store_id, store_name, store_address, is_package, order_discount, total_price, "
                  " orderPayType, sbkAppPayType, sbkAppPayValue, sbkAppRefundPayValue, orderTransFlowNo, orderRefundTransFlowNo, "
                  " pluginVersion, packageSku, thirdPartyOrderId, discountShopFee, packFee, packDiscount, deliveryFee, deliveryDiscount, "
                  " reserve8, reserve9, reserve10, reserve22, reserve23, reserve24 ) "
                  "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, "
                  " ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ? , ?, ?)" );
    query.addBindValue(posCheckNo.toInt()); // --小票号
    query.addBindValue(orderObj->lastName); // --顾客-姓
    query.addBindValue(orderObj->consigneeName); // --顾客-全名
    QString temp_customerSex;
    if( !orderObj->customerSex.compare(QString::fromLocal8Bit(FM_MALE)) || !orderObj->customerSex.compare(QString("Male")) ){
        temp_customerSex = "Male";
    }else if( !orderObj->customerSex.compare(QString::fromLocal8Bit(FM_FEMALE)) || !orderObj->customerSex.compare(QString("Female")) ){
        temp_customerSex = "Female";
    }else{ temp_customerSex = ""; }
    query.addBindValue(temp_customerSex); // --顾客-性别
    query.addBindValue(0); // --顾客-生日

    QDateTime qdaTi = QDateTime::currentDateTimeUtc();
    QString posCheckOpenTime  = posCheckTime.length()?
                qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd ") + posCheckTime : qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd hh:mm:ss");

    query.addBindValue(posCheckOpenTime); // --POS开单时间
    query.addBindValue(FlowControl::GetInstance()._GetCashierId()); // --订单处理者
    query.addBindValue(""); // --变更订单时间 //??????????????????????????????????????????
    query.addBindValue(""); // --变更订单作者 [*****后期更新*****]
    query.addBindValue(orderObj->consigneeName); // --收货者-人名
    query.addBindValue(orderObj->addressDetail); // --收货者
    query.addBindValue(orderObj->consigneePhone); // --收货者-电话
    query.addBindValue(orderObj->id); // --订单编号
    // query.addBindValue( orderObj->orderStatus );  // --订单状态(int);
    query.addBindValue( orderObj->orderSaleRefundStatus );  // --订单 销售退货状态 内存标识(int);
    query.addBindValue((orderObj->waybillId).length()?orderObj->waybillId:QString("0") ); // --物流编号
    query.addBindValue((orderObj->pickupCode).length()?orderObj->pickupCode.toInt():0 ); // --取餐号；
    query.addBindValue(orderObj->riderPhone); // --配送者电话
    query.addBindValue(orderObj->riderName); // -配送者名称
    if ( orderObj->decouplePosVersion>= 20 && OrderObject::Refunded == orderObj->orderStatus ) {
        query.addBindValue( 0 - abs(orderObj->disPlateformFee) ); // --解耦POS后, 退单平台优惠金额需为负数;
    } else {
        query.addBindValue( abs(orderObj->disPlateformFee)); // --平台优惠
    }
    query.addBindValue(orderObj->memo);   // --订单备注
    query.addBindValue(orderObj->secretSignal);    // --接头暗号
    query.addBindValue(orderObj->consumerRemark);   // --顾客备注

    // 与 oms协定此块业务出现 歧异 故在此处转换;
    int tempBusinessType = orderObj->businessType.toInt();
    if ( "WSG-MOD" == orderObj->channel && "4" == orderObj->platformSource) {
        if ( 1 == orderObj->isGiftitForward )
            tempBusinessType = 21;
        else
            tempBusinessType = 20;
    }
    if  ( 7 == orderObj->orderType  ||  11 == orderObj->orderType) {
         tempBusinessType = 10;
    } else if ( 8 == orderObj->orderType ) {
         tempBusinessType = 30;
    }
    query.addBindValue( tempBusinessType );   // --订单业务类型: 10:预约单  20:WSG-杯贴祝福  21:WSG-美好咖啡  30:拼团

    query.addBindValue( orderObj->storeType );  // 1:标识: 一店两址的门店类型 [ adidas 店 ]
    query.addBindValue( orderObj->globalOrderType );
    query.addBindValue( orderObj->globalServiceType );
    query.addBindValue(orderObj->lastExpectDate);   // -- 上一次预约取餐时间
    query.addBindValue(orderObj->expectDate);   // -- 预约取餐时间
    QString tempAppointedRemindTemplate  = QString::number(orderObj->inAdvanceTakemeal) + ";" + orderObj->reserveMakeTime; // 预约模板;
    query.addBindValue(tempAppointedRemindTemplate);
    query.addBindValue(orderObj->orderType);

    QString tempChannel = ("WSG-MOD" == orderObj->channel)?"MOD" :orderObj->channel;
    query.addBindValue(tempChannel);
    query.addBindValue(orderObj->platformSource);
    query.addBindValue(orderObj->payWay);
    query.addBindValue(orderObj->customerId);
    query.addBindValue(orderObj->customerName);
    query.addBindValue(orderObj->msr_no);
    query.addBindValue(orderObj->storeId);
    query.addBindValue(orderObj->subStoreId);
    query.addBindValue(orderObj->storeName);
    query.addBindValue(orderObj->storeAddress);
    query.addBindValue(orderObj->isPackage);
    if ( orderObj->decouplePosVersion>= 20 && OrderObject::Refunded == orderObj->orderStatus ) {
        query.addBindValue( 0 - orderObj->orderDiscount ); // --解耦POS后, 退单整单优惠金额需为负数;
        query.addBindValue( 0 - orderObj->totalPrice);         // --解耦POS后, 退单待付总金额需为负数;
    } else {
        query.addBindValue(orderObj->orderDiscount);
        query.addBindValue(orderObj->totalPrice);
    }
    query.addBindValue(0); // OMS订单支付类型 待定, 预留
    query.addBindValue(orderObj->sbkAppPayType);
    query.addBindValue(orderObj->sbkAppPayValue);
    query.addBindValue(orderObj->sbkAppRefundPayValue);
    query.addBindValue(orderObj->thirdPartyBatch);
    query.addBindValue( "" );  // orderRefundTransFlowNo 目前还没有三方订单 销售/退货的交易流水不一致情况;
    query.addBindValue( APP_VERSION );          // 插件版本号;
    query.addBindValue(orderObj->packageSku);   // 打包sku;
    query.addBindValue(orderObj->thirdPartyOrderId);    // 三方订单号
    query.addBindValue(0);    // 商家优惠; 目前暂时使用不到，预留;
    if ( orderObj->decouplePosVersion>= 20 && OrderObject::Refunded == orderObj->orderStatus ) {
        query.addBindValue( 0 - orderObj->packageFee ); // --解耦POS后, 退单打包金额需为负数;
        query.addBindValue( 0 - orderObj->packDiscount); // --解耦POS后, 退单打包优惠金额需为负数;
        query.addBindValue( 0 - orderObj->deliveryPrice ); // --解耦POS后, 退单配送费金额需为负数;
        query.addBindValue( 0 - orderObj->deliveryDiscount); // --解耦POS后, 退单配送费优惠金额需为负数;
    } else {
        query.addBindValue(orderObj->packageFee);   //打包费
        query.addBindValue(orderObj->packDiscount);   //打包折扣
        query.addBindValue(orderObj->deliveryPrice);   // 配送费;
        query.addBindValue(orderObj->deliveryDiscount);   // 配送费折扣;
    }

    query.addBindValue(orderObj->carNumber);              // Curbside-车牌号;
    query.addBindValue(orderObj->privacyPhone);          // Curbside-隐私号
    query.addBindValue(orderObj->remindTicketTime);    // Curbside-打印街送提醒小票时间
    query.addBindValue(orderObj->extendType);    // 扩展类型:  20: MOD PLUS 渠道;
    query.addBindValue(orderObj->deliveryProvider);    // 配送商家类型:  1:蜂鸟  2:美团;
    query.addBindValue(orderObj->deliveryType);    // 配送方式:  1: 二轮车   2:四轮车;

    QLOG_INFO()<<QString("[<<<--PrintSumBillPosDB::insertOrderSumBill  waybillId:%1-->>>>]").arg((orderObj->waybillId).length()?orderObj->waybillId:QString("0"));

    if(!query.exec())
    {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:customer_info Error--->>>>]"<<query.lastError().text()<<QString::number(query.lastError().type());
        result = false;
        QLOG_INFO()<<QString("INSERT INTO tb_msr_customer_info(chk_num, last_name, full_name, gender, "
                             " is_birthday, create_datetime, created_by, modify_datetime, modified_by, "
                             " accept_name, accept_address, accept_phone, order_id, "
                             " waybill_id, take_no, deliver_phone, deliver_name, disPlateformFee, memo, reserve3, reserve4, reserve0, reserve2, reserve6, reserve7, reserve5,"
                             " appointed_time, appointed_remindTemplate, order_type, channel, platform_source,"
                             " pay_way, customer_id, customer_name, msr_no, store_id, sub_store_id, store_name, store_address, is_package, order_discount, total_price"
                             " orderPayType, sbkAppPayType, sbkAppPayValue, sbkAppRefundPayValue, orderTransFlowNo, orderRefundTransFlowNo, "
                             " pluginVersion, packageSku, thirdPartyOrderId, discountShopFee, packFee, packDiscount, deliveryFee, deliveryDiscount, "
                             " reserve8, reserve9, reserve10, reserve22, reserve23, reserve24 ) "
                             "VALUES(%1, %2, %3, %4, %5, %6, %7, %8, %9, %10, %11, %12, %13, %14, %15, %16, %17, %18,"
                             " %19, %20, %21, %22, %23, %24, %25, %26, %27, %28, %29, %30,%31, %32, %33, %34, %35, %36, %37, %38, %39, %40, %41, %42"
                             " %43, %44, %45, %46, %47, %48, %49, %50,%51, %52, %53, %54, %55, %56, %57, %58, %59, %60, %61, %62, %63 )")
                     .arg(posCheckNo.toInt())
                     .arg(orderObj->lastName).arg(orderObj->customerName).arg(temp_customerSex)
                     .arg(0).arg(qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd hh:mm:ss")).arg(FlowControl::GetInstance()._GetCashierId()).arg("").arg("")
                     .arg(orderObj->consigneeName).arg(orderObj->addressDetail).arg(orderObj->consigneePhone).arg(orderObj->id)
                     .arg((orderObj->waybillId).length()?orderObj->waybillId:QString("0"))
                     .arg(orderObj->pickupCode.length()==0?0:orderObj->pickupCode.toInt())
                     .arg(orderObj->riderPhone).arg(orderObj->riderName).arg(abs(orderObj->disPlateformFee))
                     .arg(orderObj->memo).arg(orderObj->secretSignal).arg(orderObj->consumerRemark).arg( tempBusinessType )
                     .arg(orderObj->storeType).arg(orderObj->globalOrderType).arg(orderObj->globalServiceType).arg(orderObj->lastExpectDate)
                     .arg(orderObj->expectDate).arg(tempAppointedRemindTemplate).arg(orderObj->orderType).arg(orderObj->channel)
                     .arg(orderObj->platformSource).arg(orderObj->payWay)
                     .arg(orderObj->customerId).arg(orderObj->customerName).arg(orderObj->msr_no).arg(orderObj->storeId).arg(orderObj->subStoreId)
                     .arg(orderObj->storeName).arg(orderObj->storeAddress).arg(orderObj->isPackage).arg(orderObj->orderDiscount).arg(orderObj->totalPrice)
                     .arg(0).arg(orderObj->sbkAppPayType).arg(orderObj->sbkAppPayValue).arg(orderObj->sbkAppRefundPayValue).arg(orderObj->thirdPartyBatch)
                     .arg("").arg(APP_VERSION).arg(orderObj->packageSku).arg(orderObj->thirdPartyOrderId).arg(0).arg(orderObj->packageFee)
                     .arg(orderObj->packDiscount).arg(orderObj->deliveryPrice).arg(orderObj->deliveryDiscount)
                     .arg(orderObj->carNumber).arg(orderObj->privacyPhone).arg(orderObj->remindTicketTime)
                     .arg(orderObj->extendType).arg(orderObj->deliveryProvider).arg(orderObj->deliveryType);
    } else {
        QLOG_INFO()<<QString("[<<<<---SqlServer Database:Insert OrderId %1 Into tb_msr_customer_info Success--->>>>]").arg(orderObj->id);
        result = true;
    }

    // 订单解耦前需入机订单 && 订单状态为取消 && 预约订单时，需要更新 该订单在tb_msr_customer_info表中全部记录的订单状态;
    if ( OrderObject::Refunded ==orderObj->orderStatus && ( 7 == orderObj->orderType || 11 == orderObj->orderType ) ) {
        QSqlQuery updateQuery(m_sqlDb);
        // 销售单存 1 记录(自定义组装 小票号); 退货时 也会存 1 记录(自定义组装 小票号); 该订单号将会出现两个退货记录 且 小票号还不一致
        // 解耦前 / 解耦后 都需要此逻辑: 预约单退货场景: 在预约时间到到达前, 订单被取消, 若不重置销售单记录的订单状态为 6 , POS预约提醒会继续打印;
        updateQuery.prepare(QString("update tb_msr_customer_info set order_status='%1' where order_id='%2' ").arg(orderObj->orderStatus).arg(orderObj->id));

        if(!updateQuery.exec()) {
            QLOG_ERROR()<<updateQuery.lastError().text()<<QString("[<<<<---SqlServer Database:Update tb_msr_customer_info OrderId %1 Refund orderStatus Failed--->>>>]")
                          .arg(orderObj->id);
        } else {
            QLOG_INFO()<<QString("[<<<<---SqlServer Database:update tb_msr_customer_info OrderId %1 Refund orderStatus success--->>>>]").arg(orderObj->id);
        }
    }

    m_sqlDb.close();
    return result;
}


bool PrintSumBillPosDB::updateSumBillCknoAndCktime(OrderObject* orderObj, const QString& posCheckNo, const QString& posCheckTime){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }

    bool result = false;
    QDateTime qdaTi = QDateTime::currentDateTimeUtc();
    QString posCheckOpenTime  = posCheckTime.length()?
                qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd ") + posCheckTime : qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd hh:mm:ss");

    QSqlQuery updateQuery(m_sqlDb);

    // 订单状态为取消 && 预约订单时，需要更新 该订单在tb_msr_customer_info表中全部记录的订单状态;
    // 目前此函数只有在入机后 Action5 中调用更新; 为增强其扩展性:解耦后POS版本也可以使用;
    if ( orderObj->decouplePosVersion >= 20 ) {
        if ( OrderObject::Refunded ==orderObj->orderStatus ) {
            updateQuery.prepare(QString("update tb_msr_customer_info set chk_num = %1, create_datetime = '%2' where order_status = 6 and order_id = '%3' ")
                                .arg( posCheckNo.toInt() ).arg( posCheckOpenTime ).arg(orderObj->id));
        } else {
            updateQuery.prepare(QString("update tb_msr_customer_info set  chk_num = %1, create_datetime = '%2' where order_status <> 6 and order_id = '%3' ")
                                .arg( posCheckNo.toInt() ).arg( posCheckOpenTime ).arg( orderObj->id )  );
        }
    } else {
        if (OrderObject::Refunded ==orderObj->orderStatus && ( 7 == orderObj->orderType || 11 == orderObj->orderType ) ) {
            updateQuery.prepare(QString("update tb_msr_customer_info set chk_num = %1, create_datetime = '%2', order_status = 6  where order_id = '%3' ")
                                .arg( posCheckNo.toInt() ).arg( posCheckOpenTime ).arg(orderObj->id));
        } else {
            updateQuery.prepare(QString("update tb_msr_customer_info set  chk_num = %1, create_datetime = '%2' where order_status <> 6 and order_id = '%3' ")
                                .arg( posCheckNo.toInt() ).arg( posCheckOpenTime ).arg( orderObj->id )  );
        }
    }


    if(!updateQuery.exec())
    {
        QLOG_ERROR()<<updateQuery.lastError().text()<<QString::number(updateQuery.lastError().type())<<
                      QString("[<<<<---SqlServer Database: Update OrderId %1 tb_msr_customer_info:Ckno Cktime Status Error--->>>>]").arg(orderObj->id);
    } else {
        QLOG_INFO()<<QString("[<<<<---SqlServer Database: update OrderId %1  tb_msr_customer_info:Ckno Cktime Status  Success--->>>>]").arg(orderObj->id);
        result = true;
    }

    m_sqlDb.close();
    return result;
}


int PrintSumBillPosDB::syncOrderDataToDB(OrderObject* orderObj) {
    // 0: 同步失败；1: 无需同步；2: 同步成功;
    int syncOrderTimeRet = 1;
    // 1、同步 预约当日订单的 "提前到店" 信息，避免出现 遗漏；
    if  ( OrderObject::Refunded != orderObj->orderStatus && ( 7 == orderObj->orderType  || 11 == orderObj->orderType )  && orderObj->inAdvanceTakemeal ) {
        syncOrderTimeRet =  syncOrderTimeInfo(orderObj);
        QLOG_INFO()<<QString("[<<<<---syncOrderDataToDB OrderId: %1 ArriverAhead: %2  syncOrderTimeRet: %3 "
                             " reserveMakeTime:%4  lastExpectDate:%5  expectDate:%6  remindTicketTime:%7 --->>>>]")
                     .arg(orderObj->id).arg(orderObj->inAdvanceTakemeal).arg(syncOrderTimeRet).arg(orderObj->reserveMakeTime).arg(orderObj->lastExpectDate)
                     .arg(orderObj->expectDate).arg(orderObj->remindTicketTime);
    }

    // 2、同步其他......

    return syncOrderTimeRet;
}

int PrintSumBillPosDB::syncOrderTimeInfo(OrderObject* orderObj) {
    QMutexLocker mutex(&m_mutex);
    // 0: 更新失败; 1:无需更新;  2: 更新成功;
    int syncRet = 0;
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }

    // 先查找记录(退单无需更新) 判断是否需要同步；在记录同步记录结果;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString(" select appointed_remindTemplate from tb_msr_customer_info where order_id='%1' and order_status !=6").arg(orderObj->id));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<QString("[<<<<---SqlServer Database: select OrderId %1 appointed* Time Failed--->>>>]").arg(orderObj->id);
        syncRet= 0;
    } else {
        if ( query.first() && query.value(0).toString().length() ) {
            QString tempRemindTemplate  = query.value(0).toString().split(';').first();

            if ( 3 == orderObj->inAdvanceTakemeal ) {

                QSqlQuery updateQuery(m_sqlDb);
                updateQuery.prepare(QString("update tb_msr_customer_info set appointed_remindTemplate='%1', appointed_time ='%4', reserve5='%2', reserve10='%5' "
                                            " where order_id='%3' and order_status !=6")
                                    .arg(QString::number(orderObj->inAdvanceTakemeal) + ";" + orderObj->reserveMakeTime)
                                    .arg(orderObj->lastExpectDate).arg(orderObj->id).arg(orderObj->expectDate).arg(orderObj->remindTicketTime) );
                if(!updateQuery.exec()) {
                    QLOG_ERROR()<<updateQuery.lastError().text()<<QString("[<<<<---DB::Sync OrderId %1 appointed* Time Failed--->>>>]").arg(orderObj->id);
                    syncRet= 0;
                } else {
                    QLOG_INFO()<<QString("[<<<<---DB::Sync OrderId %1 appointed* Time success--->>>>]").arg(orderObj->id);
                    syncRet= 2;
                }

            } else if (  orderObj->inAdvanceTakemeal != tempRemindTemplate.toInt() ) {

                QSqlQuery updateQuery(m_sqlDb);
                updateQuery.prepare(QString("update tb_msr_customer_info set appointed_remindTemplate='%1', appointed_time ='%4', reserve5='%2' "
                                            " where order_id='%3' and order_status !=6")
                                    .arg(QString::number(orderObj->inAdvanceTakemeal) + ";" + orderObj->reserveMakeTime)
                                    .arg(orderObj->lastExpectDate).arg(orderObj->id).arg(orderObj->expectDate) );
                if(!updateQuery.exec()) {
                    QLOG_ERROR()<<updateQuery.lastError().text()<<QString("[<<<<---DB::Sync OrderId %1 appointed* Time Failed--->>>>]").arg(orderObj->id);
                    syncRet= 0;
                } else {
                    QLOG_INFO()<<QString("[<<<<---SqlServer Database:Sync OrderId %1 appointed* Time success--->>>>]").arg(orderObj->id);
                    syncRet= 2;
                }

                // 内存中 inAdvanceTakemeal 标识 与 本地数据库中 标识不一致时，且 是修改预约时间时，需要插件弹框提醒;
                if ( 2 == orderObj->inAdvanceTakemeal ) {
                    QString  warnMsg =  QString::fromLocal8Bit("用户修改 %1 预约时间;    订单尾号:  %2;    订单号:  %3;    新预约时间:  %4;    原预约时间:  %5")
                            .arg( orderObj->channel ).arg( orderObj->id.mid(orderObj->id.length() - 5, 5) ).arg(orderObj->id)
                            .arg( orderObj->expectDate.mid(11,5) ).arg( orderObj->lastExpectDate.mid(11,5) );

                    emit triggerFlowContrlAlert(AlertForm::WARNNING,warnMsg);
                    // Can't Emit Success; emit FlowControl::GetInstance().showAlert(AlertForm::WARNNING, warnMsg );
                }

            } else {
                // orderObj->inAdvanceTakemea != 3 &&  orderObj->inAdvanceTakemeal != tempRemindTemplate.toInt() [ inAdvanceTakemea 与本地数据库中值一致 ]
                syncRet= 1;
            }

        } else {
            // 订单-汇总小票表中无此订单记录: 没有销售单, 仅有退货单;
            syncRet= 1;
        }
    }

    m_sqlDb.close();
    return  syncRet;
}

int PrintSumBillPosDB::updateOrderDataToDB(OrderObject* orderObj, const QString &cloumnName) {
    // 0: 更新失败;  1: 更新成功;   2: 更新成功;
    int updateOrderTimeRet = 1;

    if ("UpdateTimeAction"==cloumnName ) {
        // 1、更新 预约当日订单的 "提前到店" 信息，避免出现 遗漏；
        if  ( OrderObject::Refunded != orderObj->orderStatus && ( 7 == orderObj->orderType  || 11 == orderObj->orderType )  && orderObj->inAdvanceTakemeal ) {
            updateOrderTimeRet =  updateOrderTimeInfo(orderObj);
            QLOG_INFO()<<QString("[<<<<---updateOrderDataToDB OrderId: %1 ArriverAhead: %2 updateOrderTimeRet: %3 "
                                 " reserveMakeTime:%4  lastExpectDate:%5  expectDate:%6  remindTicketTime:%7 --->>>>]")
                         .arg(orderObj->id).arg(orderObj->inAdvanceTakemeal).arg(updateOrderTimeRet).arg(orderObj->reserveMakeTime).arg(orderObj->lastExpectDate)
                         .arg(orderObj->expectDate).arg(orderObj->remindTicketTime);
        }
    }

    return  updateOrderTimeRet;
}

bool PrintSumBillPosDB::updateOrderTimeInfo(OrderObject* orderObj) {
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    // False: 更新失败;   True: 更新成功;
    bool updateRet = false;

    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update tb_msr_customer_info set appointed_remindTemplate='%1', appointed_time ='%4', reserve5='%2', reserve10='%5' "
                          " where order_id='%3' and order_status !=6")
                  .arg(QString::number(orderObj->inAdvanceTakemeal) + ";" + orderObj->reserveMakeTime)
                  .arg(orderObj->lastExpectDate).arg(orderObj->id).arg(orderObj->expectDate).arg(orderObj->remindTicketTime) );

    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<QString("[<<<<---SqlServer Database:update OrderId %1 appointed* Time Failed--->>>>]").arg(orderObj->id);
        updateRet= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SqlServer Database:Update OrderId %1 appointed* Time success--->>>>]").arg(orderObj->id);
        updateRet = true;
    }
    m_sqlDb.close();
    return updateRet;
}


bool PrintSumBillPosDB::updateOrderSumBillStatus(OrderObject* orderObj, const int &OrderStatus){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("update tb_msr_customer_info set OrderStatus=%1 where order_id='%2'")
                  .arg(QString::number(OrderStatus)).arg(orderObj->id));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<"[<<<<---SqlServer Database:update updateOrderSumBillStatus Failed--->>>>]";
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SqlServer Database: OrderId %1 updateOrderSumBillStatus success--->>>>]").arg(orderObj->id);
        result = true;
    }
    m_sqlDb.close();
    return result;
}


bool PrintSumBillPosDB::isOrderAndCknoSumBillExist(const QString& orderId,const QString& posCheckNo){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select order_id from tb_msr_customer_info where order_id='%1' and chk_num='%2'").arg(orderId).arg(posCheckNo));
    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:isOrderAndCknoSumBillExit--->>>>]"<<orderId<<query.lastError().text();
        result= false;
    }
    if(query.first()) {
        result= true;
    } else {
        result = false;
    }
    m_sqlDb.close();
    return result;
}

bool PrintSumBillPosDB::isOrderSumBillExist(OrderObject* orderObj){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    if ( orderObj->orderStatus == OrderObject::Refunded ) {
        query.prepare(QString("select order_id from tb_msr_customer_info where order_id='%1' and order_status = 6 ").arg(orderObj->id) );
    } else {
        query.prepare(QString("select order_id from tb_msr_customer_info where order_id='%1' and order_status <> 6 ").arg(orderObj->id) );
    }

    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:isOrderSumBillExit--->>>>]order_id: "<<orderObj->id
                   << " order_status: "<<orderObj->orderStatus <<query.lastError().text();
        result= false;
    }
    if(query.first()) {
        result= true;
    } else {
        result = false;
    }
    m_sqlDb.close();
    return result;
}


bool PrintSumBillPosDB::deleteSumBillRecord(QString creatTime)
{
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---PrintSumBillPosDB::deleteSumBillRecord Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---PrintSumBillPosDB::deleteSumBillRecord Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result=true;
    QLOG_INFO()<<QString("[<<<<---PrintSumBillPosDB::begin deleteSumBillRecord create_datetime:%1--->>>>]").arg(creatTime);
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("delete from tb_msr_customer_info where create_datetime<'%1'").arg(creatTime));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<__FUNCTION__;
        result= false;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}


bool PrintSumBillPosDB::queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        error.append(QString("SqlServer Database:Open Failed").append(m_sqlDb.lastError().text()));
        return false;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select %1 from tb_msr_customer_info where order_id='%1'").arg(key).arg(orderId));
    if(!query.exec()) {
        error.append(query.lastError().text());
        m_sqlDb.close();
        return false;
    } else {
        while(query.next()) {
            value= query.value(0);
        }
    }
    m_sqlDb.close();
    return true;
}

bool PrintSumBillPosDB::queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        error.append(QString("SqlServer Database:Open Failed").append(m_sqlDb.lastError().text()));
        return false;
    }
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("select %1 from tb_msr_customer_info where order_id=%2 and %3 is null").arg(orderId,orderId,key));
    if(!query.exec()) {
        error.append(query.lastError().text());
        m_sqlDb.close();
        return false;
    } else {
        if(query.first()) {
            result= true;
        } else{
            result = false;
        }
    }
    m_sqlDb.close();
    return true;
}
