#ifndef PRINTMSGQUEUEDB_H
#define PRINTMSGQUEUEDB_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include <Model/orderObject.h>
#include "preDefine.h"
#include "windows.h"

class PrintMsgQueueDB : public QObject
{
    Q_OBJECT
public:
    // explicit PrintMsgQueueDB(QObject *parent = 0);

    static PrintMsgQueueDB& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initPrintMsgQueueDB();


    /**
    *功能:插入一条 打印订单消息 到pos本地数据库中;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool insertOrderPrtMsg(OrderObject* orderObj, const QString& posCheckNo);


    /**
    *功能: 根据订单对象指针 更新 pos本地数据库中 打印订单消息队列表中状态;
    *参数:[1]订单对象指针
    *返回:true操作成功，false失败
    **/
    bool updatePrintMsgStatus(OrderObject* orderObj, const int &printStatus);

    /**
    *功能:查询订单的打印消息记录是否存在本地的POS系统中;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderPrtMsgExist(OrderObject* orderObj);

    /**
    *功能:删除本地数据库中的 订单打印消息队列;
    *参数:[1] 删除日期;
    *返回:true 删除成功，false 删除失败;
    **/
    bool deletePrintMsgRecord(QString creatTime);

private:
    QMutex m_mutex;
    PrintMsgQueueDB();
    PrintMsgQueueDB(PrintMsgQueueDB const&);
    PrintMsgQueueDB& operator=(PrintMsgQueueDB const&);
    QSqlDatabase m_sqlDb;

signals:

public slots:
};



#endif // PRINTMSGQUEUEDB_H
