#include "printMsgQueueDB.h"
#include "QsLog.h"
#include <QDateTime>
#include "Control/flowControl.h"

PrintMsgQueueDB::PrintMsgQueueDB()
{
    QLOG_INFO()<<"[<<<<---PrintMsgQueueDB:: Structure POS Print Message Queue INFO DataBase--->>>>]";
}


bool PrintMsgQueueDB::initPrintMsgQueueDB(){
    bool bRet = false;
    m_sqlDb = QSqlDatabase::addDatabase("QODBC","PrintMsgQueueDB");   //数据库驱动类型为SQL Server
    if ( m_sqlDb.isValid() ) {
        QLOG_INFO()<<"[<<<<---SqlServer ODBC driver is valid--->>>>]";
        QString dsn="DRIVER={SQL SERVER};SERVER=127.0.0.1\\sqlexpress;DATABASE=MMXBenefits";
        m_sqlDb.setDatabaseName(dsn);                            //设置数据源名称
        m_sqlDb.setUserName("sa");                               //登录用户
        m_sqlDb.setPassword("SIM29@123");
        if(!m_sqlDb.open()) {                                      //打开数据库

            QLOG_ERROR()<<"[<<<<---SqlServer Open Database error:--->>>>]"<<m_sqlDb.lastError().text();
        } else {

            QLOG_INFO()<<"[<<<<---PrintMsgQueueDB::SqlServer Test Open database success!:--->>>>]";
            QSqlQuery query(m_sqlDb);
            QString selectsql ="select * from sys.tables where name='tb_print_msr_customer'" ;
            if(!query.exec(selectsql)) {
                QLOG_ERROR()<<"[<<<<---PrintMsgQueueDB::SqlServer Database  check tb_print_msr_customer failed--->>>>]"<<query.lastError().text();
            }
            if(query.next()) {
                QLOG_INFO() << "[<<<<---PrintMsgQueueDB::Table tb_print_msr_customer Has Exist--->>>>]";
                bRet = true;
            } else {
                QLOG_INFO() << "[<<<<---PrintMsgQueueDB::Table tb_print_msr_customer Does Not Exist--->>>>]";

                query.prepare( QString("CREATE TABLE [dbo].[tb_print_msr_customer] ("
                                    " [id] [int] IDENTITY(1,1) NOT NULL, [chk_num] [int] NOT NULL,  [print_status] [int] NULL, "
                                    "[order_id] [varchar](50) NULL,  [order_status] [int] NULL,"
                                    " [create_datetime] [datetime] NULL, [modify_datetime] [datetime] NULL,"

                                    " [reserve0] [int] NULL, [reserve1] [int] NULL,[reserve2] [int] NULL,"
                                    " [reserve3] [varchar](100) NULL, [reserve4] [varchar](200) NULL,[reserve5] [varchar](400) NULL,"
                                    " [reserve6] [int] NULL, [reserve7] [int] NULL, [reserve8] [varchar](80) NULL, [reserve9] [varchar](80) NULL"
                                    " PRIMARY KEY CLUSTERED ( [id] ASC"
                                    ")WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = "
                                    " OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]) ON [PRIMARY]") );

                if(!query.exec()){
                    QLOG_ERROR()<< "[<<<<---Create Table tb_print_msr_customer Faild--->>>>]" <<query.lastError().text()<<QString::number(query.lastError().type());
                }else {
                    bRet = true;
                }
            }

            QLOG_INFO()<<"[<<<<---SqlServer Test Open database success!:--->>>>]";
            m_sqlDb.close();
        }
    } else {
        QLOG_ERROR()<<"[<<<<---SqlServer ODBC driver no valid--->>>>]";
    }

    return bRet;
}


PrintMsgQueueDB &PrintMsgQueueDB::getInstance()
{
    static PrintMsgQueueDB PrintMsgQueueDB;
    return PrintMsgQueueDB;
}

bool PrintMsgQueueDB::insertOrderPrtMsg( OrderObject* orderObj, const QString& posCheckNo ) {
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result = false;

    //刷新 存储订单 销售退货状态的内存标识;
    orderObj->orderSaleRefundStatus = orderObj->orderStatus == 6 ? 6 : 3 ;

    QSqlQuery query(m_sqlDb);
    query.prepare("INSERT INTO tb_print_msr_customer(chk_num, print_status, "
                  " order_id, order_status, create_datetime ) "
                  "VALUES(?, ?, ?, ?, ?) select @@identity ");
    query.addBindValue(posCheckNo.toInt()); // --小票号
    query.addBindValue(0); // --打印状态: 0:未打印  1:已打印;
    query.addBindValue(orderObj->id); // --订单编号
    // query.addBindValue( orderObj->orderStatus );  // --订单状态(int);
    query.addBindValue( orderObj->orderSaleRefundStatus );  // --订单 销售退货状态 内存标识(int);
    QDateTime qdaTi = QDateTime::currentDateTimeUtc();
    QString createTime  =  qdaTi.addSecs(60*60*8).toString("yyyy-MM-dd hh:mm:ss");
    query.addBindValue(createTime); // --POS开单时间

    if(!query.exec())
    {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:tb_print_msr_customer Error--->>>>]"<<query.lastError().text()<<QString::number(query.lastError().type());
        QLOG_INFO()<<QString("INSERT INTO tb_print_msr_customer(chk_num, print_status, order_id, order_status, create_datetime ) "
                             "VALUES(%1, %2, %3, %4, %5)  select @@identity ")
                     .arg(posCheckNo.toInt()).arg(0).arg(orderObj->id).arg(orderObj->orderStatus).arg(createTime);
    } else {
       int printTabIndex = 0;
        if ( query.first() ) {
            printTabIndex = query.value(0).toInt();
            query.clear();

            if ( orderObj->orderStatus == OrderObject::Refunded ) {
                query.prepare(QString("update tb_msr_customer_info set reserve1=%1 where order_id='%2' and order_status = 6 ")
                              .arg(printTabIndex).arg( orderObj->id) );
            } else {
                query.prepare(QString("update tb_msr_customer_info set reserve1=%1 where order_id='%2' and order_status <> 6 ")
                              .arg(printTabIndex).arg( orderObj->id) );
            }

            if ( !query.exec() ) {
                QLOG_ERROR()<<QString("Update tb_msr_customer_info Failed, orderId:%1, chk_num:%2 , prtTabIndex:%3, Then Rollback tb_print_msr_customer ")
                             .arg(orderObj->id).arg( posCheckNo.toInt() ).arg( printTabIndex );
                query.clear();
                query.prepare(QString("delete from tb_print_msr_customer where id=%1 ").arg(printTabIndex) );  // 根据插表自增ID进行删除,无需使用订单状态。

                if ( !query.exec() ) {
                    QLOG_INFO()<<QString("Rollback  tb_print_msr_customer  Failed, orderId:%1, prtTabIndex:%2 ").arg(orderObj->id).arg( printTabIndex );
                }else {
                    QLOG_INFO()<<QString("Rollback  tb_print_msr_customer  Success, orderId:%1, prtTabIndex:%2 ").arg(orderObj->id).arg( printTabIndex );
                }
            } else {
                result = true;
                QLOG_INFO()<<QString("Update tb_msr_customer_info Success, orderId:%1, chk_num:%2 , prtTabIndex:%3 ")
                             .arg(orderObj->id).arg( posCheckNo.toInt() ).arg( printTabIndex );
            }

            QLOG_INFO()<<QString("[<<<<---PrintMsgQueueDB::insertOrderPrtMsg  Insert OrderId %1,orderStatus:%2, chk_num:%3  Into Success,  printTabIndex:%4--->>>>]")
                         .arg(orderObj->id).arg(orderObj->orderStatus).arg( posCheckNo.toInt() ).arg(printTabIndex);

        } else {
            QLOG_INFO()<<QString("[<<<<---PrintMsgQueueDB::insertOrderPrtMsg  Insert OrderId %1,orderStatus:%2, chk_num:%3  Into Failed,  printTabIndex:%4--->>>>]")
                         .arg(orderObj->id).arg(orderObj->orderStatus).arg( posCheckNo.toInt() ).arg(printTabIndex);
        }

    }

    m_sqlDb.close();
    return result;
}

bool PrintMsgQueueDB::updatePrintMsgStatus(OrderObject* orderObj, const int &printStatus){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;
    QSqlQuery query(m_sqlDb);
    if (orderObj->orderStatus != 6) {
        query.prepare(QString("update tb_print_msr_customer set print_status=%1 where order_id='%2' and order_status != 6 ")
                      .arg(QString::number(printStatus)).arg(orderObj->id));
    } else {
        query.prepare(QString("update tb_print_msr_customer set print_status=%1 where order_id='%2'  and order_status = 6")
                      .arg(QString::number(printStatus)).arg(orderObj->id));
    }

    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<"[<<<<---SqlServer Database:update Order Print Status Failed--->>>>]";
        result= false;
    } else {
        QLOG_INFO()<<QString("[<<<<---SqlServer Database:Update OrderId %1 Print Status success--->>>>]").arg(orderObj->id);
        result = true;
    }
    m_sqlDb.close();
    return result;
}


bool PrintMsgQueueDB::isOrderPrtMsgExist(OrderObject* orderObj){
    QMutexLocker mutex(&m_mutex);
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        return false;
    }
    bool result;

    QSqlQuery query(m_sqlDb);
    if ( orderObj->orderStatus == OrderObject::Refunded ) {
        query.prepare(QString("select order_id from tb_print_msr_customer where order_id='%1' and order_status = 6 ").arg(orderObj->id) );
    } else {
        query.prepare(QString("select order_id from tb_print_msr_customer where order_id='%1' and order_status <> 6 ").arg(orderObj->id) );
    }

    if(!query.exec()) {
        QLOG_ERROR()<<"[<<<<---SqlServer Database:isOrderPrtMsgExist--->>>>] order_id: "<<orderObj->id
                   << " order_status: "<<orderObj->orderStatus <<query.lastError().text();
        result= false;
    }
    if(query.first()) {
        result= true;
    } else {
        result = false;
    }
    return result;
}

bool PrintMsgQueueDB::deletePrintMsgRecord(QString creatTime)
{
    //QMutexLocker mutex(&m_mutex);
    bool retTryLock = m_mutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if(!retTryLock){
        QLOG_ERROR()<<"[<<<<---PrintMsgQueueDB::delete print msg queue Record Try Lock Failed--->>>>]";
        return false;
    }
    if(!m_sqlDb.open()) {
        QLOG_ERROR()<<"[<<<<---PrintMsgQueueDB::delete print msg queue Open Failed--->>>>]"<<m_sqlDb.lastError().text();
        m_mutex.unlock();
        return false;
    }
    bool result=true;
    QLOG_INFO()<<QString("[<<<<---PrintMsgQueueDB::begin delete print msg queue create_datetime:%1--->>>>]").arg(creatTime);
    QSqlQuery query(m_sqlDb);
    query.prepare(QString("delete from tb_print_msr_customer where create_datetime<'%1'").arg(creatTime));
    if(!query.exec()) {
        QLOG_ERROR()<<query.lastError().text()<<__FUNCTION__;
        result= false;
    }
    m_sqlDb.close();
    m_mutex.unlock();
    return result;
}
