#ifndef PRINTCUPSTICKPOSDB_H
#define PRINTCUPSTICKPOSDB_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include <Model/orderObject.h>
#include "alertForm.h"
#include "preDefine.h"
#include "windows.h"


class PrintCupStickPosDB : public QObject
{
     Q_OBJECT

public:
    // explicit PrintCupStickPosDB(QObject *parent = 0);

    static PrintCupStickPosDB& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initPrintCupStickPosDB();


    /**
    *功能:检查pos本地数据库表中字段;
    *参数:[无]
    *返回:true:检查字段完整性成功，false:检查字段完整性失败
    **/
    bool alterTablePrintCupStickAndCheck();

    /**
    *功能:插入订单商品列表到pos本地数据库中;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool insertOrderProduct(OrderObject* orderObj, const QString& posCheckNo, bool &checkProductValidRet);

    /**
    *功能:插入订单 券 商品列表到pos本地数据库中;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool insertCouponProd(OrderObject* orderObj, const QString& posCheckNo);

    /**
    *功能:插入订单 券子商品 商品列表到pos本地数据库中;
    *参数:[1]  [2]
    *返回:true操作成功，false失败
    **/
    bool insertCouponSubProd(OrderObject* orderObj, const int mainProdIndex, QList<SingleProductObject*> &couponSubProdList, const QString& posCheckNo);


    /**
    *功能:检查券商品(含客制化) 数据有效性;
    *参数:[1]
    *返回: true:有效, false: 无效;
    **/
    bool checkCouponProdAllVaild(OrderObject* orderObj);


    /**
    *功能:插入订单 正常 商品列表到pos本地数据库中;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool insertNormalProd(OrderObject* orderObj, const QString& posCheckNo);

    /**
    *功能:插入订单 正常 子商品列表到pos本地数据库中;
    *参数:[1]  [2]
    *返回:true操作成功，false失败
    **/
    bool insertNormalSubProd(OrderObject* orderObj, const int mainProdIndex, QList<dishesObject*> &subProdList, const QString& posCheckNo);


    /**
    *功能:检查正常商品(含客制化) 数据有效性;
    *参数:[1]
    *返回: true:有效, false: 无效;
    **/
    bool checkNormalProdAllVaild(OrderObject* orderObj);


    /**
    *功能:插入订单 配送费+打包费+打包属性到pos本地数据库中;
    *参数:[1]  [2]
    *返回:true操作成功，false失败
    **/
    bool insertDeliveryPackageAndPack(OrderObject* orderObj, const QString& posCheckNo);


    /**
    *功能:更新 订单商品列表 订单状态和小票号;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool updateOrderProductCheckNum(OrderObject* orderObj,const QString& posCheckNo);


    /**
    *功能:查询  订单的商品数据是否存在本地的POS系统中;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderProductExist(OrderObject* orderObj);

    /**
    *功能:删除本地数据库中的 订单商品数据;
    *参数:[1] 删除日期;
    *返回:true 删除成功，false 删除失败;
    **/
    bool deleteProductRecord(QString creatTime);

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);
    bool queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result);

private:
    QMutex m_mutex;
    PrintCupStickPosDB();
    PrintCupStickPosDB(PrintCupStickPosDB const&);
    PrintCupStickPosDB& operator=(PrintCupStickPosDB const&);
    QSqlDatabase m_sqlDb;

signals:

    void triggerFlowContrlAlert(AlertForm::Type alterType, const QString msg);

public slots:
};

#endif // PRINTCUPSTICKPOSDB_H
