﻿#ifndef DATAMANGER_H
#define DATAMANGER_H

#include <QJsonObject>

class DataManger
{
public:
    static DataManger& GetInstance();

    /* 功能:设置token信息
     * 参数:[1]token
     * 返回:NULL
     * */
    void SetToken(const QString& token);

    /* 功能:设置门店信息
     * 参数:[1]门店号
     * 返回:NULL
     * */
    void SetStoreId(const QString& storeId);

    /* 功能:设置子门店号
     * 参数:[1]门店号
     * 返回:NULL
     * */
    void SetSubStoreId(const QString& subStoreId);


    /* 功能:设置POS IP Address;
     * 参数:[1]posIpAddress
     * 返回:NULL
     * */
    void SetPosIpAddress(const QString& posIpAddress);

    /* 功能:设置商户号
     * 参数:[1]商户号
     * 返回:NULL
     * */    
    void SetPartnerId(const QString& partnerId);

    /* 功能:获取登录数据
     * 参数:[1]门店号[2]密码[3]收银机号[4]收银员号
     * 返回:登录数据
     * */
    QJsonObject GetLoginData(const QString& partnerId,const QString& storeId, const QString& password,
                             const QString& stationId, const QString& cashierId,const QString& ipAddress, const QString &versionComments);
    /* 功能:获取心跳数据
     * 参数:[1]门店号[2]密码[3]收银机号[4]收银员号
     * 返回:登录数据
     * */
    QJsonObject GetHeartData(const QString& password, const QString& stationId, const QString& ipAddress,
                             const QString& versionComments, const bool lastHeartIsError);
    /* 功能:获取拉取订单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetPullOrderListData(const int &pageNumber=1, const int &pageSize=1000);
    /* 功能:获取拉取配送员数据
     * 参数:[1]门店号[2]渠道代码
     * 返回:登录数据
     * */
    QJsonObject GetPullDeliverData(const QString& storeId, const QString& channelCode);
    /* 功能:获取确认订单数据
     * 参数:[1]订单编号[2]配送员编号[3]配送员姓名[4]配送员电话
     * 返回:登录数据
     * */
    QJsonObject GetConfirmOrderData(const QString& orderId, const QString& channel);
    /* 功能:获取拒绝订单数据
     * 参数:[1]拒单原因[2]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetRefuseOrderData(int refuseCode, const QString& orderId);
    /* 功能:获取送出订单数据
     * 参数:[1]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetSendOrderData(const QString& orderId);
    /* 功能:获取完成订单数据
     * 参数:[1]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetCompleteOrderData(const QString& orderId);
    /* 功能:获取同意退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefundOrderData(int reasonCode, const QString& reason, const QString& orderId, const QString &channel,const QString& dishesListString,const QString& cashierId,const QString& cashierName);
    /* 功能:获取拒绝退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefuseRefundData(const QString& reason, const QString& orderId);

    /* 功能:获取更新菜品信息数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetUpdDishesData(QMap<QString, int> dishesMap);
    /* 功能:获取拉取菜品信息数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetPullDishesData(const QString &channelCode);
    /* 功能:获取更新菜品信息数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetUpdDishesData(QString channelCode, QMap<QString, int> dishesMap);

    /* 功能:获取门店平台信息数据
     * 参数:NULL
     * 返回:数据
     * */
    QJsonObject GetStoreChannelInfoData();
    /* 功能:获取设置门店平台数据
     * 参数:NULL
     * 返回:数据
     * */
    QJsonObject GetOperatingStatusData(const QString& channel, int status);
    /* 功能:获取日结数据
     * 参数:[1]营业日
     * 返回:登录数据
     * */
    QJsonObject GetDayReportData(const QString& business);

    /* 功能:准备自测请求数据
     * 参数:
     * 返回:
     * */
    QJsonObject GetSelfCheckReqData();

private:
    DataManger(){}
    DataManger(DataManger const&);
    DataManger& operator=(DataManger const&);
    // token
    QString m_token;
    QString m_storeId;
    QString m_subStoreId;
    QString m_partnerId;
    QString m_posIpAddress;

};

#endif // DATAMANGER_H
