#ifndef CHECKPOSKEYEXISTPOSDB_H
#define CHECKPOSKEYEXISTPOSDB_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
// #include <Qtsql/QSqlRecord>
// #include <Qtsql/QSqlResult>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include <Model/orderObject.h>
#include "preDefine.h"
#include "windows.h"


class CheckPoskeyExistPosDB : public QObject
{
     Q_OBJECT

public:
    // explicit CheckPoskeyExistPosDB(QObject *parent = 0);

    static CheckPoskeyExistPosDB& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initCheckPoskeyExistPosDB();


    /**
    *功能:查询 订单的全部Poskey是否都真实存在本地的POS系统中;
    *参数:[1]订单对象
    *返回:true是，false否
    *
    select distinct M.ObjectNumber  -- ,CST.*
    from MENU_ITEM_MASTER  AS M
    INNER join MENU_ITEM_DEFINITION AS D on M.MenuItemMasterID = D.MenuItemMasterID  and D.MenuItemClassObjNum IS NOT NULL
    join MENU_ITEM_PRICE AS P on D.MenuItemDefID = P.MenuItemDefID
    left join CHANGE_SET CS on P.ChangeSetObjNum = CS.ObjectNumber
    left join CHANGE_SET_TIMETABLE CST on CS.ChangeSetID = CST.ChangeSetID
    where
    ( CST.EndTime >= convert(date,getdate()) OR CST.EndTime IS NULL ) AND
    M.ObjectNumber  IN ( 1113431,6200030,6211081,6411088 )
    *
    **/
    bool allPoskeyExistDB(OrderObject* orderObj, QStringList & notExistPoskeyList );

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);
    bool queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result);

private:
    QMutex m_mutex;
    CheckPoskeyExistPosDB();
    CheckPoskeyExistPosDB(CheckPoskeyExistPosDB const&);
    CheckPoskeyExistPosDB& operator=(CheckPoskeyExistPosDB const&);
    QSqlDatabase m_sqlDb;

signals:

public slots:
};

#endif // CHECKPOSKEYEXISTPOSDB_H
