#ifndef PRINTORDERPROMOTIONDB_H
#define PRINTORDERPROMOTIONDB_H

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QObject>
#include <QMutex>
#include <Model/orderObject.h>
#include "preDefine.h"
#include "windows.h"

class PrintOrderPromotionDB : public QObject
{
     Q_OBJECT

public:
    // explicit PrintOrderPromotionDB(QObject *parent = 0);

    static PrintOrderPromotionDB& getInstance();

    /**
    *功能:初始化pos本地数据库;方便后期判断 打开pos本地数据库是否成功;
    *参数:[无]
    *返回:true:能够成功打开POS本地数据库，false:不能够成功打开POS本地数据库
    **/
    bool initPrintOrderPromotionDB();


    /**
    *功能:检查pos本地数据库表中字段;
    *参数:[无]
    *返回:true:检查字段完整性成功，false:检查字段完整性失败
    **/
    bool alterTablePrintOrderPromotionAndCheck();

    /**
    *功能:插入 订单优惠列表 到pos本地数据库中;
    *参数:[1]订单对象指针
    *返回:true操作成功，false失败
    **/
    bool insertOrderPromotion(OrderObject* orderObj, const QString& posCheckNo);

    /**
    *功能:插入订单 券 优惠列表到pos本地数据库中;
    *参数:[1]订单对象指针
    *返回:true操作成功，false失败
    **/
    bool insertCouponPromotion(OrderObject* orderObj, const QString& posCheckNo);


    /**
    *功能:插入订单 正常商品 优惠列表到pos本地数据库中;
    *参数:[1]订单对象指针
    *返回:true操作成功，false失败
    **/
    bool insertNormalPromotion(OrderObject* orderObj, const QString& posCheckNo);


    /**
    *功能:更新 订单商品促销优惠表 订单状态和小票号;
    *参数:[1]订单对象指针  [2]小票号
    *返回:true操作成功，false失败
    **/
    bool updateOrderPromotionCheckNum(OrderObject* orderObj,const QString& posCheckNo);


    /**
    *功能:查询  订单的优惠数据是否存在本地的POS系统中;
    *参数:[1]订单号
    *返回:true是，false否
    **/
    bool isOrderPromotionExist(OrderObject* orderObj);

    /**
    *功能:删除本地数据库中的 订单优惠数据;
    *参数:[1] 删除日期;
    *返回:true 删除成功，false 删除失败;
    **/
    bool deletePromotionRecord(QString creatTime);

    bool queryValue(const QString& orderId, const QString& key, QString& error, QVariant &value);
    bool queryIsNull(const QString &orderId, const QString& key,QString &error, bool &result);

private:
    QMutex m_mutex;
    PrintOrderPromotionDB();
    PrintOrderPromotionDB(PrintOrderPromotionDB const&);
    PrintOrderPromotionDB& operator=(PrintOrderPromotionDB const&);
    QSqlDatabase m_sqlDb;

signals:

public slots:
};

#endif // PRINTORDERPROMOTIONDB_H
