﻿#include "windows.h"
#include "flowControl.h"
#include "QsLog.h"
#include "DTools/dataManger.h"
#include "preDefine.h"
#include "DTools/configManger.h"
#include "Model/cashierObject.h"
#include <QJsonValue>
#include <QTimer>
#include <QDir>
#include <QApplication>
#include <QDateTime>
#include <QThread>
#include <QtConcurrent>
#include "configManger.h"
#include <QMultiMap>
#include <QMap>
#include <QFile>
#include <DTools/simProcOrderDB.h>
#include <DTools/PrintSumBillPosDB.h>
#include <DTools/getCaboxAReAuth.h>
#include <DTools/printCupStickPosDB.h>
#include <DTools/printMsgQueueDB.h>
#include <DTools/PrintOrderPromotionDB.h>
#include <DTools/checkPoskeyExistPosDB.h>
#include <QHostInfo>
#include "SocketCommunicate.h"

FlowControl &FlowControl::GetInstance()
{
   static FlowControl fc;
   return fc;
}

FlowControl::FlowControl()
{
    m_bLoginResult =false;
    m_openTcpChannel = false;
    m_bFirstRecvInfo = true;
    m_bFloatFromLockSt = false;
    m_initSimProcOrderDBRet = false;
    m_initPrintSumBillPosDBRet = false;
    m_initGetAuthPosDBRet = false;
    m_initPrintCupStickPosDBRet = false;
    m_initPrintMsgQueueDBRet = false;
    m_initPrintOrderPromotionDBRet = false;
    m_initCheckPoskeyExistPosDBRet = false;

    //初始化门店营业状态;
    m_eleStoreStatus = UNKNOWNSTORE;
    m_mopStoreStatus = UNKNOWNSTORE;
    m_modStoreStatus = UNKNOWNSTORE;
    //初始化上次心跳状态是否异常(false:代表心跳正常 | true:代表心跳异常);
    m_bLastHeartIsError = false;

    m_loginSocket = NULL;
    m_pullOrderSocket = NULL;
    m_reportOMSRecordOrderSocket = NULL;
    m_procOrderSocket = NULL;
    m_pullDishesSocket = NULL;
    m_pullOrderListSocket = NULL;
    m_orderCount = 0;
    m_clickPosCount = 0;
    m_hurryPrintSum = 0;

    m_clearTimer=new QTimer(this);
    m_heartTimer=new QTimer(this);
    m_pullTimer=new QTimer(this);
    m_reportOMSReocrdOrderTimer = new QTimer(this);
    m_loginTimer=new QTimer(this);
    m_notifySimPullTimer = new QTimer(this);
    m_storageOrderTimer = new QTimer(this);
    m_delayGetRefundDetailTimer = new QTimer(this);
    m_remindCasherBlinkFloatTimer = new QTimer(this);

    connect(m_loginTimer,&QTimer::timeout,this,&FlowControl::_ClickToLogin);
    connect(m_notifySimPullTimer,&QTimer::timeout,this,&FlowControl::_ClickToNotifySimPullOrder);
    connect(m_storageOrderTimer,&QTimer::timeout,this,&FlowControl::_StoragePosOrderData);
    connect(m_delayGetRefundDetailTimer,&QTimer::timeout,this,&FlowControl::_ScanDelayGetRefundDetailList);
    connect(m_remindCasherBlinkFloatTimer,&QTimer::timeout,this,&FlowControl::_RemindCasherBlinkFloatForm);
    connect(m_pullTimer,&QTimer::timeout,this,&FlowControl::_PullOrderData);
    connect(m_reportOMSReocrdOrderTimer,&QTimer::timeout,this,&FlowControl::_ReportOMSRecordOrderInfo);
    connect(m_clearTimer,&QTimer::timeout,this,&FlowControl::_CrondClearExpireOrder);
    connect(m_heartTimer,&QTimer::timeout,this,&FlowControl::_SendHeart);
    connect(this,&FlowControl::doConfirmOrder,this,&FlowControl::_ConfirmOrder,Qt::BlockingQueuedConnection);
    connect(this,&FlowControl::doRefundOrder,this,&FlowControl::_RefundOrder,Qt::BlockingQueuedConnection);
    connect(this, &FlowControl::doLogin, this, &FlowControl::onGetNewStoreInfo,Qt::BlockingQueuedConnection);

    /***打开Sql server express 数据库并登陆外卖插件***/
    SimProcOrderDB::getInstance();
    m_initSimProcOrderDBRet = SimProcOrderDB::getInstance().initSimProcOrderDB();

    /***打开SqlServer POS打印汇总信息本地数据库***/
    PrintSumBillPosDB::getInstance();
    m_initPrintSumBillPosDBRet = PrintSumBillPosDB::getInstance().initPrintSumBillPosDB();

    /***打开SqlServer POS打印杯贴商品数据本地数据库***/
    PrintCupStickPosDB::getInstance();
    m_initPrintCupStickPosDBRet = PrintCupStickPosDB::getInstance().initPrintCupStickPosDB();

    /***打开SqlServer POS打印消息队列本地数据库***/
    PrintMsgQueueDB::getInstance();
    m_initPrintMsgQueueDBRet = PrintMsgQueueDB::getInstance().initPrintMsgQueueDB();

    /***打开SqlServer POS打印订单优惠明细数据本地数据库***/
    PrintOrderPromotionDB::getInstance();
    m_initPrintOrderPromotionDBRet = PrintOrderPromotionDB::getInstance().initPrintOrderPromotionDB();

    /***打开SqlServer POS获取 当前用户 是否绑定钱箱+是否拥有退货权限 本地数据库***/
    GetCaboxAReAuth::getInstance();
    m_initGetAuthPosDBRet = GetCaboxAReAuth::getInstance().initGetAuthPosDB();

    /***打开SqlServer 用订单的全部去重Poskey校验 在POS本地数据库的有效性***/
    CheckPoskeyExistPosDB::getInstance();
    m_initCheckPoskeyExistPosDBRet = CheckPoskeyExistPosDB::getInstance().initCheckPoskeyExistPosDB();


    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::FlowControl() m_initSimProcOrderDBRet: %1, m_initPrintSumBillPosDBRet: %2, m_initGetAuthPosDBRet:%3 ,"
                                        "m_initPrintCupStickPosDBRet:%4, m_initPrintMsgQueueDBRet:%5, m_initPrintOrderPromotionDBRet:%6, m_initCheckPoskeyExistPosDBRet:%7 --->>>>]")
                 .arg( m_initSimProcOrderDBRet?1:0).arg( m_initPrintSumBillPosDBRet?1:0).arg( m_initGetAuthPosDBRet?1:0)
                 .arg(m_initPrintCupStickPosDBRet?1:0).arg(m_initPrintMsgQueueDBRet?1:0).arg(m_initPrintOrderPromotionDBRet?1:0).arg(m_initCheckPoskeyExistPosDBRet?1:0);

    // FlowControl() 初始化时，接受信号的槽对象还没有实例化，所以在此时发信号没有用;
    /* emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("尝试打开POS本地数据库(MMXB**)失败"));
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("尝试打开POS本地数据库(DataS**)失败"));
    */

    /*** 启动Http服务:用来响应Simphony_Script获取订单的请求***/
    loaclHttpServer = new LoaclHttpServer();
    loaclHttpServer->run();

    /* 启动Http服务:用来响应 Http 获取订单的请求
    JQHttpServer::TcpServerManage* m_tcpServerManage = new JQHttpServer::TcpServerManage(10);
    m_tcpServerManage->setHttpAcceptedCallback( [this]( const QPointer< JQHttpServer::Session > &session )
    {
        QLOG_INFO()<< "[<<<<---FlowControl::Receive Http Request:currentThreadId:--->>>>]" << QThread::currentThreadId();
        // 回调发生在新的线程内; //解析FM外卖插件HTTP服务 与 Http 请求的会话连接是否断开: 会话连接未断开
     }
    */

   _ClickOMSAssignArea();
   m_loginTimer->start(10*1000);
}


void FlowControl::_GetIpAddress()
{
    /***已经验证：IP地址 优先取配置文件中的[IpAddress/ip]；只有没有配置的情况才会根据主机名获取ipv4的IP地址，因此为保证IP的准确性，注释通过配置文件获取ip的代码***/
    std::string tempMacAddress = "";
    int getMacRet = MacTool::GetMacByAdaptersAddresses( tempMacAddress );
    if ( !getMacRet) {
        QLOG_ERROR() << "FlowControl::_GetIpAddress  MacTool->GetMacByAdaptersAddresses Falied";
    }
    m_posMacAddress = tempMacAddress.c_str();

    QString ipAddress;
    QHostInfo info = QHostInfo::fromName(QHostInfo::localHostName());
    m_posHostName = info.hostName();

    foreach(QHostAddress address,info.addresses()) {
        if(address.protocol() == QAbstractSocket::IPv4Protocol) {
            QLOG_INFO()<<QString("[<<<<---FlowControl::_GetIpAddress getFromLocalHostName:%1--->>>>]").arg(address.toString());
            //1.1.1.1 > length > 7
            if(address.toString().length()>7 && address.toString()!= "127.0.0.1" ) {
                ipAddress=address.toString();
                QLOG_INFO()<<QString("[<<<<---FlowControl::_GetIpAddress  Request Real ipAddress: %1 hostName: %2 macAddress: %3 --->>>>]")
                             .arg(ipAddress).arg(m_posHostName).arg(m_posMacAddress);
                break;
            }
        }
    }

    m_ipAddress = ipAddress;
    m_ipPortAddress = ipAddress+QString(":")+QString::number(ConfigManger::GetInstance().GetHttpServerPort());
}


void FlowControl::_AddOrderPull(const QString &orderId, const QString &channel, const int &pageNumber, const int &pageSize)
{
    bool btryLock = m_PullOrderDataMutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if (btryLock) {
        /***组装从FM外卖service端的拉单请求参数***/
        PullOrderInfo* orderPull = new PullOrderInfo();
        orderPull->orderId=orderId;
        orderPull->channel=channel;
        orderPull->pageNumber=pageNumber;
        orderPull->pageSize=pageSize;
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_AddOrderPull orderId:%1--->>>>]").arg(orderId);
        m_orderPullList.append(orderPull);
        m_PullOrderDataMutex.unlock();
    }else {
        QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---FlowControl::_AddOrderPull orderId:%1 tryLock Faild--->>>>]").arg(orderId);
    }
}


bool FlowControl::_TryAddOrderPull(const QString &orderId, const QString &channel, const int &pageNumber, const int &pageSize)
{
    bool btryLock = m_PullOrderDataMutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if (btryLock) {
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_TryAddOrderPull orderId:%1--->>>>]").arg(orderId);
        //调用此函数:_TryAddOrderPull() 的函数:_ResponseOMS11Request()没有能百分之百锁定住:插件正触发Simphony在录销售单时，插件立刻接受到OMS推送过来的退货单;
        if(!m_simValidOrdersList.isEmpty()) {
            //缩小锁住订单的条件范围: 服务端推单给插件程序且插件程序拒绝本次订单状态发生变化的请求
            if(orderId == m_simValidOrdersList.first() && m_bFloatFromLockSt) {
                QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---FlowControl::_TryAddOrderPull orderId:%1 当前订单正在录POS系统，请耐心等待--->>>>]").arg(orderId);
                m_PullOrderDataMutex.unlock();
                return false;
            }
        }
        /***组装从FM外卖service端的拉单请求参数***/
        //遍历 如果指定订单已经在待拉取订单列表中,则不需要在继续添加到列表中;
       PullOrderInfo* tempOrderPull = NULL;
       if(!m_orderPullList.isEmpty()){
            QList<PullOrderInfo*>::iterator i;
            for (i = m_orderPullList.begin(); i != m_orderPullList.end(); ++i) {
                tempOrderPull = (*i);   //*i 使用*运算符获取遍历容器中所指的元素;
                if (orderId == tempOrderPull->orderId) {
                    //待拉取的订单详细列表已经存在,无需在添加;
                    m_PullOrderDataMutex.unlock();
                    return true;
                } else {
                    tempOrderPull = NULL;
                }
            }
        }
        PullOrderInfo* orderPull = new PullOrderInfo();
        orderPull->orderId=orderId;
        orderPull->channel=channel;
        orderPull->pageNumber=pageNumber;
        orderPull->pageSize=pageSize;

        m_orderPullList.append(orderPull);
        m_PullOrderDataMutex.unlock();
    } else {
        QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---FlowControl::_TryAddOrderPull orderId:%1 Try Lock Error--->>>>]").arg(orderId);
    }
    return btryLock;
}


void FlowControl::_ClickOMSAssignArea()
{
    m_clickPosCount++;
    if ( m_clickPosCount >=3 ) {
        if ( m_clickPosCount >= 5  ) {
            QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---m_clickPosCount >= 3  &&  >=5, m_clickPosCount:%1 , Reset Click Count And Click POS Screen--->>>>]")
                         .arg(m_clickPosCount);
            m_clickPosCount = 0;
        } else {
            QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---m_clickPosCount >= 3  &&  <5, m_clickPosCount:%1 , Skip Real Click POS Screen--->>>>]").arg(m_clickPosCount);
            return;
        }
    }

    // 由于星巴克POS存在 三种屏幕[①大屏：1366*768 ②小屏：1024*768  ③Mini Pad]
    // 因此采用获取系统屏幕底部坐标减去一个相对距离来实现正确的点击事件(2020-12-10 初步设定：x-16，y-88)；
    int xOffset = ConfigManger::GetInstance().GetOMSBtnWidthOffset();
    int yOffset = ConfigManger::GetInstance().GetOMSBtnHeightOffset();
    QLOG_INFO()<<QString::fromLocal8Bit("(yOffset%1:,yOffset:%2)").arg(xOffset).arg(yOffset);
    int nWidth = GetSystemMetrics(SM_CXSCREEN) - xOffset;
    int nHeight = GetSystemMetrics(SM_CYSCREEN) - yOffset;
    SetCursorPos(nWidth,nHeight);
    mouse_event(MOUSEEVENTF_LEFTDOWN,0,0,0,0);
    mouse_event(MOUSEEVENTF_LEFTUP,0,0,0,0);
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---触发按钮点击事件：Simphony获取订单请求->坐标(x%1:,y:%2):--->>>>]").arg(nWidth).arg(nHeight);
}

void FlowControl::_ClickToLogin()
{
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---触发按钮点击事件：_ClickToLogin: m_bLoginResult:%1 --->>>>>]").arg(m_bLoginResult);  
    if(!m_bLoginResult)
    {
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---触发按钮点击事件：FM外卖插件10s后再次尝试登陆--->>>>]");
        _ClickOMSAssignArea();
    }else{
        m_loginTimer->start(1000*60);
    }
}

void FlowControl::_SmartTriggerClickPosBtn(const bool bTimerTrigger)
{
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl:_SmartTriggerClickPosBtn: m_bFloatFromLockSt: --->>>>>]")<<m_bFloatFromLockSt<<QString::fromLocal8Bit(" bTimerTrigger:")<< bTimerTrigger;
    //判断当前插件是否锁定状态:如果是锁定状态:不做任何处理；  如果是未锁定状态:1：重置锁定标志；2：隐藏主窗体显示悬浮框；3：锁住悬浮框；4模拟点击POS机右下角button；
    if (bTimerTrigger) {
        _ClickOMSAssignArea();
    }else if (!m_bFloatFromLockSt) {
        //转移到 _ResponseSimReqFristOrderData() 实际触发录单请求时 才隐藏和锁定悬浮框;
        _ClickOMSAssignArea();
    }
}


void FlowControl::_ClickToNotifySimPullOrder()
{
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---触发按钮点击事件：_ClickToNotifySimPullOrder: m_simValidOrdersList.isEmpty()==%1--->>>>>]")
                 .arg(m_simValidOrdersList.isEmpty());
    if(!m_simValidOrdersList.isEmpty())
    {
        m_notifySimPullTimer->start(1000*7);
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FM外卖插件通知 Simphony 获取订单数据--->>>>]");
        //定时器触发的点击事件，不可避免;
        _SmartTriggerClickPosBtn(true);
    }else{
        m_notifySimPullTimer->start(1000*20);
    }
}

void FlowControl::_StoragePosOrderData() {
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_StoragePosOrderData:  m_storagePosOrdersList  size:  %1 And FirstOne: %2 --->>>>>]")
                 .arg( m_storagePosOrdersList.size() ).arg( m_storagePosOrdersList.isEmpty()? " " : m_storagePosOrdersList.first() );
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_StoragePosOrderData:  m_simValidOrdersList  size:  %1  And FirstOne: %2 --->>>>>]")
                 .arg( m_simValidOrdersList.size() ).arg( m_simValidOrdersList.empty()? " " : m_simValidOrdersList.first() );

    if ( m_storagePosOrdersList.isEmpty() ) {
        m_storageOrderTimer->start(10*1000);
    } else {
        m_storageOrderTimer->start(3*1000);

        bool bRetStorageOrderMutex = false;

        QString orderId =  m_storagePosOrdersList.first();
        OrderObject* order_p = m_FmOrdersMap.value(orderId);
        if ( !order_p ) {
            QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 OrderObject* Is Null --->>>>]").arg(orderId);
            // 订单对象空指针,无需考虑加锁,直接移除此订单号;
            m_storagePosOrdersList.removeOne(orderId);
            return;
        } else {

            // 减少订单出现多次检查与汇报OMS 订单落库状态, 提前筛选订单是否需要 检查落库情况, 提高效率;【 退货单已经提前筛查  _OrderAnalysis()  】
            bool retGetDbOrderAllFlag = SimProcOrderDB::getInstance().getDbOrderAllFlag(order_p->id,order_p->dataBaseIsOrderExistInt,order_p->dataBaseIsPushInt,
            order_p->dataBaseIsCancleInt,order_p->dataBaseIsORSPushInt,order_p->dataBaseIsORSCancleInt,order_p->dataBasePosOrderCheckNo);

            if ( order_p->orderStatus != OrderObject::Refunded  && order_p->dataBaseIsPushInt ) {
                QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Had Save 4 Core Table DB And Set Sale Flag Is True  Successed --->>>>]").arg(orderId);
                m_storagePosOrdersList.removeOne(orderId);
                return;
            }

            // 自定义生产小票号规则: OMS订单号后5位 + 销售单:03; 退货单: 06
            // 如果OMS给的标识仍然需要入机，就需要在入机后根据状态更新相关表中的真实小票号;
            QString  posCheckNo = orderId.right(5) + (OrderObject::Refunded == order_p->orderStatus ? QString("06") : QString("03") );

            bRetStorageOrderMutex =m_storageOrderMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
            int syncDbSuccessNum = 0;
            QString errorStorageOrderMsg = QString("OrderId: %1 Storage Pos Local DB Success").arg(orderId);
            bool syncOrderProductTbRet = true;
            bool syncOrderPromotionTbRet = true;
            bool syncOrderSumBillTbRet = true;
            bool syncOrderPrtMsgTbRet = true;
            bool checkProductValidRet = true;

            if(!bRetStorageOrderMutex) {
                QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 m_storageOrderMutex.tryLock Failed --->>>>]").arg(order_p->id);
                return;
            }

            //保存订单的商品数据; 无论是否需要入机,商品数据都必须提前存储本地DB,如果需要入机,入机后更新真实的入机小票号;
            /***** 更新 POS本地数据库的商品数据是否成功；begin:*********/
            if ( PrintCupStickPosDB::getInstance().isOrderProductExist(order_p) ) {
                syncDbSuccessNum++;
                // 销售单/退货单: 商品表 需存储2份数据(退货金额需要存储为负数);
                QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 Product Data Had Exist --->>>>]").arg(order_p->id);
            } else {
                if ( PrintCupStickPosDB::getInstance().insertOrderProduct(order_p, posCheckNo, checkProductValidRet) ) {
                    syncDbSuccessNum++;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Product Data Success--->>>>]").arg(order_p->id);
                } else {
                    syncOrderProductTbRet = false;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Product Data Failed --->>>>]").arg(order_p->id);
                }
            }
            /***** 更新 POS本地数据库的商品数据是否成功；end:********/

            // 检查商品数据无效订单, 需要将 ①移除待存储队列，②订单迁移到 异常单 Tab 页, ③向OMS汇报订单入库情况(在检查类中汇报).
            if ( !checkProductValidRet ) {
                QLOG_ERROR() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1   checkProductValidRet Is False  --->>>>]").arg(order_p->id);
                // ①移除待存储队列
                m_storagePosOrdersList.removeOne(order_p->id);
                m_storageOrderMutex.unlock();

                // ②订单迁移到 异常单 Tab 页
                int oldStatus = order_p->orderStatus;
                if(6 == order_p->orderStatus || OrderObject::SimExceptRefund == order_p->orderStatus){
                    order_p->orderStatus = OrderObject::SimExceptRefund;
                } else {
                    order_p->orderStatus = OrderObject::SimExceptSale;
                }

                QLOG_INFO() << QString("[<<<<---_StoragePosOrderData  Change orderId: %1 OldStatus: %2: curStatus: %3]--->>>>]").arg(order_p->id).arg(oldStatus).arg(order_p->orderStatus);
                if(oldStatus != order_p->orderStatus) {
                    emit changeOrderStatus(order_p, oldStatus);
                }

                return ;
            }

            //保存订单的优惠数据; 无论是否需要入机,优惠数据都必须提前存储本地DB,如果需要入机,入机后更新真实的入机小票号;
            /***** 更新 POS本地数据库的优惠数据 是否成功；begin:*********/
            if ( PrintOrderPromotionDB::getInstance().isOrderPromotionExist(order_p) ) {
                syncDbSuccessNum++;
                // 销售单/退货单: 促销优惠表 需存储2份数据(退货金额需要存储为负数);
                QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 Promotion Data Had Exist --->>>>]").arg(order_p->id);
            } else {
                if ( syncOrderProductTbRet ) {
                    if ( PrintOrderPromotionDB::getInstance().insertOrderPromotion(order_p, posCheckNo) ) {
                        syncDbSuccessNum++;
                        QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Promotion Data Success--->>>>]").arg(order_p->id);
                    } else {
                        syncOrderPromotionTbRet = false;
                        QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Promotion Data Failed --->>>>]").arg(order_p->id);
                    }
                } else {
                    syncOrderPromotionTbRet = false;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Product Failed, So No Need Insert Promotion --->>>>]").arg(order_p->id);
                }

            }
            /***** 更新 POS本地数据库的优惠数据 是否成功；end:********/


            /***** 更新 POS本地数据库的汇总单数据 是否成功；begin:*********/
            if ( order_p->decouplePosVersion >= 20 || m_hurryPrintSum ) {
                // 2.0解耦POS->不入机流程分支: 需要在此处排队时进行数据存储;
                if ( PrintSumBillPosDB::getInstance().isOrderSumBillExist(order_p) ) {
                    syncDbSuccessNum++;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 SumBill Data Had Exist --->>>>]").arg(order_p->id);
                    // 销售单/退货单:  汇总表 需存储2份数据(退货记录中chk_num值 与 销售记录中chk_num值 不等);
                    // 汇总表中数据需同步更新订单状态, 此操作在解析订单数据函数(  _OrderAnalysis )中已更新DB中订单的状态;
                    // 预约单->提前到店类似的变更不会走入机/存储的排队模式,所以需要在 解析订单数据函数( _OrderAnalysis )中就要更新DB中订单状态;
                    //【预约单取消: 需要打印预约取消提醒单, 必须更新订单状态】;
                } else {
                    // 0:未入机提前插入数据时默认小票号为0; 开单时间默认为空:insertOrderSumBill 函数内会以当前时间存储;
                    if ( PrintSumBillPosDB::getInstance().insertOrderSumBill(order_p, posCheckNo, "") ) {
                        syncDbSuccessNum++;
                        QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert SumBill Data Success--->>>>]").arg(order_p->id);
                    } else {
                        syncOrderSumBillTbRet = false;
                        QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert SumBill Data Failed --->>>>]").arg(order_p->id);
                    }
                }

            } else {
                // 非2.0解耦POS->入机流程分支: 等待Action05 中进行汇总表数据插入;
                syncDbSuccessNum++;
            }
            /***** 更新 POS本地数据库的汇总单数据 是否成功；end:********/


            /***** 更新 POS本地数据库的打印消息数据 是否成功；begin:*********/
            if ( order_p->decouplePosVersion >= 20 || m_hurryPrintSum ) {
                // 2.0解耦POS->不入机流程分支: 需要在此处排队时进行数据存储;
                // 需要保证前面三张表订单数据都成功插入成功后，才可以考虑插入打印数据 否则 对于打印小票会出现数据欠缺异常;
                if ( 3== syncDbSuccessNum ) {
                    if ( PrintMsgQueueDB::getInstance().isOrderPrtMsgExist(order_p) ) {
                        syncDbSuccessNum++;
                        // 销售单/退货单: 打印表需存储2份数据(退货记录中chk_num值 与 销售记录中chk_num值 不等);
                        //【订单接单后立即被取消, 也无法取消销售单的打印了】;
                        QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1 PrintMsgQueue Data Had Exist --->>>>]").arg(order_p->id);
                    } else {
                        // 0:未入机提前插入数据时默认小票号为0;
                        if ( PrintMsgQueueDB::getInstance().insertOrderPrtMsg(order_p, posCheckNo) ) {
                            syncDbSuccessNum++;
                            QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert PrintMsgQueue Data Success--->>>>]").arg(order_p->id);
                        } else {
                            syncOrderPrtMsgTbRet = false;
                            QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert PrintMsgQueue Data Failed --->>>>]").arg(order_p->id);
                        }
                    }
                } else {
                    syncOrderPrtMsgTbRet = false;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert Local Table Count < 3, So No Need Insert PrintMsgQueue Data --->>>>]").arg(order_p->id);
                }

            } else {
                // 非2.0解耦POS->入机流程分支: 等待Action05 中进行汇总表数据插入;
                syncDbSuccessNum++;
            }
            /***** 更新 POS本地数据库的打印消息数据 是否成功；end:********/

            // 订单落库成功后.判断是否需要入机; ①不入机则汇报OMS落库成功; ②入机则有效不重复添加到待入机队列中;
            QString requestType = order_p->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");

            if ( order_p->decouplePosVersion >= 20 || m_hurryPrintSum ) {
                // 2.0解耦POS->不入机流程分支: 需要在此处进行数据校验 是否都存储成功 / 并汇报存储情况;
                if ( 4 == syncDbSuccessNum ) {
                    QLOG_INFO() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert 4 Tables Data Success, Prepare Report Oms--->>>>]").arg(order_p->id);

                    // 解耦POS标识作为最后标识尺度; 避免后期 解耦和 先打印后存储模式的 同时存在;
                    if ( order_p->decouplePosVersion >= 20 ) {
                        errorStorageOrderMsg = QString("Decouple Pos: OrderId: %1 Storage Pos Local DB Success").arg(orderId);
                    } else {
                        errorStorageOrderMsg = QString("Advance Print SumBill: OrderId: %1 Storage Pos Local DB Success").arg(orderId);
                    }
                    // 落库成功, 准备将订单数据落库成功的报文消息汇报给 OMS:
                    // 销售单/退货单: 会根据订单状态 是否 = 6 进行转换后进行汇报;  进入此队列 m_storagePosOrdersList 的次数决定汇报的次数;
                    _AddOrUpdateReportOmsList(order_p->id,  order_p->channel, requestType, "3", posCheckNo, errorStorageOrderMsg, QString("") );

                    // 订单:销售+退货 数据存储成功后，需要更新 订单表 销售 退货的成功标识, 减少添加到 存储队列中的频次;
                    if ( order_p->decouplePosVersion >= 20 ) {
                        if ( OrderObject::Refunded == order_p->orderStatus ) {
                            SimProcOrderDB::getInstance().updateRefundOrderStatusAndChkNum(orderId, 1, posCheckNo);
                        } else {
                            SimProcOrderDB::getInstance().updatePushOrderStatusAndChkNum(orderId, 1, posCheckNo);
                        }
                    } else {
                         QLOG_INFO() << QString("[<<<<---_StoragePosOrderData: orderId: %1 Is HurryPrintSum, Can't Update SimProcOrderDB Pushed/Canceled Status, Because Need Record Pos--->>>>]")
                                        .arg(order_p->id);
                    }
                    // 解耦不入机订单, 落库成功后更新显示 详情界面上的虚拟小票号;
                    order_p->dataBasePosOrderCheckNo = posCheckNo;

                } else {
                    QLOG_ERROR() << QString("[<<<<---FmTakeout _StoragePosOrderData: orderId: %1  Insert 4 Tables Data Failed, Prepare Report Oms--->>>>]").arg(order_p->id);
                    // 解耦POS标识作为最后标识尺度; 避免后期 解耦和 先打印后存储模式的 同时存在;
                    // 由于在落库前就会进行 订单商品有效性进行检查: 落库失败:准备将订单数据落库失败的报文消息汇报给 OMS;
                    // <1>检查商品有效: 则是表字段过长导致插入失败,必须向OMS汇报存储情况;
                    if ( order_p->decouplePosVersion >= 20 ) {
                        errorStorageOrderMsg = QString("Decouple Pos: OrderId: %1 Storage Pos Local DB Error : %2  %3  %4  %5 ").arg(orderId)
                                .arg( syncOrderProductTbRet?"":"OrderProductTb ").arg( syncOrderPromotionTbRet?"":"OrderPromotionTb ")
                                .arg( syncOrderSumBillTbRet?"":"OrderSumBillTb ").arg( syncOrderPrtMsgTbRet?"":"OrderPrtMsgTb ");

                         _AddOrUpdateReportOmsList(order_p->id,  order_p->channel, requestType, "4", posCheckNo, errorStorageOrderMsg, QString("1009") );
                    } else {
                        errorStorageOrderMsg = QString("Advance Print SumBill: OrderId: %1 Storage Pos Local DB Error : %2  %3  %4  %5 ").arg(orderId)
                                .arg( syncOrderProductTbRet?"":"OrderProductTb ").arg( syncOrderPromotionTbRet?"":"OrderPromotionTb ")
                                .arg( syncOrderSumBillTbRet?"":"OrderSumBillTb ").arg( syncOrderPrtMsgTbRet?"":"OrderPrtMsgTb ");

                         _AddOrUpdateReportOmsList(order_p->id,  order_p->channel, requestType, "2", "", errorStorageOrderMsg, QString("") );
                    }

                }

                // 针对上方 着急打印汇总单 但 还需要入机的门店，需要将订单添加到待入机队列中,等待排队入机;
                if (order_p->decouplePosVersion < 20) {
                    // 需要入机 && 待入机队列中没有该订单 && 且检查商品数据有效;
                    if ( !m_simValidOrdersList.contains( order_p->id )  && checkProductValidRet ) {
                        m_simValidOrdersList.append(order_p->id);
                    }
                }

            } else {
                // 非2.0解耦POS->入机流程分支:
                // 需要入机 && 待入机队列中没有该订单 && 且检查商品数据有效;
                if ( !m_simValidOrdersList.contains( order_p->id )  && checkProductValidRet ) {
                    m_simValidOrdersList.append(order_p->id);
                    // 默认都是着急向POS录单; 除非特别配置 noHurryRecordPos;
                    if ( !ConfigManger::GetInstance().GetNoHurryRecordPos() ) {
                        _ClickOMSAssignArea();
                    }
                }
            }

            m_storagePosOrdersList.removeOne(order_p->id);
            m_storageOrderMutex.unlock();

            // 检查商品数据无效订单, 已经 在插库前进行审核筛查;
            // 检查订单 4 Core 数据是否正常插入成功; 插入失败需要界面 显示到 异常单 Tab 页;
            if ( syncDbSuccessNum < 4 ) {
                int oldStatus = order_p->orderStatus;
                if(6 == order_p->orderStatus || OrderObject::SimExceptRefund == order_p->orderStatus){
                    order_p->orderStatus = OrderObject::SimExceptRefund;
                } else {
                    order_p->orderStatus = OrderObject::SimExceptSale;
                }

                QLOG_INFO() << QString("[<<<<---_StoragePosOrderData  Change orderId: %1 OldStatus: %2: curStatus: %3]--->>>>]").arg(order_p->id).arg(oldStatus).arg(order_p->orderStatus);
                if(oldStatus != order_p->orderStatus) {
                    emit changeOrderStatus(order_p, oldStatus);
                }
            }
            // End Refresh Ui

        }

    }
}


void FlowControl::_ScanDelayGetRefundDetailList() {

    if ( m_delayGetRefundDetailList.isEmpty() ) {
        m_delayGetRefundDetailTimer->start(25*1000);
    } else {
        QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList:  m_delayGetRefundDetailList  size:  %1 And FirstOne: %2 --->>>>>]")
                     .arg( m_delayGetRefundDetailList.size() ).arg( m_delayGetRefundDetailList.isEmpty()? " " : m_delayGetRefundDetailList.first()->orderId );
        QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList:  m_storagePosOrdersList  size:  %1 And FirstOne: %2 --->>>>>]")
                     .arg( m_storagePosOrdersList.size() ).arg( m_storagePosOrdersList.isEmpty()? " " : m_storagePosOrdersList.first() );
        QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList:  m_simValidOrdersList  size:  %1  And FirstOne: %2 --->>>>>]")
                     .arg( m_simValidOrdersList.size() ).arg( m_simValidOrdersList.empty()? " " : m_simValidOrdersList.first() );

        m_delayGetRefundDetailTimer->start(15*1000);

        DelayPullOrderInfo*  delayPullOrder_p= nullptr;
        QList<DelayPullOrderInfo*> tmpDelayRefundList;
        QString tmpSimValidListFirstOrderId =  m_simValidOrdersList.isEmpty() ? "" : m_simValidOrdersList.first();
        QString tmpStorageListFirstOrderId =  m_storagePosOrdersList.isEmpty() ? "" : m_storagePosOrdersList.first();

        // 为了节约时间, 提高效率: 减少加锁/解锁频率, 优先快速判断筛选条件: SimValidList & StorageList & m_orderPullList 都是空;则无需加锁筛选;
        if ( !tmpSimValidListFirstOrderId.length()  && !tmpStorageListFirstOrderId.length() && m_orderPullList.empty() ) {

            while( !m_delayGetRefundDetailList.empty() ) {
                delayPullOrder_p = m_delayGetRefundDetailList.takeFirst();
                if ( !delayPullOrder_p ) {
                    QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_delayGetRefundDetailList's Fisrt Item delayPullOrder_p Is empty(3 list All Empty)--->>>>>]");
                    continue;
                }
                if ( _TryAddOrderPull(delayPullOrder_p->orderId,delayPullOrder_p->channel) ) {
                    delete delayPullOrder_p;
                    delayPullOrder_p = nullptr;
                } else {
                    QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList: _TryAddOrderPull Return Failed(3 list All Empty), orderId:%1, Continue Append Delay List--->>>>>]").arg(delayPullOrder_p->orderId);
                    tmpDelayRefundList.append(delayPullOrder_p);
                }
            }
            // 将临时延迟队列重新添加到 正式延迟队列中;
            m_delayGetRefundDetailList = tmpDelayRefundList;
            QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_delayGetRefundDetailList Scan End (3 list All Empty), Size:%1 , FirstOrderId:%2--->>>>>]")
                          .arg( m_delayGetRefundDetailList.size() ).arg( m_delayGetRefundDetailList.empty() ? "" : m_delayGetRefundDetailList.first()->orderId );

            return;
        }

        // 复杂情况遍历;
        bool tryLock  = m_delayGetRefundDetailMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
        if ( !tryLock ) {
            QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_delayGetRefundDetailMutex Try Lock Failed --->>>>>]");
        } else {

            while( !m_delayGetRefundDetailList.empty() ) {

                delayPullOrder_p = m_delayGetRefundDetailList.takeFirst();

                if ( !delayPullOrder_p ) {
                    QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_delayGetRefundDetailList's item  delayPullOrder_p Is empty--->>>>>]");
                    continue;
                }

                // Case1: 筛选处理  m_simValidOrdersList 中第一个订单，如果匹配到，则将其添加到临时延迟退单队列中;
                if ( tmpSimValidListFirstOrderId.length() && delayPullOrder_p->orderId == tmpSimValidListFirstOrderId) {
                    tmpDelayRefundList.append(delayPullOrder_p);
                    QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList:m_simValidOrdersList  FirstOrderId:%1, RefundOrderId:%2 Append Delay Get Detail List--->>>>>]")
                                  .arg( tmpSimValidListFirstOrderId ).arg( delayPullOrder_p->orderId );
                    continue;
                }

                // Case2: 筛选处理  m_storagePosOrdersList 中第一个订单，如果匹配到，则将其添加到临时延迟退单队列中;
                if ( tmpStorageListFirstOrderId.length() && delayPullOrder_p->orderId == tmpStorageListFirstOrderId) {
                    tmpDelayRefundList.append(delayPullOrder_p);
                    QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList:m_storagePosOrdersList  FirstOrderId:%1, RefundOrderId:%2 Append Delay Get Detail List--->>>>>]")
                                  .arg( tmpStorageListFirstOrderId ).arg( delayPullOrder_p->orderId );
                    continue;
                }

                // Case3: 筛选处理 遍历待获取订单详情列表, 如果匹配到待获取订单号一致，则;
                if ( !m_orderPullList.empty() ) {
                    // 待拉取列表不空时，仅判断 待拉取列表中的第一个订单是否和 延迟退单队列 中匹配，若果匹配到 则继续保留在延迟队列中;
                    PullOrderInfo* tmpOrderPull = m_orderPullList.first();
                    if ( !tmpOrderPull ) {
                        QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList:m_orderPullList First Item Is Null, Remove It From m_orderPullList--->>>>>]");
                        tmpDelayRefundList.append(delayPullOrder_p);
                        m_orderPullList.removeFirst();
                        continue;
                    }

                    if (tmpOrderPull->orderId == delayPullOrder_p->orderId) {
                        // 已经有正在获取订单详情数据的请求还未执行完成, 则需要添加到延迟队列中: 避免在 m_orderPullList 中第一个订单状态是销售单，将可能出现 Bug;
                        tmpDelayRefundList.append(delayPullOrder_p);
                        QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_orderPullList.size()=%d  , m_orderPullList.first()== RefundOrderId:%1  Append Delay Get Detail List--->>>>>]")
                                      .arg( m_orderPullList.size() ).arg( delayPullOrder_p->orderId );
                        continue;
                    }
                }

                // Case4: 筛选出来 无需延迟获取退单详情的订单 需要添加到 正常的获取订单详情的队列中;
                if ( _TryAddOrderPull(delayPullOrder_p->orderId,delayPullOrder_p->channel) ) {
                    delete delayPullOrder_p;
                    delayPullOrder_p = nullptr;
                } else {
                    QLOG_ERROR()<< QString("[<<<<---_ScanDelayGetRefundDetailList: _TryAddOrderPull Return Failed, orderId:%1, Continue Append Delay List--->>>>>]").arg(delayPullOrder_p->orderId);
                    tmpDelayRefundList.append(delayPullOrder_p);
                }

            }

            // 将延迟队列从新添加到 延迟队列中;
            m_delayGetRefundDetailList = tmpDelayRefundList;
            QLOG_INFO()<< QString("[<<<<---_ScanDelayGetRefundDetailList: m_delayGetRefundDetailList Scan End, Size:%1 , FirstOrderId:%2--->>>>>]")
                          .arg( m_delayGetRefundDetailList.size() ).arg( m_delayGetRefundDetailList.empty() ? "" : m_delayGetRefundDetailList.first()->orderId );
            m_delayGetRefundDetailMutex.unlock();
        }

    }

}

void FlowControl::_RemindCasherBlinkFloatForm()
{
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_RemindCasherBlinkFloatForm: m_simValidOrdersList.isEmpty()==%1--->>>>>]")
                 .arg(m_simValidOrdersList.isEmpty());
    if(!m_simValidOrdersList.isEmpty())
    {
        m_remindCasherBlinkFloatTimer->start(1000*8);
        emit startRemind(REMIND_SIM_ORDERLIST_NOEMPTY);
    }else{
        m_remindCasherBlinkFloatTimer->start(1000*20);
    }
}



void FlowControl::_OrderAnalysis(const QJsonObject& jsonObject)
{
    OrderObject *orderObject = NULL;
    bool  bRetStorageOrderMutex = false;
    orderObject = m_FmOrdersMap.value(jsonObject[JSON_ID].toString());
    /***<1>:FM插件维护的有效订单容器中不存在此订单：整合数据并插入到此订单容器中 ***/
    if(orderObject == NULL)
    {
        orderObject = new OrderObject(this);
        //初始化数据;
        orderObject->orderIndex = 0;
        orderObject->disPlateformFee = 0;
        orderObject->orderDiscount = 0;
        orderObject->appointmentDayFlag = 0;
        orderObject->isPackage =0;
        orderObject->packageFee = 0;
        orderObject->packDiscount = 0;
        orderObject->deliveryPrice = 0;
        orderObject->deliveryDiscount = 0;
        orderObject->tenderDeliveryDiscountB = 0;
        orderObject->forwardPosStatus =0;
        orderObject->negativePosStatus =0;
        orderObject->businessType = "0";
        orderObject->inAdvanceTakemeal = 0;
        orderObject->globalServiceType = 0;
        orderObject->globalOrderType = 0;
        orderObject->storeType = 0;
        orderObject->decouplePosVersion = 0;
        orderObject->deliveryAtProd = false;
        orderObject->extendType = 0;
        orderObject->deliveryProvider = 0;
        orderObject->deliveryType = 0;
        orderObject->isGiftitForward = 0 ;

        orderObject->FromJson(jsonObject);
        orderObject->pushOrderType=0;
        orderObject->orsPushOrderType = 0;
        orderObject->isPush = false;
        orderObject->isCancle = false;
        orderObject->isORSPush = false;
        orderObject->isORSCancle = false;
        orderObject->orderSaleRefundStatus = 0;
        //初始化订单在数据库中标志性数据:用于一次性读出；减少对数据库的加锁访问+数据库连接数;防止压测插件奔溃;
        orderObject->dataBaseIsOrderExistInt = 0;
        orderObject->dataBaseIsPushInt = 0;
        orderObject->dataBaseIsCancleInt = 0;
        orderObject->dataBaseIsORSPushInt = 0;
        orderObject->dataBaseIsORSCancleInt = 0;
        orderObject->dataBasePosOrderCheckNo = "";

        //插件程序内存中没有此订单时需要从数据库中获取该订单标志数据;同时在接受到退单情况时，也需要从数据库中重新获取(防止内存中标志数据未更新[入机后未更新]);
        bool retGetDbOrderAllFlag = SimProcOrderDB::getInstance().getDbOrderAllFlag(orderObject->id,orderObject->dataBaseIsOrderExistInt,orderObject->dataBaseIsPushInt,
        orderObject->dataBaseIsCancleInt,orderObject->dataBaseIsORSPushInt,orderObject->dataBaseIsORSCancleInt,orderObject->dataBasePosOrderCheckNo);
        if(!retGetDbOrderAllFlag ){
            QLOG_ERROR() << QString("[<<<<---FmTakeout _OrderAnalysis:First Update orderObject->id:%1 SimProcOrderDB::getInstance().getDbOrderAllFlag Failed--->>>>]").arg(orderObject->id);
            return;
        }
        QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis: First Update orderObject->id:%1 ,dataBaseIsOrderExistInt:%2 ,dataBaseIsPushInt:%3 ,dataBaseIsCancleInt:%4 ,"
                               "dataBaseIsORSPushInt:%5 ,dataBaseIsORSCancleInt:%6 ,dataBasePosOrderCheckNo:%7--->>>>]")
                       .arg(orderObject->id).arg(orderObject->dataBaseIsOrderExistInt).arg(orderObject->dataBaseIsPushInt).arg(orderObject->dataBaseIsCancleInt)
                       .arg(orderObject->dataBaseIsORSPushInt).arg(orderObject->dataBaseIsORSCancleInt).arg(orderObject->dataBasePosOrderCheckNo);

        m_FmOrdersMap.insert(orderObject->id, orderObject);
        QLOG_INFO() << QString("[<<<<---FmTakeout Valid Orders Map:Insert New Order[%1:%2]--->>>>]")
                       .arg(orderObject->id,orderObject->getOrderStatusDec());
        if(!orderObject->dataBaseIsOrderExistInt)
        {
            bool tempBResult = SimProcOrderDB::getInstance().insertSimProcOrder(orderObject->id,QDate::currentDate().toString("yyyy-MM-dd"));
            //判断插入数据库是否出现失败;
            if(!tempBResult) {
                //新增业务逻辑,针对汇报异常的订单需要;添加到 向OMS汇报入机情况的队列中;
                QString requestType = (6 == orderObject->orderStatus)?QString("6"):QString("3");
                QString msgDesc  = QString("POS Local DataBase Connect Error Or Table No Exist Error,Please Check DataBase Setting In Time");
                QString errorCode = "1009";
                if (orderObject->decouplePosVersion < 20 ) {
                    _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel, requestType, QString("2"), QString("0000"), msgDesc, QString("") );
                } else {
                    _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel, requestType, QString("4"), QString("0000"), msgDesc, errorCode );
                }
                //修改订单状态，避免后面对数据库出现不稳定的POS机仍然进行录单操作;
                if(6 == orderObject->orderStatus || OrderObject::SimExceptRefund == orderObject->orderStatus){
                    orderObject->orderStatus = OrderObject::SimExceptRefund;
                } else {
                    orderObject->orderStatus = OrderObject::SimExceptSale;
                }
            }

            if((OrderObject::NewOrder==orderObject->orderStatus||OrderObject::Confirmed==orderObject->orderStatus)) {
                emit startRemind(REMIND_CONFIRMED_ORDER);
            }
        }

        int syncOrderRet = PrintSumBillPosDB::getInstance().syncOrderDataToDB(orderObject);
        QLOG_INFO() << QString("[<<<<---PrintSumBillPosDB.getInstance().syncOrderDataToDB orderId:%1 syncOrderRet:%2--->>>>]").arg(orderObject->id).arg(syncOrderRet);

        emit changeOrderStatus(orderObject);
    }
    /***<2>:FM插件维护的有效订单容器中存在此订单:更新订单容器中此订单的订单状态***/
    else {
        int oldStatus = orderObject->orderStatus;
        int oldArriveAhead = orderObject->inAdvanceTakemeal;
        orderObject->FromJson(jsonObject);
        QLOG_INFO() << QString("[<<<<---FmTakeout Valid Order Map:Update  orderId: %1  OldStatus: %2: curStatus: %3]--->>>>]").arg(orderObject->id).arg(oldStatus).arg(orderObject->orderStatus);
        if(oldStatus != orderObject->orderStatus) {
            emit changeOrderStatus(orderObject, oldStatus);
        }

        // 3: 刷新订单 预约时间 & 制作时间 & 街送小票时间;
        if ( 3 == orderObject->inAdvanceTakemeal ) {
            int updateOrderRet = PrintSumBillPosDB::getInstance().updateOrderDataToDB(orderObject, QString("UpdateTimeAction"));
            QLOG_INFO() << QString("[<<<<---PrintSumBillPosDB.getInstance().updateOrderDataToDB orderId:%1 updateOrderRet:%2--->>>>]").arg(orderObject->id).arg(updateOrderRet);
        } else if  ( oldArriveAhead != orderObject->inAdvanceTakemeal ) {
            int updateOrderRet = PrintSumBillPosDB::getInstance().updateOrderDataToDB(orderObject, QString("UpdateTimeAction"));
            QLOG_INFO() << QString("[<<<<---PrintSumBillPosDB.getInstance().updateOrderDataToDB orderId:%1 updateOrderRet:%2--->>>>]").arg(orderObject->id).arg(updateOrderRet);

            if ( 2 == orderObject->inAdvanceTakemeal ) {
                QString  warnMsg =  QString::fromLocal8Bit("用户修改 %1 预约时间;    订单尾号:  %2;    订单号:  %3;    新预约时间:  %4;    原预约时间:  %5")
                        .arg( orderObject->channel ).arg( orderObject->id.mid(orderObject->id.length() - 5, 5) ).arg(orderObject->id)
                        .arg( orderObject->expectDate.mid(11,5) ).arg( orderObject->lastExpectDate.mid(11,5) );
                emit showAlert(AlertForm::WARNNING, warnMsg );
            }
        }

    }

    // 存储订单 销售退货状态的内存标识;
    orderObject->orderSaleRefundStatus = orderObject->orderStatus == 6 ? 6 : 3 ;
    orderObject->updateTime=QDateTime::currentDateTime().toTime_t();
    if(OrderObject::RequestRefund==orderObject->orderStatus) {
        emit startRemind(REMIND_REQREFUND_ORDER);
    }

    if(orderObject->dataBaseIsPushInt) {
        orderObject->isPush = true;
    }
    // 初始化 退单数据：防止退单标志数据被异常改动；
    if(orderObject->dataBaseIsCancleInt) {
        orderObject->isCancle = true;
    }
    // 初始化 预约实物销售入机标志: 防止预约实物入机标志数据被异常改动；
    if(orderObject->dataBaseIsORSPushInt) {
        orderObject->isORSPush = true;
    }
    // 初始化 预约实物退货入机标志: 防止预约实物入机标志数据被异常改动；
    if(orderObject->dataBaseIsORSCancleInt) {
        orderObject->isORSCancle = true;
    }

    QString posOrderCheckNo = m_orderIdToPosCheckNoMap.value(orderObject->id);

    if(posOrderCheckNo.isEmpty()) {
        posOrderCheckNo = orderObject->dataBasePosOrderCheckNo;
    }
    orderObject->posCheckNo=posOrderCheckNo;
    QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis-> orderObject->posCheckNo:%1 , orderObject->orderStatus:%2--->>>>]")
                   .arg(orderObject->posCheckNo).arg(orderObject->orderStatus) ;

    switch (orderObject->orderStatus){
    case OrderObject::NewOrder:
        // 订单状态 2 此种订单状态目前不存在, 起步订单状态是  3: 已接单;
        // 存在两种Case: 正常销售单没有入机成功 && 非预约日期(录配送费判断)/默认值是初始化0; ||  预约实物销售单没有入机成功 && 预约实物送达日期
        QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis:orderId：%1 NewOrder=2, Do Nothing --->>>>]").arg(orderObject->id);
        break;
    case OrderObject::Confirmed:
        // 针对已经确认的订单：POS可能录过，也可能没有; 因此就需要 orderObject->isPush 来判断POS是否录过：true：录过；false：没录过；
        // 业务逻辑使用下方的 Finished Case;
    case OrderObject::Sendout:
        // 业务逻辑使用下方的 Finished Case;
    case OrderObject::Finished:
        // 存在两种Case: 正常销售单没有入机成功 && 非预约日期(录配送费判断)/默认值是初始化0; ||  预约实物销售单没有入机成功 && 预约实物送达日期
        if( (orderObject->forwardPosStatus!=1 && !orderObject->isPush && !orderObject->appointmentDayFlag) || (orderObject->forwardPosStatus!=1 && !orderObject->isORSPush && orderObject->appointmentDayFlag) )
        {
            if(orderObject->appointmentDayFlag){
                orderObject->orsPushOrderType = 1;
                orderObject->pushOrderType=1; //此处必须更新此标记为 非0;否则录单数据将变化成退预约配送费(bug: 此变量之前没有初始化发现);
                orderObject->orsPushOrderTimes = 0;
            }else{
                orderObject->pushOrderType = 1;
                orderObject->pushOrderTimes = 0;
            }

            if ( !m_storagePosOrdersList.contains(orderObject->id) ) {
                bRetStorageOrderMutex =m_storageOrderMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
                if(!bRetStorageOrderMutex) {
                    QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis:orderId：%1 m_storageOrderMutex.tryLock Failed --->>>>]").arg(orderObject->id);
                    return;
                }
                // 销售单: 存在待入机队列则不添加存储队列，不存在则添加到存储队列;
                if ( !m_simValidOrdersList.contains(orderObject->id) ) {
                    m_storagePosOrdersList.append(orderObject->id);
                }
                m_storageOrderMutex.unlock();                
            }
            QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis::SaleOrder  m_storagePosOrdersList.num:%1 m_simValidOrdersList:%2 --->>>>]")
                           .arg( m_storagePosOrdersList.count() ).arg( m_simValidOrdersList.count() );
            QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis::SaleOrder  m_storagePosOrdersList: ")<< m_storagePosOrdersList
                        << QString(" m_simValidOrdersList: ")<< m_simValidOrdersList;
            // 先排队把订单数据存储POS本地数据库, 然后在排队模拟录单;
        }
        break;
    case OrderObject::RequestRefund:
        break;
    case OrderObject::AgreeRefund:
        break;
    case OrderObject::Refunded: {
        //退单目前本佳那边不区分 OrderObject::Refunded=6 && OrderObject::Cancled =6
        //case:同意退单、退单、取消订单: 此退单还没push到POS[POS没有确认退单或没有返回确认退单的小票号]
        //内存逻辑BUG：重新获取数据库中订单数据标记来判断;
        //插件程序内存中没有此订单时需要从数据库中获取该订单标志数据;同时在接受到退单情况时，也需要从数据库中重新获取(防止内存中标志数据未更新[入机后未更新]);
        bool retRefundedGetDbOrderAllFlag = SimProcOrderDB::getInstance().getDbOrderAllFlag(orderObject->id,orderObject->dataBaseIsOrderExistInt,orderObject->dataBaseIsPushInt,
        orderObject->dataBaseIsCancleInt,orderObject->dataBaseIsORSPushInt,orderObject->dataBaseIsORSCancleInt,orderObject->dataBasePosOrderCheckNo);
        if(!retRefundedGetDbOrderAllFlag ){
            QLOG_ERROR() << QString("[<<<<---FmTakeout _OrderAnalysis: Refund Order SimProcOrderDB::getInstance().getDbOrderAllFlag Failed--->>>>]");
            return;
        }
        QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis: Refund Order orderObject->id:%1 ,dataBaseIsOrderExistInt:%2 ,dataBaseIsPushInt:%3 ,dataBaseIsCancleInt:%4 ,"
                               "dataBaseIsORSPushInt:%5 ,dataBaseIsORSCancleInt:%6 ,dataBasePosOrderCheckNo:%7,negativePosStatus:%8--->>>>]")
                       .arg(orderObject->id).arg(orderObject->dataBaseIsOrderExistInt).arg(orderObject->dataBaseIsPushInt).arg(orderObject->dataBaseIsCancleInt)
                       .arg(orderObject->dataBaseIsORSPushInt).arg(orderObject->dataBaseIsORSCancleInt).arg(orderObject->dataBasePosOrderCheckNo).arg(orderObject->negativePosStatus);

        bool bIsRefundOrder = orderObject->dataBaseIsCancleInt;
        //bool bIsORSCancleOrder = orderObject->dataBaseIsORSCancleInt;
        //存在两种Case:正常退货单没有入机成功 && 非预约日期(录配送费判断)/默认值是初始化0; || 预约实物退货单没有入机 && 预约实物送达日期
        //if( (!bIsRefundOrder && !orderObject->appointmentDayFlag) || (!bIsORSCancleOrder && orderObject->appointmentDayFlag) )
        //为避免换系统盘导致订单重复入机,顾需要额外使用 OMS提供的订单是否入机状态进行过滤;
        if( (!bIsRefundOrder) && orderObject->negativePosStatus!=1 )
        {
            //case:校验此订单是否已经push到POS：订单还没push到POS[POS没有模拟点单或没有返回小票号]
            //内存中处理存在BUG:现在改用 直接读数据库中的标志；
            //存在两种Case:正常销售单没有入机成功 && 非预约日期(录配送费判断)/默认值是初始化0; || 预约实物销售单没有入机 && 预约实物送达日期
            //if( (!orderObject->dataBaseIsPushInt && !orderObject->appointmentDayFlag) || (!dataBaseIsORSPushInt && orderObject->appointmentDayFlag) )
            if(!orderObject->dataBaseIsPushInt)
            {
                orderObject->pushOrderType = 0; //标记通常订单-冲正销售单待入机状态；
                orderObject->pushOrderTimes = 0;

                bRetStorageOrderMutex = m_storageOrderMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
                if ( !bRetStorageOrderMutex ) {
                    QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis:orderId: %1 m_storageOrderMutex.tryLock Failed --->>>>]").arg(orderObject->id);
                    return;
                }
                m_storagePosOrdersList.removeOne(orderObject->id);
                m_storageOrderMutex.unlock();

                if ( m_simValidOrdersList.contains( orderObject->id ) ) {
                     // 订单取消, 且销售单在等待录单,此时剔除 不是正在录单队列中的此笔订单;
                    if ( orderObject->id != m_simValidOrdersList.first() ||
                         ( orderObject->id == m_simValidOrdersList.first() && !m_bFloatFromLockSt  )  ) {
                        m_OrderEntryMutex.lock();
                        m_simValidOrdersList.removeOne( orderObject->id );
                        m_OrderEntryMutex.unlock();
                    } else if (orderObject->id == m_simValidOrdersList.first() && m_bFloatFromLockSt)  {
                        m_storageOrderMutex.lock();
                        // 订单取消, 且销售单真在录单,此刻已经无法中断录单,只能补充一次冲正机会;
                        m_storagePosOrdersList.append(orderObject->id);
                        m_storageOrderMutex.unlock();
                    }
                }

            }
            //case:校验此订单是否已经push到POS：订单已经push到POS
            else{
                // case:校验此订单push到POS后的小票号是否空：[POS已模拟点单且返回小票号]
                // 为了兼容解耦Pos版本的过度: 不入机类型的订单也会存储订单号后5位+销售退货标识 【详情界面显示时排除销售退货标识】
                if(!orderObject->dataBasePosOrderCheckNo.isEmpty()) {
                    orderObject->isCancle =true;    // 和orderObject->pushOrderType 来联合标记传出数据；
                    orderObject->isORSCancle =true; // 和orderObject->orsPushOrderType 来联合标记传出数据；
                    orderObject->pushOrderType = 0; //标记通常订单-准备退单动作；
                    orderObject->pushOrderTimes = 0;
                    orderObject->orsPushOrderType = 0; //标记预约实物-准备退单动作；
                    orderObject->orsPushOrderTimes = 0;

                    if ( !m_storagePosOrdersList.contains(orderObject->id) ) {
                        bRetStorageOrderMutex = m_storageOrderMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
                        if ( !bRetStorageOrderMutex ) {
                            QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis:orderId：%1 m_storageOrderMutex.tryLock Failed --->>>>]").arg(orderObject->id);
                            return;
                        }
                        // 退货单: 存在待入机队列则不添加存储队列，不存在则添加到存储队列;
                        if ( !m_simValidOrdersList.contains( orderObject->id ) ) {
                            m_storagePosOrdersList.append(orderObject->id);
                        }
                        m_storageOrderMutex.unlock();
                    }

                    QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis::RefundOrder  m_storagePosOrdersList.num:%1 m_simValidOrdersList:%2 --->>>>]")
                                   .arg( m_storagePosOrdersList.count() ).arg( m_simValidOrdersList.count() );
                    QLOG_INFO() << QString("[<<<<---FmTakeout _OrderAnalysis::RefundOrder  m_storagePosOrdersList: ")<< m_storagePosOrdersList
                                << QString(" m_simValidOrdersList: ")<< m_simValidOrdersList;
                    // 先排队把订单数据存储POS本地数据库, 然后在排队模拟录单;
                } /***case:校验此订单push到POS后的小票号是否空：[POS已模拟点单但未返回小票号]***/
                //else{未处理}
            }
        }

        }
        break;

    default:
        break;
    }
}

void FlowControl::onGetNewStoreInfo()
{
    QLOG_INFO()<<"[<<<<---Get New Store Info:Openssl support--->>>>]:"<<QSslSocket::supportsSsl();
    m_loginSocket = new BillSocket(this);
    m_pullOrderSocket = new BillSocket(this);
    m_reportOMSRecordOrderSocket = new BillSocket(this);
    m_procOrderSocket = new BillSocket(this);
    m_pullDishesSocket = new BillSocket(this);
    m_pullOrderListSocket = new BillSocket(this);
    _GetStoreInfo();
    _Login();
    m_bFirstRecvInfo =false;
    return ;
}

//鸡肋：没有用到此函数的实际功能【仅仅用来获取门店登陆用的密码:m_password】；
bool FlowControl::_GetStoreInfo()
{
    bool result=true;
    emit showAlert(AlertForm::LOADING, QString::fromLocal8Bit("正在获取门店信息......"));
    QLOG_INFO() << QString("[<<<<---Get StoreInfo--->>>>]");
    QString tmp;
    ConfigManger::GetInstance().GetStoreInfo(tmp/*, m_posId, m_cashierId*/, m_password);
    return result;
}


void FlowControl::_GetFcMajorInfo(bool &loginResult, bool &openTcpChannel, QString &storeId, QString &posIp, QString &posHostName, QString &posWorkStationNum){
    loginResult = m_bLoginResult;
    openTcpChannel = m_openTcpChannel;
    storeId = m_storeId;
    posIp = m_ipAddress;
    posHostName = m_posHostName;
    posWorkStationNum = m_posWorkstationNum;
}


QString FlowControl::_GetCashierId()
{
    return m_cashierId;
}


QString FlowControl::_GetCashierName()
{
    return m_cashierName;
}


bool FlowControl::_SimValidOrdersListIsEmpty(){
    return m_simValidOrdersList.empty();
}


bool FlowControl::_Login()
{
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;

    //获取POS机的 [IP地址] + [IP+PORT地址] -> 更新到成员变量:m_ipAddress, m_ipPortAddress;
    //必须在登录请求的时候才能去实时获取POS的IP地址;否则可能会出现 127.0.0.1的情况出现;
    _GetIpAddress();

    m_subStoreId =  ConfigManger::GetInstance().GetSubStoreId();
    // 跳过 校验配置 子门店 与 母门店的前三位是否一致；增加安全保护机制 (同时实现参数可控 校验功能 );
    if ( ConfigManger::GetInstance().GetSubStoreSkipVerify() ) {
        m_storeId = m_subStoreId.length()?m_subStoreId:m_storeId;
    } else {
        m_storeId  = (m_subStoreId.length() && m_subStoreId.left(3) == m_storeId.left(3) )?m_subStoreId:m_storeId;
    }

     m_puginVersionComments = ConfigManger::GetInstance().GetOrderServerUrl();

    sendJson = DataManger::GetInstance().GetLoginData(ConfigManger::GetInstance().GetPartnerId(),m_storeId,
                                                      m_password, m_posId, m_cashierId, m_ipPortAddress, m_puginVersionComments);
    // 登录新增Pos相关属性字段;
    sendJson.insert(JSON_POS_IP_ADDR, m_ipAddress);
    sendJson.insert(JSON_POS_WORKS_NUM, m_posWorkstationNum);
    sendJson.insert(JSON_POS_HOST_NAME, m_posHostName);
    sendJson.insert(JSON_POS_MAC_ADDRESS, m_posMacAddress);

    emit showAlert(AlertForm::LOADING, QString::fromLocal8Bit("正在登录......"));
    QLOG_INFO() << QString("[<<<<---Login--->>>>][requestData:%1]")<<sendJson;
    if(ConfigManger::GetInstance().GetLoginSslConfig())
    {
        m_loginSocket->SetSslConfig();
        QLOG_INFO() << QString("[<<<<---_Login Set ssl Config--->>>>]");
    }

    QLOG_INFO()<<ConfigManger::GetInstance().GetLoginServerUrl()+
              ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_ILOGIN);
    m_loginSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetLoginServerUrl()+
                               ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_ILOGIN)));
    QLOG_INFO() << QString("[<<<<---_Login Qurl: --->>>>]")<<m_loginSocket->GetUrl();
    result = m_loginSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Login Finshed--->>>>][result:%1][msg:%2][recvData:").arg(result).arg(error)<<recvJson;
    if(!result) {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("登录失败![网络错误]"));
    } else {
        if(JSON_STATUSCODE_OK != recvJson[JSON_LOGINCODE].toInt()) {
            result = false;
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("登录失败![%1]").arg(recvJson[JSON_MESSAGE].toString()));
        } else {
            m_storeName = recvJson[JSON_STORENAME].toString();
            m_openTcpChannel = recvJson[JSON_OPEN_TCP_CHANNEL].toBool();
            DataManger::GetInstance().SetToken(recvJson[JSON_DATA].toObject()[JSON_TOKEN].toString());
            DataManger::GetInstance().SetStoreId(m_storeId);
            DataManger::GetInstance().SetPosIpAddress(m_ipPortAddress);
            DataManger::GetInstance().SetPartnerId(ConfigManger::GetInstance().GetPartnerId());
            m_hurryPrintSum = ConfigManger::GetInstance().GetHurryPrintSum();
            emit hideAlert();
            emit setStoreInfo(m_storeId);
            emit setCashierInfo(m_cashierName);

            //***********************登陆时获取门店的营业状态 begin ************************//
            m_eleStoreStatus = recvJson[JSON_ELESTORESTS].toInt();
            m_modStoreStatus = recvJson[JSON_MODSTORESTS].toInt();
            m_mopStoreStatus = recvJson[JSON_MOPSTORESTS].toInt();
            QLOG_INFO()<<QString("[<<<<---FlowControl::_Login eleStoreStatus:%1; modStoreStatus:%2; mopStoreStatus:%3; --->>>>]")
                         .arg(m_eleStoreStatus).arg(m_modStoreStatus).arg(m_mopStoreStatus);
            emit doUpdateStoreStatus(m_eleStoreStatus,m_modStoreStatus,m_mopStoreStatus);

            //***********************登陆时获取门店的营业状态 end ************************//
            m_bLoginResult= true;
            m_clearTimer->start(1000*60*60*3); // 测试时5分钟执行1次清理任务:生产环境3小时清理一次；
            m_heartTimer->start(1000*60*5);
            m_pullTimer->start(1000*5);
            m_reportOMSReocrdOrderTimer->start(1000*10);
            m_clickPosCount = 0;
            m_notifySimPullTimer->start(7*1000);
            m_storageOrderTimer->start(10*1000);
            m_delayGetRefundDetailTimer->start(15*1000);
            m_remindCasherBlinkFloatTimer->start(5*1000);
            //_AddOrderPull(QString(),QString());
            //在登陆时再次检查数据库连接是否都正常；
            if( !m_initSimProcOrderDBRet || !m_initPrintSumBillPosDBRet || !m_initGetAuthPosDBRet || !m_initPrintCupStickPosDBRet
                    || !m_initPrintMsgQueueDBRet || !m_initPrintOrderPromotionDBRet || !m_initCheckPoskeyExistPosDBRet )
            {
                result = false;
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_Login() m_initSimProcOrderDBRet: %1, m_initPrintSumBillPosDBRet: %2, m_initGetAuthPosDBRet:%3 ,"
                                                    "m_initPrintCupStickPosDBRet:%4, m_initPrintMsgQueueDBRet:%5, m_initPrintOrderPromotionDBRet:%6, m_initCheckPoskeyExistPosDBRet:%7 --->>>>]")
                             .arg( m_initSimProcOrderDBRet?1:0).arg( m_initPrintSumBillPosDBRet?1:0).arg( m_initGetAuthPosDBRet?1:0)
                             .arg(m_initPrintCupStickPosDBRet?1:0).arg(m_initPrintMsgQueueDBRet?1:0).arg(m_initPrintOrderPromotionDBRet?1:0)
                             .arg(m_initCheckPoskeyExistPosDBRet?1:0);

                emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("尝试打开POS本地数据库(MMXB** 或 DataS**)失败"));
            } else {
                _AddOrderPull(QString(),QString());
            }
        }
    }

    if(!result) {
        QLOG_INFO() << QString("[<<<<---Login Retry--->>>>] %1 msec after login...").arg(VALUE_RELOGINTIME);
        QTimer::singleShot(VALUE_RELOGINTIME, this, &FlowControl::_Login);
    }

    QLOG_INFO() << QString("[<<<<---Login--->>>>][m_bLoginResult: %1, result: %2 ]").arg(m_bLoginResult?1:0).arg(result?1:0);

    // Http登录OMS成功后, 判断是否开启Socket Communicate Pipe. //优先取配置文件中的长连接开关: 配置为 false时以OMS返回开启标志为准;
    if ( ConfigManger::GetInstance().GetOpenTcpChannel() ){
        m_openTcpChannel = true;
    }

    if ( m_bLoginResult && m_openTcpChannel ) {
        QLOG_INFO() << QString("[<<<<---Login Success, Emit Signal To SocketCommunicate Begin Connect Tcp Socket --->>>>]");
        emit doLoginSuccess(true, m_openTcpChannel, m_storeId, m_ipAddress, m_posHostName, m_posWorkstationNum);
    }

    return result;
}


void FlowControl::_PullOrderData()
{
    QLOG_INFO()<<"[<<<<----FlowControl::_PullOrderData ---->>>>>]";
    if(m_orderPullList.isEmpty())
        return ;
    emit hideAlert();

    bool btryLock = m_PullOrderDataMutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if (!btryLock) {
        QLOG_ERROR()<<"[<<<<----FlowControl::_PullOrderData Try Lock Failed ---->>>>>]";
        return;
    }
    PullOrderInfo* info = m_orderPullList.takeFirst();

    if(info->orderId.isEmpty()) {
        if ( _PullOrderList(info->pageSize,info->pageNumber) ) {
            QLOG_INFO()<<"[<<<<----FlowControl::_PullOrderData  _PullOrderList successful---->>>>>]";
            m_orderPullList.removeOne(info);
            delete info;
        } else {
            QLOG_INFO()<<"[<<<<----FlowControl::_PullOrderData _PullOrderList failed---->>>>>]";
            m_orderPullList.removeOne(info);
            m_orderPullList.append(info);
        }
    } else {
        if (_PullOrderDetail(info->orderId,info->channel) ) {
             QLOG_INFO()<<"[<<<<----FlowControl::_PullOrderData  _PullOrderDetail successful---->>>>>]";
             m_orderPullList.removeOne(info);
             delete info;
        } else {
             QLOG_INFO()<<"[<<<<----FlowControl::_PullOrderData  _PullOrderDetail fail---->>>>>]";
             m_orderPullList.removeOne(info);
             m_orderPullList.append(info);
        }
    }

    m_PullOrderDataMutex.unlock();
    return ;
}

bool FlowControl::_PullOrderDetail(const QString& orderId, const QString& channel)
{
    if(m_pullOrderSocket==NULL)
        m_pullOrderSocket =new BillSocket(this);
    QString error;
    bool result;
    QJsonObject recvJson;

    if(ConfigManger::GetInstance().GetOrderSslConfig()) {
        m_pullOrderSocket->SetSslConfig();
        QLOG_INFO()<<"FlowControl::_PullOrderDetail  load ssl";
    } else {
        QLOG_INFO()<<"FlowControl::_PullOrderDetail load not ssl";
    }
    QString url = ConfigManger::GetInstance().GetOrderServerUrl()+
            ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_PULLORDER);

    // 拉取订单详情接口:订单编号
    url.append(orderId);
    // 拉取订单详情接口: 新增 渠道 参数
    url.append(QString("&")+JSON_CHANNEL+QString("=")+channel);
    url.append(QString("&")+JSON_POSIPADDRESS+QString("=")+m_ipPortAddress);
    url.append(QString("&")+JSON_STORE_ID+QString("=")+m_storeId);
    QLOG_INFO() << QString("[<<<<---Pull Order Detail--->>>>][requestUrl:]")<<url;
    QUrl  tmpUrl = QUrl(url);
    m_pullOrderSocket->SetUrl( tmpUrl );
    result = m_pullOrderSocket->GetRequest(recvJson, error);
    QLOG_INFO() << QString("[<<<<---Pull Order Detail Finsh--->>>>][result:%1][msg:%2]")
                   .arg(result).arg(error)<<recvJson;
    if(!result) {
        emit setNetStatus(QString::fromLocal8Bit("<font color='#ff0000'>网络不稳定,正在重试</font>"));
    } else {
        qDebug()<<recvJson;
        emit setNetStatus(QString::fromLocal8Bit("正常"));
        if(JSON_STATUSCODE_OK != recvJson[JSON_ERRCODE].toInt())
        {
            QString error = recvJson[JSON_ERRMSG].toString();
            QLOG_ERROR() << QString("[<<<<---Pull Order Detail Error--->>>>][msg->%1]").arg(error);
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("获取订单失败![%1]").arg(error));
            result=false;
        } else {
            QJsonObject order = recvJson[JSON_DATA].toObject();
            _OrderAnalysis(order);
        }
    }
    /*解析json数据失败则20秒后重新拉单*/
    if(!result) {
        m_pullTimer->start(1000*20);
        // 如果某次拉订单列表出现失败；此函数的外层函数 _PullOrderData：会将本次拉单对象存起来，等待下次拉取;
    } else {
        m_pullTimer->start(1000*6);
    }
    qDebug()<<"[<<<<---Pull Order Detail Result--->>>>]"<<result;
    return result;
}

bool FlowControl::_PullOrderList(const int &pageSize, const int &pageNo)
{
    if(m_pullOrderListSocket==NULL) {
        m_pullOrderListSocket =new BillSocket(this);
    }
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    int ordertotalSum;
    sendJson = DataManger::GetInstance().GetPullOrderListData(pageNo,pageSize);

    QLOG_INFO() << QString("[<<<<---FlowControl::_PullOrderList: Pull Order List--->>>>][requestData:]")<<sendJson;
    if(ConfigManger::GetInstance().GetOrderSslConfig()) {
        m_pullOrderListSocket->SetSslConfig();
        QLOG_INFO()<<"FlowControl::_PullOrderList load ssl";
    } else {
        QLOG_INFO()<<"FlowControl::_PullOrderList load not ssl";
    }
    m_pullOrderListSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetOrderServerUrl()+
                                   ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_PULLORDERLIST)));
    QLOG_INFO()<<ConfigManger::GetInstance().GetOrderServerUrl()+
                 ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_PULLORDERLIST)<< " requestData: " <<sendJson;
    result = m_pullOrderListSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---FlowControl::_PullOrderList:Pull Order List Finish.--->>>>][result:%1][msg:%2]")
                   .arg(result).arg(error)<<recvJson;
    if(!result) {
        emit setNetStatus(QString::fromLocal8Bit("<font color='#ff0000'>网络不稳定，正在重试</font>"));
    } else {
        qDebug()<<recvJson;
        emit setNetStatus(QString::fromLocal8Bit("正常"));
        if(JSON_STATUSCODE_OK != recvJson[JSON_ERRCODE].toInt()) {
            QString error = recvJson[JSON_ERRMSG].toString();
            QLOG_ERROR() << QString("[<<<<---FlowControl::_PullOrderList:Pull Order List Error--->>>>][msg->%1]").arg(error);
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("获取订单失败![%1]").arg(error));
            result=false;
           m_orderCount = 0;
        } else {
            QJsonArray orders = recvJson[JSON_DATA].toObject()[JSON_ORDERS].toArray();
            foreach(QJsonValue order, orders) {
                _OrderAnalysis(order.toObject());
            }
            ordertotalSum=recvJson[JSON_DATA].toObject()[JSON_COUNT].toInt();
            m_orderCount += orders.size();

            if ( m_orderCount < ordertotalSum ) {
                //避免出现存在多页数据，导致出现死锁: 先调用定时器的timeout 触发槽函数:_PullOrderData,
                //_PullOrderData:内部会有加锁并且会调用分页获取订单函数_AddOrderPull(QString(),QString(),pageNo+1,pageSize): 内部也有加锁，所以导致死锁;
                //_AddOrderPull(QString(),QString(),pageNo+1,pageSize);
                /***组装从FM外卖service端的拉单请求参数***/
                PullOrderInfo* orderPull = new PullOrderInfo();
                orderPull->orderId=QString();
                orderPull->channel=QString();
                orderPull->pageNumber=pageNo+1;
                orderPull->pageSize=pageSize;
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_PullOrderList: Next Page Order List :pageNo:%1 pageSize:%2--->>>>]").arg(pageNo+1).arg(pageSize);
                m_orderPullList.append(orderPull);
                //避免出现存在多页数据，导致出现死锁;
            } else {
                //分页拉取订单列表最后一页成功后,需要重置本地拉单计数缓存, 防止影响下一次获取订单列表判断;
                m_orderCount = 0;
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_PullOrderList  Had Finished: The Last Request PageNo:%1--->>>>]").arg(pageNo);
            }

        }
    }
    // 如果出现拉取订单列表失败，触发下一次拉门店有效订单的时间间隔变更为20(如果一开始就获取订单列表成功:时间间隔为5s)
    if(!result) {
        m_pullTimer->start(1000*20);
        // 如果某次拉订单列表出现失败；此函数的外层函数 _PullOrderData: 还会将本次拉单列表存起来等待下次拉取;
    }
    QLOG_INFO()<<"[<<<<---Pull Order List Result--->>>>]"<< result;
    return result;
}

bool FlowControl::_SendHeart()
{
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    m_puginVersionComments = ConfigManger::GetInstance().GetOrderServerUrl();

    sendJson = DataManger::GetInstance().GetHeartData(m_password,m_posId,m_ipPortAddress,m_puginVersionComments,m_bLastHeartIsError);
    sendJson.insert(JSON_POS_IP_ADDR, m_ipAddress);
    sendJson.insert(JSON_POS_WORKS_NUM, m_posWorkstationNum);
    sendJson.insert(JSON_POS_HOST_NAME, m_posHostName);
    sendJson.insert(JSON_POS_MAC_ADDRESS, m_posMacAddress);

    QLOG_INFO() << QString("[<<<<---Send Heart--->>>>][requestData:%1]")<<sendJson;
    m_loginSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetLoginServerUrl()+
                               ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_HEART)));
    result = m_loginSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Send Heart Finish--->>>>][result:%1][msg:%2][recvData:%3]")
                   .arg(result).arg(error)<<recvJson;
    if(!result)
    {
        m_bLastHeartIsError = true;
        emit setNetStatus(QString::fromLocal8Bit("<font color='#ff0000'>网络不稳定，正在重试</font>"));
        emit doUpdateStoreStatus(0,0,0);  //NetWork Is Error , Refresh Store Default Status;
    }else
    {
       QLOG_INFO() << QString("[<<<<---Send Heart Finish: code:%1--->>>>]").arg(recvJson[JSON_LOGINCODE].toInt());
       if(JSON_STATUSCODE_OK != recvJson[JSON_LOGINCODE].toInt())
       {
            result = false;
            m_bLastHeartIsError = true;
            emit setNetStatus(QString::fromLocal8Bit("<font color='#ff0000'>网络不稳定，正在重试</font>"));
            emit doUpdateStoreStatus(0,0,0);  //Interface Return Error , Refresh Store Default Status;
       }else{
           result = true;
           emit setNetStatus(QString::fromLocal8Bit("<font color='#f5f5f5'>正常</font>"));
           //只有上一次心跳是异常：才根据心跳来展示门店营业状态 [数据延迟比较严重:同时也需要通过OMS推门店状态给插件]
           //OMS服务端 门店开关店不主动推送,主要依赖心跳请求更新数据;
           if ( recvJson.contains(JSON_ELESTORESTS) ) {
               m_eleStoreStatus = recvJson[JSON_ELESTORESTS].toInt();
           }
           if ( recvJson.contains(JSON_MODSTORESTS) ) {
               m_modStoreStatus = recvJson[JSON_MODSTORESTS].toInt();
           }
           if ( recvJson.contains(JSON_MOPSTORESTS) ) {
               m_mopStoreStatus = recvJson[JSON_MOPSTORESTS].toInt();
           }
           QLOG_INFO()<<QString("[<<<<---FlowControl::_SendHeart eleStoreStatus:%1;modStoreStatus:%2;mopStoreStatus:%3 --->>>>]").
                        arg(m_eleStoreStatus).arg(m_modStoreStatus).arg(m_mopStoreStatus);
           emit doUpdateStoreStatus(m_eleStoreStatus,m_modStoreStatus,m_mopStoreStatus);
           //还原并标记上一次心跳为正常状态;
           m_bLastHeartIsError = false;
       }
    }
    return result;
}

bool FlowControl::_ConfirmOrder(const QString &orderId)
{
    Q_UNUSED(orderId);
    bool result = false;
    return result;
}

bool FlowControl::_RefuseOrder(const QString &orderId, int refuseCode,const QString reason)
{
    Q_UNUSED(orderId);
    Q_UNUSED(refuseCode);
    Q_UNUSED(reason);
    bool result = false;
    return result;
}

bool FlowControl::_SendOrder(const QString& orderId)
{
    Q_UNUSED(orderId);
    bool result = false;
    return result;
}

bool FlowControl::_CompleteOrder(const QString& orderId)
{
    Q_UNUSED(orderId);
    bool result = false;
    return result;
}

bool FlowControl::_RefuseRefund(const QString& orderId)
{
    Q_UNUSED(orderId);
    bool result = false;
    return result;
}

bool FlowControl::_RefundOrder(const QString &orderId,int reasonCode,const QString& reason,const QString& dishesListString)
{

    QLOG_INFO() << QString("[<<<<---FlowControl::_RefundOrder--->>>>][orderId:%1 reasonCode:%2 reason:%3 dishesListString:]").arg(orderId).arg(reasonCode).arg(reason).arg(dishesListString);
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    sendJson = DataManger::GetInstance().GetRefundOrderData(reasonCode,reason,orderId,m_FmOrdersMap.value(orderId)->channel, dishesListString, m_cashierId, m_cashierName);
    emit showAlert(AlertForm::LOADING, QString::fromLocal8Bit("正在通信......"));
    QLOG_INFO() << QString("[<<<<---Refund Order Begin--->>>>][requestData:%1]")<<sendJson;
    // 如果退款原因：商品已售完，使用下面接口; // 如果退款原因：其他，都同意使用一个接口；
    m_procOrderSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetOrderServerUrl() + ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_CANCLE)));
    QLOG_INFO() << QString("[<<<<<-----_RefundOrder: orderId:%1  URL: ----->>>>>]").arg(orderId)<< m_procOrderSocket->GetUrl();

    if(ConfigManger::GetInstance().GetOrderSslConfig()) {
        m_procOrderSocket->SetSslConfig();
        QLOG_INFO()<<"load ssl";
    } else {
        QLOG_INFO()<<"load not ssl";
    }
    QLOG_INFO() << QString("[<<<<---Refund Order Request: --->>>>]")<< m_procOrderSocket->GetUrl();
    result = m_procOrderSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Refund Order Finish--->>>>][result:%1][msg:%2][recvData:]")
                   .arg(result).arg(error)<<recvJson;
    if(!result)
    {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("退单失败![网络错误]"));
        return false;
    } else {
        if(JSON_STATUSCODE_OK != recvJson[JSON_ERRCODE].toInt())
        {
            result = false;
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("退单失败![%1]").arg(recvJson[JSON_MESSAGE].toString()));
            return false;
        } else {
            QJsonObject data = recvJson[JSON_DATA].toObject();
            int status = data[JSON_RECEIVINGSTATUS].toInt();
            if(1==status) {
                emit showAlert(AlertForm::SUCCESS, QString::fromLocal8Bit("退单成功"));
                //m_OrderEntryMutex.lock(); //必须提前加锁，否则后期订单ID会变更;
                //获取POS退单成功,OMS服务端返回的RefundFmId ( 此字段只有星巴克APP SVC卡支付的case,才会使用到 )
                QString refundFmIdTemp = data[JSON_REFUNDFMID].toString();
                int orderStatus = data[JSON_ORDERSTATUS].toInt();
                int tempGlobalOrderType = data[JSON_GLOBALORDERTYPE].toInt();
                int tempGlobalServiceType = data[JSON_GLOBALSERVICETYPE].toInt();

                OrderObject* orderObject = m_FmOrdersMap.value(orderId);
                int oldOrderStatus = orderObject->orderStatus;
                orderObject->orderStatus = orderStatus;
                orderObject->refundFmId = refundFmIdTemp;

                orderObject->globalOrderType = tempGlobalOrderType;
                orderObject->globalServiceType = tempGlobalServiceType;

                emit changeOrderStatus(orderObject, oldOrderStatus);
                emit doHideMainShowFloatFrom();
                //退货订单，将此订单添加到simphony 模拟点单列表中；
                QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder: orderObject->id:%1 , orderObject->orderStatus:%2 --->>>>]").arg(orderObject->id).arg(orderObject->orderStatus);
                QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder: orderObject->id:%1 , orderObject->isCancle:%2 --->>>>]").arg(orderObject->id).arg(orderObject->isCancle);
                if (OrderObject::Refunded == orderObject->orderStatus && OrderObject::SimExceptSale != oldOrderStatus && OrderObject::SimExceptRefund != oldOrderStatus) {
                    //只有退单成功 且 是录POS 成功的才进行加锁；
                    //emit doLockFloatForm(); m_bFloatFromLockSt = true; //更新悬浮框的锁定状态 转移到响应action1：数据准备函数中;
                    //能退单成功就肯定能断言，此订单是没有录过退货的
                    // 判断Simphony 队列中的订单是否已经存在:不存在(Simphony已经点单完成后会移除)则添加；
                    // 如果存在(说明此订单还拟点单)，则需要直接向现存在Sim有效队列中的记录移除;没有模
                    m_OrderEntryMutex.lock();
                    if ( !m_simValidOrdersList.contains(orderObject->id) && ( orderObject->decouplePosVersion < 20 ) )   //不存在队列中，且需要录单，则将其加入到队列中；
                    {
                        QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder: orderId:%1; SimProcOrderDB::getInstance().isRefundOrder: %2--->>>>]").arg(orderObject->id)
                                    .arg( SimProcOrderDB::getInstance().isRefundOrder(orderObject->id)? 1: 0 );
                        // 由于m_hurryPrintSum Flag的加入;入机前先存储订单数据,为打印提供数据准备: 否则插件上退单，将不会存储 商品表+促销优惠表+汇总表+打印表的退单数据;
                        m_storagePosOrdersList.append(orderObject->id);
                        //原本应该根据 appointmentDayFlag 使用分支,但此时是退单接口,不允许使用退单:
                        orderObject->pushOrderType = 0;
                        orderObject->pushOrderTimes = 0;
                        orderObject->orsPushOrderType = 0;
                        orderObject->orsPushOrderTimes = 0;
                    }else{  //如果已经存在队列中，就是POS还没有录入销售订单成功；
                        m_simValidOrdersList.removeOne(orderObject->id);
                        // 及时更新 不入机类型的退单数据 并 及时打印退单提醒;
                        m_storagePosOrdersList.append(orderObject->id);
                    }
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:  m_simValidOrdersList.num:%1 --->>>>]")<< m_simValidOrdersList.count();
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:  m_simValidOrdersList:%1 --->>>>]")<< m_simValidOrdersList;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:  _ClickOMSAssignArea --->>>>]");
                    m_OrderEntryMutex.unlock();
                    m_clickPosCount = 0;
                    _ClickOMSAssignArea(); //必须执行，否则退货，点击取消后，就不会再提醒了；
                //录正向销售单报错的处理机制;
                } else if(OrderObject::SimExceptSale == oldOrderStatus) {
                    m_OrderEntryMutex.lock();
                    m_simValidOrdersList.removeOne(orderObject->id);
                    m_OrderEntryMutex.unlock();
                //正向单已经录入成功,录退单报错的的处理机制;
                } else if(OrderObject::SimExceptRefund == oldOrderStatus){
                    m_OrderEntryMutex.lock();
                    if ( !m_simValidOrdersList.contains(orderObject->id) && ( orderObject->decouplePosVersion < 20 )  )   //不存在队列中，且需要录单，则将其加入到队列中；
                    {
                        QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder: SimExceptRefund : orderId:%1 ;(SimProcOrderDB::getInstance().isRefundOrder:--->>>>]")
                                       .arg(orderObject->id)<<SimProcOrderDB::getInstance().isRefundOrder(orderObject->id);
                        // 由于m_hurryPrintSum Flag的加入;入机前先存储订单数据,为打印提供数据准备: 否则插件上退单，将不会存储 商品表+促销优惠表+汇总表+打印表的退单数据;
                        m_storagePosOrdersList.append(orderObject->id);
                        //原本应该根据 appointmentDayFlag 使用分支,但此时是退单接口,不允许使用退单:
                        orderObject->pushOrderType = 0;
                        orderObject->pushOrderTimes = 0;
                        orderObject->orsPushOrderType = 0;
                        orderObject->orsPushOrderTimes = 0;
                    }
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:SimExceptRefund :  m_simValidOrdersList.num:%1 --->>>>]")<< m_simValidOrdersList.count();
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:SimExceptRefund :  m_simValidOrdersList:%1 --->>>>]")<< m_simValidOrdersList;
                    QLOG_INFO() << QString("[<<<<---FmTakeout _RefundOrder:SimExceptRefund :  _ClickOMSAssignArea --->>>>]");
                    m_OrderEntryMutex.unlock();
                    m_clickPosCount = 0;
                    _ClickOMSAssignArea(); //必须执行，否则退货，点击取消后，就不会再提醒了；
                }
                //m_OrderEntryMutex.unlock(); //必须放开锁的范围；否则会出错；
            } else {
                emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("退单失败![%1]").arg(recvJson[JSON_ERRMSG].toString()));
                return false;
            }
        }
    }
    return result;
}


void FlowControl::_ReportOMSRecordOrderInfo()
{
    QLOG_INFO()<<"[<<<<----FlowControl::_ReportOMSRecordOrderInfo ---->>>>>]";
    if ( m_orderRecordRepOMSList.isEmpty() )
        return ;

    bool btryLock = m_RepOMSRecordOrderMutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
    if ( !btryLock ) {     //加锁失败后，直接return;
        QLOG_INFO()<<"[<<<<----FlowControl::_ReportOMSRecordOrderInfo tryLock Failed ---->>>>>]";
        return ;
    }

    RepOMSRecordOrderInfo* RepOMSRecOrderIn = NULL;
    bool  findFlag = false;
    QList<RepOMSRecordOrderInfo*>::iterator i;
    for (i = m_orderRecordRepOMSList.begin(); i != m_orderRecordRepOMSList.end(); ++i) {
        if (*i) {
            RepOMSRecOrderIn = (*i);   //*i 使用*运算符获取遍历容器中所指的元素;
            if ( 1== RepOMSRecOrderIn->status.toInt() || ( 2 == RepOMSRecOrderIn->status.toInt() && 0 == RepOMSRecOrderIn->reqResult)
                 || 3 == RepOMSRecOrderIn->status.toInt() || ( 4 == RepOMSRecOrderIn->status.toInt() && 0 == RepOMSRecOrderIn->reqResult)  ) {
                findFlag = true;
                break;
            } else {
                findFlag = false;
            }
        } else {
            QLOG_INFO()<<QString("[<<<<----FlowControl::_ReportOMSRecordOrderInfo   *i Is Null, ListCount:%1 ---->>>>>]").arg( m_orderRecordRepOMSList.count() );
        }

    }

    QLOG_INFO()<<QString("[<<<<----FlowControl::_ReportOMSRecordOrderInfo  m_orderRecordRepOMSList size:%1, findFlag:%2 ---->>>>>]")
                 .arg( m_orderRecordRepOMSList.size() ).arg(findFlag?1:0);
    if ( !findFlag  ||  !RepOMSRecOrderIn ) {
        //上面的汇报OMS订单入机状态的汇报列表 遍历循环后：如果出现  RepOMSRecOrderIn == NULL;不能从List容器的头部移除已汇报成功结果
        //【注意，必须是订单已经成功入机的订单，而非是入机失败，汇报OMS成功的订单】;
        m_RepOMSRecordOrderMutex.unlock();
        return ;
    }
    //准备https请求,准备向OMS汇报订单的入机情况;
    if(m_reportOMSRecordOrderSocket==NULL)
        m_reportOMSRecordOrderSocket =new BillSocket(this);
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    m_reportOMSRecordOrderSocket->SetSslConfig();
    //组装POST请求数据;
    sendJson.insert("orderNo", RepOMSRecOrderIn->orderNo);
    sendJson.insert("channel", RepOMSRecOrderIn->channel);
    sendJson.insert("type", RepOMSRecOrderIn->type);
    sendJson.insert("status", RepOMSRecOrderIn->status);
    sendJson.insert("opUser", RepOMSRecOrderIn->opUser);
    sendJson.insert("recordDate",  RepOMSRecOrderIn->recordDate);
    sendJson.insert("storeId",  RepOMSRecOrderIn->storeId);
    sendJson.insert("remark",  RepOMSRecOrderIn->remark);
    sendJson.insert("checkNo",  RepOMSRecOrderIn->checkNo);
    sendJson.insert("failCode",  RepOMSRecOrderIn->failCode);
    sendJson.insert(JSON_IP_ADDRESS, m_ipAddress);
    sendJson.insert(JSON_POS_WORKS_NUM, m_posWorkstationNum);
    sendJson.insert(JSON_POS_HOST_NAME, m_posHostName);
    sendJson.insert(JSON_POS_MAC_ADDRESS, m_posMacAddress);
    sendJson.insert(JSON_POS_PLUGIN_VERSION,  RepOMSRecOrderIn->posPluginVersion);

    QLOG_INFO() << QString("[<<<<---_ReportOMSRecordOrderInfo:Begin--->>>>][requestData:%1]")<<sendJson;
    m_reportOMSRecordOrderSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetLoginServerUrl()+
                               ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_REPORTOMSRECORDORDER)));
    QLOG_INFO()<<QString("[<<<<---Report OMS Record Order Entry POS Info--->>>>][requestUrl:]") << ConfigManger::GetInstance().GetLoginServerUrl() +
                 ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_REPORTOMSRECORDORDER);
    result = m_reportOMSRecordOrderSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Report OMS Record Order Entry POS Info Finish--->>>>][result:%1][msg:%2][orderId:%3]")
                   .arg(result).arg(error).arg( RepOMSRecOrderIn->orderNo )<<recvJson;
    if(!result) {
        emit setNetStatus(QString::fromLocal8Bit("<font color='#ff0000'>网络不稳定,正在重试</font>"));
    } else {
        emit setNetStatus(QString::fromLocal8Bit("正常"));
        if(JSON_STATUSCODE_OK != recvJson[JSON_ERRCODE].toInt()) {
            QString error = recvJson[JSON_ERRMSG].toString();
            QLOG_ERROR()<< QString("[<<<<---Report OMS Record Order Entry POS Info Error--->>>>][msg->%1]").arg(error);
            result=false;
            m_orderRecordRepOMSList.removeOne( RepOMSRecOrderIn );
            m_orderRecordRepOMSList.append( RepOMSRecOrderIn );
        } else {
            //解析 汇报订单入机POS状态成功 || 汇报存储POS数据库状态成功;
            result=true;
            if ( 1 == RepOMSRecOrderIn->status.toInt() || 3 == RepOMSRecOrderIn->status.toInt() ) {
                //只有订单成功入机的订单，才能将此订单从 List容器中移除;否则必须保留在此容器中 避免重复多次向OMS汇报;
                QLOG_INFO()<< QString("[<<<<---Report OMS Record Order Entry POS / Storage Pos DB successful, Remove orderId:%1--->>>>][msg->%2]")
                              .arg(  RepOMSRecOrderIn->orderNo ).arg(  RepOMSRecOrderIn->remark );
                m_orderRecordRepOMSList.removeOne( RepOMSRecOrderIn );
                delete  RepOMSRecOrderIn;
                RepOMSRecOrderIn = NULL;
            } else {
                //订单入机失败的订单，不能从 List容器中移除;否则 同笔订单的入机异常情况，会出现多次 或一直向oms回报的情况;
                RepOMSRecOrderIn->reqResult=1;
                QLOG_INFO()<< QString("[<<<<---Report OMS Record Order Entry POS Info successful,Reserve orderId:%1--->>>>][msg->%2]")
                              .arg(  RepOMSRecOrderIn->orderNo ).arg( RepOMSRecOrderIn->remark );
            }
        }
    }
    m_RepOMSRecordOrderMutex.unlock();
}


void FlowControl::_AddOrUpdateReportOmsList(const QString &orderId,  const QString &channel,  const QString &repType, const QString &status, const QString &chkNum,
                                            const QString &error, const QString &errorCode) {

    bool repReportLockRet = m_RepOMSRecordOrderMutex.tryLock(2*1000);
    if (repReportLockRet) {

        RepOMSRecordOrderInfo* repOMSRecordOrder = NULL;

        if (!m_orderRecordRepOMSList.isEmpty()) {
            QList<RepOMSRecordOrderInfo*>::iterator i;
            for (i = m_orderRecordRepOMSList.begin(); i != m_orderRecordRepOMSList.end(); ++i) {
                repOMSRecordOrder = (*i);   //*i 使用*运算符获取遍历容器中所指的元素;
                if (orderId == repOMSRecordOrder->orderNo) {
                    break;
                } else {
                    repOMSRecordOrder = NULL;
                }
            }
        }

        if (!repOMSRecordOrder){
            repOMSRecordOrder = new RepOMSRecordOrderInfo();
            repOMSRecordOrder->reqResult = 0;
        } else {
            if ( error == repOMSRecordOrder->remark && repType == repOMSRecordOrder->type && 1== repOMSRecordOrder->reqResult ) {
                m_orderRecordRepOMSList.removeOne(repOMSRecordOrder);
                //repOMSRecordOrder->reqResult=1; //此时reqResult已经是1了;
            } else {
                m_orderRecordRepOMSList.removeOne(repOMSRecordOrder);
                repOMSRecordOrder->reqResult=0;
            }
        }

        repOMSRecordOrder->orderNo = orderId;
        repOMSRecordOrder->channel = channel;
        repOMSRecordOrder->type = repType;
        repOMSRecordOrder->status = status;
        repOMSRecordOrder->opUser = m_cashierName;
        repOMSRecordOrder->recordDate = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");;
        repOMSRecordOrder->storeId = m_storeId;
        repOMSRecordOrder->remark = error;
        repOMSRecordOrder->failCode = errorCode;
        repOMSRecordOrder->checkNo =  chkNum;
        repOMSRecordOrder->posPluginVersion =  APP_VERSION;
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_AddOrUpdateReportOmsList:m_orderRecordRepOMSList.append() orderId:%1 error:%2--->>>>]").arg(orderId).arg(error);
        m_orderRecordRepOMSList.append(repOMSRecordOrder);
        m_RepOMSRecordOrderMutex.unlock();
        // 后期可能对汇报入机存储情况要求更加严格, 就需要对内存待汇报记录进行 持久化记录: 只持久化成功的记录;
    } else {
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_AddOrUpdateReportOmsList: tryLock failed  orderId:%1 error:%2 --->>>>]").arg(orderId).arg(error);
    }

}



QString FlowControl::_GetJsonStr(const QJsonObject &json)
{
    return QString(QJsonDocument(json).toJson(QJsonDocument::Compact)).replace("\"","");
}

QJsonObject FlowControl::_PackHttpReplyJson(const int status, const QString &msg, const QJsonObject &data,const int& iscontinue, const QString &orderId)
{
    QJsonObject rObj;
    rObj.insert("statusCode", status);
    rObj.insert("msg", msg);
    rObj.insert("iscontinue",iscontinue);
    rObj.insert("data", data);
    rObj.insert("orderId", orderId);
    return rObj;
}

void FlowControl::onPullDishes()
{
}

void FlowControl::onUpdDishes(QString channelCode, QMap<QString, int> dishes)
{
    Q_UNUSED(channelCode);
    Q_UNUSED(dishes);
}

void FlowControl::onUpdDishesForRef(QString channelCode, QMap<QString, int> dishes)
{
}

void FlowControl::onSetStoreOperatingStatus(const QString &channelCode, const QString &channelName, int business_status)
{
    //TODO
    Q_UNUSED(channelName);
    return ;
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;

    sendJson = DataManger::GetInstance().GetOperatingStatusData(channelCode, business_status);
    emit showAlert(AlertForm::LOADING, QString::fromLocal8Bit("正在设置门店营业状态......"));
    QLOG_INFO() << QString("[<<<<---SetStoreOperatingStatus:Begin--->>>>][requestData:%1]")<<sendJson;
    m_pullDishesSocket->SetUrl(QUrl(ConfigManger::GetInstance().GetStoreServerUrl()+
                               ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_UPDATESTATE)));
    qDebug()<<QUrl(ConfigManger::GetInstance().GetStoreServerUrl()+
                   ConfigManger::GetInstance().GetInterfaceName(INI_INTERFACE_UPDATESTATE));
    result = m_pullDishesSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---SetStoreOperatingStatus:Finish--->>>>][result:%1][msg:%2][recvData:%3]")
                   .arg(result).arg(error)<<recvJson;
    if(!result)
    {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("设置门店营业状态失败![网络错误]"));
    }else
    {
        if(JSON_STATUSCODE_OK != recvJson[JSON_STATUSCODE].toInt())
        {
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("设置门店营业状态失败![%1]").arg(recvJson[JSON_MESSAGE].toString()));
        }else
        {
            emit hideAlert();
            emit setStoreOperatingStatusFinsh(channelCode);
        }
    }
}


void FlowControl::onSendSelfCheck()
{
    if(!m_bLoginResult)
    {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("门店未登录"));
        return;
    }
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    sendJson = DataManger::GetInstance().GetSelfCheckReqData();

    if(ConfigManger::GetInstance().GetOrderSslConfig())
    {
        m_procOrderSocket->SetSslConfig();
        QLOG_INFO()<<"load ssl";
    } else {
        QLOG_INFO()<<"load not ssl";
    }
    QString url = ConfigManger::GetInstance().GetOrderServerUrl()+ "pos/create/checkOrder";
    QLOG_INFO() << QString("[<<<<---FlowControl::onSendSelfCheck Begin--->>>>][ requestUrl:%1 ,  requestData:] ").arg(url) << sendJson;
    m_procOrderSocket->SetUrl(QUrl(url));
    result = m_procOrderSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Get onSendSelfCheck:Finish--->>>>][result:%1][msg:%2]  [recvData:] ")
                   .arg(result).arg(error)<<recvJson;
    if(!result) {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("发送自测请求失败![网络错误]"));
    } else {
        if(JSON_STATUSCODE_OK != recvJson[JSON_ERRCODE].toInt()) {
            result = false;
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("发送自测请求失败![%1]").arg(recvJson[JSON_MESSAGE].toString()));
        } else {
            emit showAlert(AlertForm::SUCCESS, QString::fromLocal8Bit("发送自测请求成功"));
           // Test Modify Time
           //emit showAlert(AlertForm::WARNNING, QString::fromLocal8Bit("用户修改 MOP 预约时间;订单尾号:  12345;"
           //                                                             "    订单号:  9876543210012345678;    新预约时间:  18:00;    原预约时间:  17:30"));
        }
    }
}



void FlowControl::onDailyReport()
{
    if(!m_bLoginResult)
    {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("门店未登录"));
        return;
    }
    QString error;
    bool result;
    QJsonObject sendJson;
    QJsonObject recvJson;
    QString m_business=QDateTime::currentDateTime().toString("yyyyMMdd");

    sendJson = DataManger::GetInstance().GetDayReportData(m_business);

    emit showAlert(AlertForm::LOADING, QString::fromLocal8Bit("正在通信......"));

    QLOG_INFO() << QString("[<<<<---Get DailyReport:Begin--->>>>][requestData:%1]")<<sendJson;
    result = m_procOrderSocket->PostRequest(sendJson, recvJson, error);
    QLOG_INFO() << QString("[<<<<---Get DailyReport:Finish--->>>>][result:%1][msg:%2][recvData:%3]")
                   .arg(result).arg(error)<<recvJson;
    if(!result)
    {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("获取入账日结失败![网络错误]"));
    }else
    {
        if(JSON_STATUSCODE_OK != recvJson[JSON_STATUSCODE].toInt())
        {
            result = false;
            emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("获取入账日结失败![%1]").arg(recvJson[JSON_MESSAGE].toString()));
        }else
        {
            recvJson.insert(JSON_STORENAME,m_storeName);
            recvJson.insert(JSON_POSNO,m_posId);
            recvJson.insert(JSON_STOREID,m_storeId);
            recvJson.insert(JSON_USERID,m_cashierId);
            recvJson.insert(JSON_USERNAME,m_cashierName);
            recvJson.insert(JSON_BUSINESSDATE,m_business);
            emit hideAlert();
            emit showDailyReportData(recvJson);
        }
    }
}

void FlowControl::onTriggerFlowContrlAlert(AlertForm::Type alterType, const QString& msg) {
    QLOG_INFO() << QString("[<<<<-FlowControl::onTriggerFlowContrlAlert alterType:%1 ,alterMsg:%2 -->>>>]")
                   .arg(alterType).arg(msg);

    emit FlowControl::GetInstance().showAlert(alterType, msg);
}


void FlowControl::_CrondClearExpireOrder()
{
    //QDateTime currentDateTime= QDateTime::currentDateTime();  //--按秒数来验证ok--
    QDate currentDate= QDate::currentDate();
    //QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_CrondClearExpireOrder: 清理内存中订单数据的清理日期：%1 --->>>>]").arg(currentDateTime.toString("yyyy-MM-dd hh:mm:ss")); //--按秒数来验证OK--
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_CrondClearExpireOrder: 清理内存中订单数据的清理日期：%1 --->>>>]").arg(currentDate.toString("yyyy-MM-dd"));
    OrderObject *order=NULL;
    foreach (order, m_FmOrdersMap.values()) {

        QDate createDate = QDate::fromString( (order->createTime).mid(0,10),"yyyy-MM-dd");
        // 如果是预约单 则需以预约日期为准，实现过期订单清理条件;
        if ( 7 == order->orderType || 11 == order->orderType ) {
            createDate = QDate::fromString( (order->expectDate).mid(0,10),"yyyy-MM-dd");
        }

        //QLOG_INFO()<<QString("[<<<<---_CrondClearExpireOrder-> order->createTime Or expectDate : %1--->>>>]").arg(order->createTime); //--按秒数来验证ok--
        QLOG_INFO()<<QString("[<<<<---_CrondClearExpireOrder-> order  createDate Or expectDate: %1--->>>>]").arg(createDate.toString("yyyy-MM-dd"));
        //qint64 seconds = createDateTime.secsTo(currentDateTime);  //--按秒数来验证ok--
        qint64 days = createDate.daysTo(currentDate);
        //QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_CrondClearExpireOrder: ClearExpireOrder: 相差多少秒:%1--->>>>]").arg(seconds); //--按秒数来验证ok--
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_CrondClearExpireOrder: ClearExpireOrder: 相差多少天:%1--->>>>]").arg(days);
        //创建订单时间，超过当前时间 三十分就进行清理；
        //if(seconds>=60*5)  //--按秒数来验证ok--
        if(days>=1)
        {
            QLOG_INFO()<<QString("[<<<<---_CrondClearExpireOrder: ClearExpireOrder: Emit Signal:Clear Order  orderID:%1--->>>>]").arg(order->id);
            emit clearorder(order->id,order->orderStatus);
            m_FmOrdersMap.value(order->id)->deleteLater();
            m_FmOrdersMap.remove(order->id);
            // 任何情况情况下都不能清理 Simphony获取的有效队列【除非已经被simphony处理过的数据】;目前已经在POS 触发的Action1:_ResponseSimReqFristOrderData 中做数据清理了
        }
    }

    SimProcOrderDB::getInstance().deleteOrderRecord(QDate::currentDate().addDays(-45).toString("yyyyMMdd"));
    PrintSumBillPosDB::getInstance().deleteSumBillRecord( QDate::currentDate().addDays(-7).toString("yyyy-MM-dd") );
    PrintCupStickPosDB::getInstance().deleteProductRecord(QDate::currentDate().addDays(-7).toString("yyyy-MM-dd"));
    PrintOrderPromotionDB::getInstance().deletePromotionRecord(QDate::currentDate().addDays(-7).toString("yyyy-MM-dd"));
    PrintMsgQueueDB::getInstance().deletePrintMsgRecord(QDate::currentDate().addDays(-3).toString("yyyy-MM-dd"));
}

bool FlowControl::_ResponseHttpRequest(const QJsonObject &content,QJsonObject &data, QString& error)
{
    QLOG_INFO()<<__FUNCTION__;
    bool result = true;
    /****校验Http请求参数有效性: 校验参数->actionId不存在****/
    if(!content.contains("actionId")) {
        error =QString::fromLocal8Bit("解析Http请求参数:参数中没有actionId");
        result = false;
    }/****校验Http请求参数有效性: 校验参数->actionId存在****/
    else {
        int actionId;
        if(content["actionId"].isString()){
            actionId=content["actionId"].toString().toInt();
        } else {
            actionId=content["actionId"].toInt();
        }
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Http请求[action:%1] --->>>>]").arg(actionId);
        /****校验请求参数actionId的具体数值:****/
        switch (actionId) {
        case 1://simphony拉取订单
            result=_ResponseSimphony01Request(content,data,error);
            break;
        case 2://simphony确认接单
            result=_ResponseSimphony02Request(content,data,error);
            break;
        case 3://simphony取消接单
            result=_ResponseSimphony03Request(content,data,error);
            break;
        case 4://simphony汇报小票号信息回复
            result=_ResponseSimphony04Request(content,data,error);
            break;
        case 5://simphony更新订单数据到POS本地数据库以便POS打印小票及汇总单信息 回复
            result=_ResponseSimphony05Request(content,data,error);
            break;
        case 6://simphony汇报SIM录单异常 回复
            result=_ResponseSimphony06Request(content,data,error);
            break;
        case 11://FM OMS推送订单
            result=_ResponseOMS11Request(content,data,error);
            break;
        case 12://推送门店营业状态
            result=_ResponseOMS12Request(content,data,error);
            break;
        case 21://盒马生鲜 推送订单
            result=_ResponseHM21Request(content,data,error);
            break;
        default:
            error =QString::fromLocal8Bit("解析Http请求actionId值不在规定的接口文档内");
            result = false;
            break;
        }
    }
    return result;
}

bool FlowControl::_ResponseSimphony01Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    bool result=true;
    if(!m_bLoginResult&&content.contains("storeId")) {
        result=_ResponseSimReqTryLogin(content,error);
    }

    if(result/*&&content.contains("orderId")*/){
        result=_ResponseSimReqFristOrderData(content, data,error,content["orderId"].toString());
    } else {
        result = false;
        if(error.isEmpty()) {
            error=QString::fromLocal8Bit("Response Simphony_Script Request 01: Login Store Failed");
        }
    }
    return result;
}

bool FlowControl::_ResponseSimphony02Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    Q_UNUSED(content);
    Q_UNUSED(data);
    Q_UNUSED(error);
    return true;
}
bool FlowControl::_ResponseSimphony03Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    Q_UNUSED(content);
    Q_UNUSED(data);
    Q_UNUSED(error);
    return true;
}
bool FlowControl::_ResponseSimphony04Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    bool result=true;
    m_clickPosCount = 0;
    if(m_bLoginResult&&content.contains("orderId")){
        QString orderId=content["orderId"].toString();
        QString posCheckNo=content["posSaleId"].toString();

        if(posCheckNo.isEmpty()) {
            posCheckNo=m_orderIdToPosCheckNoMap.value(orderId);
        }
        if(!posCheckNo.isEmpty()&&!orderId.isEmpty()) {
            if(!m_orderIdToPosCheckNoMap.contains(orderId)) {
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:04:汇报小票号] 订单:%1 , 汇报小票号:%2:--->>>>]").arg(orderId,posCheckNo);
                m_orderIdToPosCheckNoMap.insert(orderId,posCheckNo);
            }

            OrderObject* order_p =  m_FmOrdersMap.value(orderId);
            if (!order_p) {
                QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---%1订单并不存在m_FmOrdersMap[键值对]中;m_FmOrdersMap.size()=%2--->>>>]").arg(orderId).arg(m_FmOrdersMap.size());
                error=QString::fromLocal8Bit("Request Action04: %1 Delivery Order Don't Exist In m_FmOrdersMap[key-map] m_FmOrdersMap.size()=%2").arg(orderId).arg(m_FmOrdersMap.size());
                emit doUnLockFloatFrom();//****************解锁悬浮框**************//
                if(m_bFloatFromLockSt){
                    m_bFloatFromLockSt = false; //更新悬浮框的锁定状态 =false;
                }
                return false;
            }

            if(m_simValidOrdersList.contains(orderId)) {
                /***** 汇报POS小票号是否成功；begin:*********/
                bool bRetReportCheckNo = false;
                bool checkProductValidRet = false; // 无效订单就不会进行入机,故无需担心此类情况;

                if(order_p->pushOrderType==1) {
                    SimProcOrderDB::getInstance().updatePushOrderStatus(orderId,1);
                    order_p->isPush= true;
                    order_p->forwardPosStatus = 1;
                } else if(0 == order_p->pushOrderType) {
                    SimProcOrderDB::getInstance().updateRefundOrderStatus(orderId,1);
                    order_p->isCancle = true;
                    order_p->negativePosStatus = 1;
                }
                //处理预约实物入机后数据库更新;
                if(order_p->orsPushOrderType==1 && order_p->appointmentDayFlag) {
                    SimProcOrderDB::getInstance().updateORSPushOrderStatus(orderId,1);
                    order_p->isORSPush= true;
                    order_p->forwardPosStatus = 1;
                } else if(0 == order_p->orsPushOrderType && order_p->appointmentDayFlag) {
                    SimProcOrderDB::getInstance().updateORSCancleOrderStatus(orderId,1);
                    //避免重复退预约配送费订单
                    SimProcOrderDB::getInstance().updateRefundOrderStatus(orderId,1);
                    order_p->isCancle = true;
                    order_p->isORSCancle = true;
                    order_p->negativePosStatus = 1;
                }

                //***** 更新 POS本地数据库的销售/退货 标识表中的真实小票号: 用于界面显示(不入机订单需要变更显示逻辑)  *********/
                bRetReportCheckNo = SimProcOrderDB::getInstance().updatePosOrderCheckNo(orderId,posCheckNo);

                /***** 更新 POS本地数据库的商品表 真实小票号: 解耦后,仍然有能正确打印订单数据的关联关系  begin:*********/
                bool retSyncOrderProduct = true;  //默认是同步POS商品数据成功; 目前只有 businessType: 20:WSG-杯贴祝福;  30: 拼团;
                if ( PrintCupStickPosDB::getInstance().isOrderProductExist(order_p) ) {
                    if (m_hurryPrintSum)  {
                        QLOG_INFO()<<QString("[<<<<---_ResponseSimphony04Request::orderId:%1 Is HurryPrintSum, No Need Update PrintCupStickPosDB CheckNo, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                    } else {
                        if (!PrintCupStickPosDB::getInstance().updateOrderProductCheckNum(order_p, posCheckNo) )
                            retSyncOrderProduct = false;
                    }
                } else {
                    if (m_hurryPrintSum)  {
                        QLOG_INFO()<<QString("[<<<<---_ResponseSimphony04Request::orderId:%1 Is HurryPrintSum, No Need Insert PrintCupStickPosDB, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                    } else {  
                        if (!PrintCupStickPosDB::getInstance().insertOrderProduct(order_p, posCheckNo, checkProductValidRet) )
                            retSyncOrderProduct = false;
                    }

                }
                /***** 更新 POS本地数据库的商品表 真实小票号；end:********/

                /***** 更新 POS本地数据库的促销优惠表-真实小票号: 解耦后,仍然有能正确打印订单数据的关联关系:；begin:*********/
                bool retSyncOrderPromotion = true;  //默认是同步POS促销优惠成功; 目前只有 businessType: 20:WSG-杯贴祝福;  30: 拼团;
                if ( PrintOrderPromotionDB::getInstance().isOrderPromotionExist(order_p) ) {
                    if (m_hurryPrintSum)  {
                        QLOG_INFO()<<QString("[<<<<---_ResponseSimphony04Request::orderId:%1 Is HurryPrintSum, No Need Update PrintOrderPromotionDB CheckNo, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                    } else {
                        if (!PrintOrderPromotionDB::getInstance().updateOrderPromotionCheckNum(order_p, posCheckNo) )
                            retSyncOrderPromotion = false;
                    }
                } else {
                    if (m_hurryPrintSum)  {
                        QLOG_INFO()<<QString("[<<<<---_ResponseSimphony04Request::orderId:%1 Is HurryPrintSum, No Need Insert PrintOrderPromotionDB, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                    } else {
                        if (!PrintOrderPromotionDB::getInstance().insertOrderPromotion(order_p, posCheckNo) )
                            retSyncOrderPromotion = false;
                    }

                }
                /***** 更新 POS本地数据库的促销优惠数据是否成功；end:********/

                bool insertPrtMsgRet = false;
                if ( bRetReportCheckNo && retSyncOrderProduct && retSyncOrderPromotion) {
                    // 汇报小票号成功后，需要向打印消息队列中插入一条记录;
                    // 同时也需要更新汇总小票表中的 reserve1 字段值 ( 将在函数 insertOrderPrtMsg(*,*,*) 内部处理 );
                    // 向打印队列表中添加 入机成功订单记录 已经在入机前，本地数据存储阶段就已经存储完成，目前入机后将无需插入与更新;
                    if ( PrintMsgQueueDB::getInstance().isOrderPrtMsgExist(order_p) ) {
                        insertPrtMsgRet = true;
                    } else {
                        if (m_hurryPrintSum)  {
                            QLOG_INFO()<<QString("[<<<<---_ResponseSimphony04Request::orderId:%1 Is HurryPrintSum, No Need Insert PrintMsgQueueDB, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                            insertPrtMsgRet = true;
                        } else {
                            insertPrtMsgRet = PrintMsgQueueDB::getInstance().insertOrderPrtMsg(order_p, posCheckNo);
                        }

                    }
                     QLOG_INFO()<<QString("[<<<<---PrintMsgQueueDB::insertOrderPrtMsg orderId:%1  chk_num:%2  ret:%3--->>>>]")
                                  .arg(orderId).arg(posCheckNo).arg(insertPrtMsgRet?1:0);
                }

                //入机成功更新插件上POS小票号显示;
                order_p->dataBasePosOrderCheckNo = posCheckNo;
                /***** 解析 汇报POS小票号是否成功:bRetReportCheckNo:true->成功********/
                QJsonObject rObj, cObj;
                rObj.insert("fm_cmd", "");
                rObj.insert("fm_ver", "1.0");
                cObj.insert("pay_id", "002");
                cObj.insert("pay_str", QString::fromLocal8Bit("非码外卖"));
                cObj.insert("paid_trans_id",orderId);
                if(bRetReportCheckNo && retSyncOrderProduct && retSyncOrderPromotion && insertPrtMsgRet ){  //已经汇报完小票号，因此必须从 m_simValidOrdersList 列表中移除;
                    cObj.insert("reqResult",1); // 汇报POS小票号结果：[1:成功；0:失败]
                    rObj.insert("pay_id", cObj);
                    data = rObj;
                    m_OrderEntryMutex.lock();
                    m_simValidOrdersList.removeOne(orderId);
                    m_OrderEntryMutex.unlock();
                } /***** 解析 汇报POS小票号是否成功:bRetReportCheckNo:true->成功*****/
                else{
                    result=false;
                    error=QString::fromLocal8Bit("Report POS Check Num Failed");
                    // 即使汇报小票号失败，同样也必须将此订单从 m_simValidOrdersList 列表中移除:【汇报小票号的前提条件就是:POS已经结单完成】；
                    cObj.insert("reqResult",0); // 汇报POS小票号结果：[1:成功；0:失败]
                    rObj.insert("pay_id", cObj);
                    data = rObj;
                    m_OrderEntryMutex.lock();
                    m_simValidOrdersList.removeOne(orderId);
                    m_OrderEntryMutex.unlock();
                }

                //新增业务逻辑,针对汇报小票号成功的订单需要;添加到 向OMS汇报入机情况的队列中;            
                QString requestType  = (6 == order_p->orderStatus)?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                QString msgDesc = QString::fromLocal8Bit("入机成功");
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_ResponseSimphony04Request:m_orderRecordRepOMSList.append() orderId:%1 orderStatus:%2 checkNo:%3--->>>>]")
                             .arg(orderId).arg(requestType).arg(posCheckNo);
                _AddOrUpdateReportOmsList(orderId, order_p->channel,requestType, QString("1"), posCheckNo, msgDesc, QString(""));
            }

        } else {
            result=false;
            error=QString::fromLocal8Bit("Request Action04: Delivery OrderId Or Check Num Can't Empty");
        }
    } else {
        result=false;
        error=QString::fromLocal8Bit("Request Action04: Request Pragram Error");
    }
    emit doUnLockFloatFrom();//****************解锁悬浮框**************//
    if(m_bFloatFromLockSt){
        m_bFloatFromLockSt = false; //更新悬浮框的锁定状态 =false;
    }
    //为了避免压测插件时,高频的加锁悬浮框 与 高频点击POS机;所以将 及时点击POS机右下角按钮放到上次录单成功后再触发下一次录单事件；
    _ClickOMSAssignArea();
    return result;
}


bool FlowControl::_ResponseSimphony05Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    bool result=true;
    m_clickPosCount = 0;
    if(m_bLoginResult&&content.contains("orderId")){
        QString orderId=content["orderId"].toString();
        QString posCheckNo=content["posSaleId"].toString();
        QString posCheckTime=content["posCheckTime"].toString();

        if(posCheckNo.isEmpty())
        {
            error=QString::fromLocal8Bit("Request Action05: %1 Delivery Order: Check Num Can't Empty").arg(orderId);
            return false;
        }
        if(!posCheckNo.isEmpty()&&!orderId.isEmpty())
        {
            OrderObject* order_p =  m_FmOrdersMap.value(orderId);
            if (!order_p){
                QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---%1订单并不存在m_FmOrdersMap[键值对]中;m_FmOrdersMap.size()=%2--->>>>]").arg(orderId).arg(m_FmOrdersMap.size());
                error=QString::fromLocal8Bit("Request Action05: %1 Delivery Order Don't Exist In m_FmOrdersMap[key-map] m_FmOrdersMap.size()=%2").arg(orderId).arg(m_FmOrdersMap.size());
                return false;
            }
            //更新小票号;
            if(!m_orderIdToPosCheckNoMap.contains(orderId))
            {
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:05: 更新POS本地数据库打印信息] %1订单已经成功推送给simphony:--->>>>]").arg(orderId);
                m_orderIdToPosCheckNoMap.insert(orderId,posCheckNo);
            } else {
                if(OrderObject::Refunded==order_p->orderStatus){
                    if(posCheckNo != m_orderIdToPosCheckNoMap.value(order_p->id)){
                        m_orderIdToPosCheckNoMap.remove(order_p->id);
                        m_orderIdToPosCheckNoMap.insert(orderId,posCheckNo);
                    }
                }
            }

            if(m_simValidOrdersList.contains(orderId))
            {
                /***** 更新 POS本地数据库的打印信息是否成功；begin:*********/
                int retSyncOrderSum = 0;  //默认是同步POS本地数据失败;
                /***********解耦前后汇总表中都会保存2条记录 ***************/
                if (PrintSumBillPosDB::getInstance().isOrderSumBillExist(order_p) ) {
                    if ( m_hurryPrintSum ) {
                        // 着急打印的情况，接受到订单时就已经插入了,且无需更新小票号;
                        QLOG_INFO()<<QString("[<<<<---_ResponseSimphony05Request::orderId:%1 Is HurryPrintSum, No Need Update SumInfo, Because Recive Order Had Storage, Can't Change CheckNo--->>>>]").arg(orderId);
                        retSyncOrderSum = 1;
                    } else {
                        if ( PrintSumBillPosDB::getInstance().updateSumBillCknoAndCktime(order_p,posCheckNo,posCheckTime) ) {
                            retSyncOrderSum = 1;
                        }
                    }

                } /*****POS本地数据库不存在 orderId &&posCheckNo*********/
                else{
                    QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---Simphony[ACTION:05:] OrderId:%1 Not Exist In tb_msr_customer_info --->>>>]").arg(orderId);
                    if ( PrintSumBillPosDB::getInstance().insertOrderSumBill(order_p, posCheckNo, posCheckTime) ){
                      retSyncOrderSum = 1;
                    }
                } /***** 更新 POS本地数据库的打印信息是否成功；end:********/

                /***** 解析 同步更新POS本地数据库是否成功:retSyncOrderPrintInfo:1->成功********/
                if(retSyncOrderSum){
                    // 还没汇报完小票号，因此还不能从 m_simValidOrdersList 列表中移除;
                    QJsonObject rObj, cObj;
                    rObj.insert("fm_cmd", "");
                    rObj.insert("fm_ver", "1.0");
                    cObj.insert("pay_id", "002");
                    cObj.insert("pay_str", QString::fromLocal8Bit("FmTakeout"));
                    cObj.insert("reqResult",retSyncOrderSum); //同步POS本地数据库汇总表：[1:同步成功；0:同步失败]
                    cObj.insert("paid_trans_id",orderId);
                    rObj.insert("pay_id", cObj);
                    data = rObj;
                } /***** 解析 同步更新POS本地数据库是否成功:retSyncOrderSum:0->失败*****/
                else{
                    result=false;
                    error=QString::fromLocal8Bit("Request Action05:Sync POS Local DataBase-Summary Failed");
                }
            } else {
                m_OrderEntryMutex.lock();
                m_simValidOrdersList.append(orderId);
                m_OrderEntryMutex.unlock();
            }
        } else {
            result=false;
            error=QString::fromLocal8Bit("Request Action05: Delivery OrderId And Check Num Can't Empty");
        }
    } else {
        result=false;
        error=QString::fromLocal8Bit("Request Action05: Pragram Error");
    }
    return result;
}



bool FlowControl::_ResponseSimphony06Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    bool result=true;
    m_clickPosCount = 0;
    if(m_bLoginResult&&content.contains("orderId")){
        QString orderId=content["orderId"].toString();
        QString simExceptCode=content["simExceptCode"].toString();
        QString simExceptMsg=content["simExceptMsg"].toString();

        if(!simExceptCode.isEmpty()&&!orderId.isEmpty()) {
            //*********** 新增一种优化case: 门店店员正在操作POS,从而阻塞插件程序录外卖订单,此时必须解锁悬浮框，从而减少Simphony队列中first出现OMS退单的请求; begin ***********//
            //此时的订单号时固定给的620620 [action:6,simExceptCode=20]
            if( 20 == simExceptCode.toInt() ){
                error=QString::fromLocal8Bit("Request Action06: Partner is serving Offline Customer ");
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_ResponseSimphony06Request::%1--->>>>>]").arg(error);
                emit doUnLockFloatFrom(); //****************解锁悬浮框*****************//
                if(m_bFloatFromLockSt){
                    m_bFloatFromLockSt = false; //更新悬浮框的锁定状态 =false;
                }
                //为了避免压测插件时,高频的加锁悬浮框 与 高频点击POS机; _ClickOMSAssignArea();
                //由于上面出现了异常;不能也不需要及时点击POS机按钮触发下一次的录单事件
                QJsonObject rObj, cObj;
                rObj.insert("fm_cmd", "");
                rObj.insert("fm_ver", "1.0");
                cObj.insert("pay_id", "002");
                cObj.insert("pay_str", QString::fromLocal8Bit("FmTakeout"));
                cObj.insert("reqResult",1); //响应SIM汇报异常结果：[1:处理异常成功；0:处理异常失败]
                cObj.insert("paid_trans_id",orderId);
                rObj.insert("pay_id", cObj);
                data = rObj;

                //新增业务逻辑,针对汇报异常的订单需要;添加到 向OMS汇报入机情况的队列中;
                if(!m_simValidOrdersList.empty()){
                    QString tmpOrderId = m_simValidOrdersList.first();
                    QString requestType = "0";
                    QString tmpChannel = "";
                    OrderObject* order_temp =  m_FmOrdersMap.value(tmpOrderId);
                    if (!order_temp){
                        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---%1订单并不存在m_FmOrdersMap[键值对]中;m_FmOrdersMap.size()=%2--->>>>]").arg(orderId).arg(m_FmOrdersMap.size());
                    }else{
                        requestType = order_temp->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                        tmpChannel = order_temp->channel;
                    }
                    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_ResponseSimphony06Request:m_orderRecordRepOMSList.append() orderId:%1 simExceptMsg:%2--->>>>]").arg(orderId).arg(simExceptMsg);
                    _AddOrUpdateReportOmsList(tmpOrderId,  tmpChannel, requestType, QString("2"), QString(""), simExceptMsg, QString("") );
                }
                return true;
            }
            //*********** 新增一种优化case: 门店店员正在操作POS,从而阻塞插件程序录外卖订单,此时必须解锁悬浮框，从而减少Simphony队列中first出现OMS退单的请求; end ***********//

            //**************** 根据订单编号找到 非码订单Map容器中订单的详细信息; begin ****************//
            OrderObject* order_p =  m_FmOrdersMap.value(orderId);
            if (!order_p) {
                QLOG_ERROR()<<QString::fromLocal8Bit("[<<<<---%1订单并不存在m_FmOrdersMap[键值对]中;m_FmOrdersMap.size()=%2--->>>>]").arg(orderId).arg(m_FmOrdersMap.size());
                error=QString::fromLocal8Bit("Request Action06: %1 Delivery Order Don't Exist In m_FmOrdersMap[key-map]; m_FmOrdersMap.size()=%2").arg(orderId).arg(m_FmOrdersMap.size());
                emit doUnLockFloatFrom();//****************解锁悬浮框*****************//
                if(m_bFloatFromLockSt){
                    m_bFloatFromLockSt = false; //更新悬浮框的锁定状态 =false;
                }
                return false;
            }
            //**************** 根据订单编号找到 非码订单Map容器中订单的详细信息; end ****************//

            // 判断SIM是否存在错误码: 0:会在汇报完小票号发送此错误码的请求给插件以便做一些特别事件: 解锁悬浮框；1:SIM录单出异常:转移订单tab至异常单、请求sim的有效订单列表、解锁悬浮框:
            int retProcSimExceptCode =0;
            // 特殊处理录单异常的详细case:
            if(simExceptCode.toInt()) {
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_ResponseSimphony06Request:: OrderId:%1,simExceptCode:%2 录单异常--->>>>>]").arg(orderId).arg(simExceptCode.toInt());
                //异常错误码10的case:: 常见的正常业务场景下的异常 这些异常不应该阻塞订单的多次尝试录入，如果没有尝试多次录入的机会将会出现POS机少录订单不出小票的case:更多的详细请参考Simphony脚本中错误码为10情况，
                if(10 == simExceptCode.toInt()){
                    error=QString::fromLocal8Bit("Request Action06 :simExceptCode==10: Catch Sim Refund Auth Exception And Report Success");
                    retProcSimExceptCode = 1;
                    result=true;
                }
                //异常错误码非10的case::
                //simExceptCode ==5: POS录单过程中 同步本地数据库小票信息出现异常时触发多次录单的异常必须捕捉,此时必须解锁悬浮框;[action:6,simExceptCode=5]
                //simExceptCode ==1: POS录单过程中 POS机中没有相应的SKU 的异常必须捕捉,此时必须解锁悬浮框;[action:6,simExceptCode=1]
                else {
                    if(m_simValidOrdersList.contains(orderId)) {
                                        m_OrderEntryMutex.lock();
                                        m_simValidOrdersList.removeOne(orderId);
                                        m_OrderEntryMutex.unlock();
                                        int oldStatus = order_p->orderStatus;
                                        if(6 == oldStatus || OrderObject::SimExceptRefund == order_p->orderStatus){
                                            order_p->orderStatus = OrderObject::SimExceptRefund;
                                        }else{
                                            order_p->orderStatus = OrderObject::SimExceptSale;
                                        }
                                        emit changeOrderStatus(order_p,oldStatus);
                                        error=QString::fromLocal8Bit("Request Action06: Catch Sim Recorded Order Exception And Report Success");
                                        retProcSimExceptCode = 1;
                                        result=true;
                                    }
                }
            } else { //录单正常//
                QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_ResponseSimphony06Request:: OrderId:%1 录单成功--->>>>>]").arg(orderId);
                error=QString::fromLocal8Bit("Request Action06: Catch Sim Recorded Order Exception And Report Success");
                retProcSimExceptCode = 1;
                result=true;
            }
            //**************** 组装响应SIM录单异常响应********************//
            QJsonObject rObj, cObj;
            rObj.insert("fm_cmd", "");
            rObj.insert("fm_ver", "1.0");
            cObj.insert("pay_id", "002");
            cObj.insert("pay_str", QString::fromLocal8Bit("FmTakeout"));
            cObj.insert("reqResult",retProcSimExceptCode); //响应SIM汇报异常结果：[1:处理异常成功；0:处理异常失败]
            cObj.insert("paid_trans_id",orderId);
            rObj.insert("pay_id", cObj);
            data = rObj;
            //************* 新增业务逻辑,针对汇报异常的订单需要;添加到 向OMS汇报入机情况的队列中;  Begin*************//
            QString requestType = order_p->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
            QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---FlowControl::_ResponseSimphony06Request:m_orderRecordRepOMSList.append() orderId:%1 simExceptMsg:%2--->>>>]").arg(orderId).arg(simExceptMsg);
            _AddOrUpdateReportOmsList(orderId,  order_p->channel, requestType, QString("2"), QString(""), simExceptMsg, QString("") );
            //************* 新增业务逻辑,针对汇报异常的订单需要;添加到 向OMS汇报入机情况的队列中;  end*************//
        } else {
            result=false;
            error=QString::fromLocal8Bit("Request Action06: Delivery OrderId And Sim Exception ErrorCode Can't Empty");
        }
    } else {
        result=false;
        error=QString::fromLocal8Bit("Request Action06: Request Pragram Error");
    }
    //****************解锁悬浮框*****************//
    emit doUnLockFloatFrom();
    if(m_bFloatFromLockSt){
        m_bFloatFromLockSt = false; //更新悬浮框的锁定状态 =false;
    }
    //为了避免压测插件时,高频的加锁悬浮框 与 高频点击POS机; _ClickOMSAssignArea();
    //由于上面出现了异常;不能也不需要及时点击POS机按钮触发下一次的录单事件;
    return result;
}


bool FlowControl::_ResponseOMS11Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    Q_UNUSED(data);
    QLOG_INFO()<<__FUNCTION__;
    bool result = true;
    m_clickPosCount = 0;

    if ( !m_bLoginResult ) {
        error = QString::fromLocal8Bit("FMOMS未登录");
        return false;
    } else {
        if ( content[JSON_ORDER_ID].toString().isEmpty() ) {
            error =QString::fromLocal8Bit("订单号不能为空");
            return false;
        } else {
            QString omsPushOrderId = content[JSON_ORDER_ID].toString();
            QString omsPushOrderChannel = content[JSON_CHANNEL].toString();
            int omsPushOrderStatus = content[JSON_STATUS].toInt();

            if ( 6 == omsPushOrderStatus ) {
                // 避免小概率事件：①重复录单  ②单边账;
                bool bRetDelayGetRefundDetailMutex =m_delayGetRefundDetailMutex.tryLock(VALUE_TRYLOCKMEMTIMEOUT);
                if( !bRetDelayGetRefundDetailMutex ) {
                    QLOG_ERROR() << QString("[<<<<---_ResponseOMS11Request:orderId: %1  m_delayGetRefundDetailMutex.tryLock  Failed --->>>>]").arg(omsPushOrderId);
                    error =QString::fromLocal8Bit("当前订单是退单，准备将其添加到 延迟获取退单详情队列时，加锁失败，请重新推送");
                    return false;
                }

                /***组装延迟拉单请求对象参数***/
                DelayPullOrderInfo* delayOrderPull_p = new DelayPullOrderInfo();
                if ( !delayOrderPull_p ) {
                    QLOG_ERROR() << QString("[<<<<---_ResponseOMS11Request:orderId: %1  New  DelayPullOrderInfo Failed --->>>>]").arg(omsPushOrderId);
                    error =QString::fromLocal8Bit("当前订单是退单，准备将其添加到 延迟获取退单详情队列时，New DelayPullOrderInfo 失败，请重新推送");
                    return false;
                }
                delayOrderPull_p->orderId=omsPushOrderId;
                delayOrderPull_p->channel=omsPushOrderChannel;
                m_delayGetRefundDetailList.append(delayOrderPull_p);
                QLOG_INFO()<<QString("[<<<<---_ResponseOMS11Request: orderId: %1 Append Success,  m_delayGetRefundDetailList size: %2  And FirstOne: %3 --->>>>>]")
                             .arg( omsPushOrderId ).arg( m_delayGetRefundDetailList.size() ).arg( m_delayGetRefundDetailList.isEmpty()? " " : m_delayGetRefundDetailList.first()->orderId );
                m_delayGetRefundDetailMutex.unlock();

            } else {
                // 接受到非码oms插过来的订单，进行向队列中进行添加；
                // Case3:  添加前 筛选是否已经存在待拉取的状态;
                result =  _TryAddOrderPull( omsPushOrderId, omsPushOrderChannel );
            }

        }

        if ( result ) {
            error = QString("success");
        } else {
            error = QString("failed");
        }

    }
    return result;
}

bool FlowControl::_ResponseOMS12Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    Q_UNUSED(data);
    //判断当前POS插件是否登录成功: 如果没有登录成功，尝试在次登录;
    bool result = true;
    if(!m_bLoginResult&&content.contains("storeId")) {
        result=_ResponseSimReqTryLogin(content,error);
    }
    //如果登录成功 or 插件正在尝试登录中:则return true 并返回相应的错误信息;
    if(result){
        if(!content["storeId"].toString().compare(m_storeId)) {
            QLOG_INFO()<<"FlowControl::_ResponseOMS12Request:"<<content;
            m_eleStoreStatus = content[JSON_ELESTORESTS].toInt();
            m_modStoreStatus = content[JSON_MODSTORESTS].toInt();
            m_mopStoreStatus = content[JSON_MOPSTORESTS].toInt();
            QLOG_INFO()<<QString("[<<<<---FlowControl::_ResponseOMS12Request eleStoreStatus:%1;modStoreStatus:%2;mopStoreStatus:%3 --->>>>]").
                         arg(m_eleStoreStatus).arg(m_modStoreStatus).arg(m_mopStoreStatus);

            emit doUpdateStoreStatus(m_eleStoreStatus,m_modStoreStatus,m_mopStoreStatus);

            error=QString("success");
            result = true;
        } else {
            error=QString::fromLocal8Bit("门店信息不匹配");
            result = false;
        }
    }
    return result;
}



bool FlowControl::_ResponseHM21Request(const QJsonObject &content, QJsonObject &data, QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    //判断当前POS插件是否登录成功: 如果没有登录成功，尝试在次登录;
    Q_UNUSED(data);
    bool result=true;
    m_clickPosCount = 0;
    if(!m_bLoginResult&&content.contains("storeId")) {
        result=_ResponseSimReqTryLogin(content,error);
    }
    //如果登录成功 or 插件正在尝试登录中:则return true 并返回相应的错误信息;
    if(result){
        //<1>:更新 OrderObject 中的数据;
        //增加筛选条件,判断当前POS系统录单的订单是否还没录单完成:如果该订单录单没有完成,不返回100,务必让服务的等待;
        if(content[JSON_ORDER_ID].toString().isEmpty()) {
            error =QString::fromLocal8Bit("订单号不能为空");
            return false;
        } else {
            if(!m_simValidOrdersList.isEmpty()){
                QString simValidOrderListFirstOne = m_simValidOrdersList.first();
                //缩小锁住订单的条件范围: 服务端推单给插件程序且插件程序拒绝本次订单状态发生变化的请求
                if(content[JSON_ORDER_ID].toString() == simValidOrderListFirstOne && m_bFloatFromLockSt){
                    error =QString::fromLocal8Bit("当前订单正在录POS系统，请耐心等待");
                    return false;
                }
            }
        }

        QJsonObject hmOrderJson =  content["orderDetail"].toObject();
        QLOG_INFO()<<"FlowControl::_ResponseHM21Request:"<<hmOrderJson;
        if(!hmOrderJson.isEmpty()){
            result = true;
            error=QString::fromLocal8Bit("_ResponseHM21Request Action:21:accept HM Order Success");
             _OrderAnalysis(hmOrderJson);
        }else{
            result = false;
            error=QString::fromLocal8Bit("_ResponseHM21Request Action:21:accept HM Order empty");
        }
        //<2>:向simphony整合订单数据:准备向POS录单【_OrderAnalysis(hmOrderJson);函数会触发simphony录单动作(退单的情况也会存入队列中)】
        //result=_ResponseSimReqFristOrderData(content, data,error,content["orderId"].toString());
    } else {
        result = false;
        if(error.isEmpty()) {
            error=QString::fromLocal8Bit("Response Simphony_Script Request 01: Login Store Failed");
        }
    }
    return result;
}


bool FlowControl::_ResponseSimReqTryLogin(const QJsonObject &content,QString &error)
{
    QLOG_INFO()<<__FUNCTION__;
    m_storeId=content["storeId"].toString();   //未登陆成功前 storeId;

    m_subStoreId =  ConfigManger::GetInstance().GetSubStoreId();
    // 跳过 校验配置 子门店 与 母门店的前三位是否一致；增加安全保护机制 (同时实现参数可控 校验功能 );
    if ( ConfigManger::GetInstance().GetSubStoreSkipVerify() ) {
        m_storeId = m_subStoreId.length()?m_subStoreId:m_storeId;
    } else {
        m_storeId  = (m_subStoreId.length() && m_subStoreId.left(3) == m_storeId.left(3) )?m_subStoreId:m_storeId;
    }
    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---_ResponseSimReqTryLogin: m_storeId=%1 ,  m_subStoreId=%2 --->>>>>]").arg(m_storeId).arg(m_subStoreId);

    //m_deviceNo=content["posId"].toString();  //将来用来扩展新字段值
    m_posId= "111111111111111";   // 避免上游出现多条 POS插件登录记录(设备id不一致);
    m_posWorkstationNum=content["businessDay"].toString();   // 折中方案,使用营业时间透传 POS WorkStation Num;
    m_cashierId=content["operatorId"].toString();
    m_cashierName=content["operatorName"].toString();
    if(m_bFirstRecvInfo) {
        error = QString::fromLocal8Bit("FMOMS Plug-in Program Try Login On");
        emit doLogin();
    }
    return true;
}

bool FlowControl::_ResponseSimReqFristOrderData(const QJsonObject &content, QJsonObject &data, QString &error, const QString &orderId)
{
    QLOG_INFO()<<__FUNCTION__<<error<<orderId;

    // m_deviceNo=content["posId"].toString();  //将来用来扩展新字段值
    m_posId= "111111111111111";   // 避免上游出现多条 POS插件登录记录(设备id不一致);
    m_posWorkstationNum=content["businessDay"].toString();  // 折中方案,使用营业时间透传 POS WorkStation Num;
    m_cashierId=content["operatorId"].toString();
    m_cashierName=content["operatorName"].toString();
    emit setCashierInfo(m_cashierName); //POS上收银员切换账号后,插件上右下角的收银员信息也及时更新;

    QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:01: 获取订单数据] 开始获取 OrderId:%1 给simphony:--->>>>>]").arg(orderId);
    bool result=true;
    if(!m_bLoginResult) {
        error = QString::fromLocal8Bit("FMOMS Plug-in Program Not Login On");
        return false;
    }

    if(m_simValidOrdersList.isEmpty()) {
        error = QString::fromLocal8Bit("No New Delivery Order Need To Pull.");
        return  true;
    } else {
        error.clear();
        QString orderId=m_simValidOrdersList.first();
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:01:]FMOMS已登录，且有订单待拉取:orderId:%1--->>>>>]").arg(orderId);

        OrderObject* orderObject = m_FmOrdersMap.value(orderId);
        if(!orderObject){
            error = QString::fromLocal8Bit("Delivery Order had been clear by _CrondClearExpireOrder.");
            m_OrderEntryMutex.lock();
            m_simValidOrdersList.removeFirst();
            m_OrderEntryMutex.unlock();
            return  false;
        }

        if (orderObject->decouplePosVersion >= 20 ) {
            error = QString::fromLocal8Bit("Delivery Order Decouple Pos Version: %1 , No Need Record Pos").arg(orderObject->decouplePosVersion);
            m_OrderEntryMutex.lock();
            m_simValidOrdersList.removeFirst();
            m_OrderEntryMutex.unlock();
            return  false;
        }

        if(MAXPUTTIMES==orderObject->pushOrderTimes) {
            orderObject->pushOrderTimes = 0;
        } else {
            orderObject->pushOrderTimes=orderObject->pushOrderTimes+1;
        }
        if(MAXPUTTIMES==orderObject->orsPushOrderTimes) {
            orderObject->orsPushOrderTimes = 0;
        } else {
            orderObject->orsPushOrderTimes=orderObject->orsPushOrderTimes+1;
        }
        //防止POS出现多次录单：退货单(销售单应该不会)；
        bool retGetDbOrderAllFlag = SimProcOrderDB::getInstance().getDbOrderAllFlag(orderObject->id,orderObject->dataBaseIsOrderExistInt,orderObject->dataBaseIsPushInt,
        orderObject->dataBaseIsCancleInt,orderObject->dataBaseIsORSPushInt,orderObject->dataBaseIsORSCancleInt,orderObject->dataBasePosOrderCheckNo);

        if(!retGetDbOrderAllFlag ){
            QLOG_ERROR() << QString("[<<<<---FmTakeout _ResponseSimReqFristOrderData:orderObject->id:%1 SimProcOrderDB::getInstance().getDbOrderAllFlag Failed --->>>>]").arg(orderObject->id);
        }

        QLOG_INFO() << QString("[<<<<---FmTakeout _ResponseSimReqFristOrderData: orderObject->id:%1 ,dataBaseIsOrderExistInt:%2 ,dataBaseIsPushInt:%3 ,dataBaseIsCancleInt:%4 ,"
                               "dataBaseIsORSPushInt:%5 ,dataBaseIsORSCancleInt:%6 ,dataBasePosOrderCheckNo:%7--->>>>]")
        .arg(orderObject->id).arg(orderObject->dataBaseIsOrderExistInt).arg(orderObject->dataBaseIsPushInt).arg(orderObject->dataBaseIsCancleInt)
        .arg(orderObject->dataBaseIsORSPushInt).arg(orderObject->dataBaseIsORSCancleInt).arg(orderObject->dataBasePosOrderCheckNo);

        bool  bIsPushOrder = orderObject->dataBaseIsPushInt;
        bool  bIsRefundOrder = orderObject->dataBaseIsCancleInt;
        bool  bIsORSPushOrder = orderObject->dataBaseIsORSPushInt;
        bool  bIsORSCancleOrder = orderObject->dataBaseIsORSCancleInt;

        //避免：销售单,退货单 两个方向都已经入机完成订单重复入机【&& !orderObject->appointmentDayFlag || && orderObject->appointmentDayFlag】;
        // if(bIsPushOrder && bIsRefundOrder && !orderObject->appointmentDayFlag  || bIsORSPushOrder && bIsORSCancleOrder && orderObject->appointmentDayFlag )
        if( bIsPushOrder && bIsRefundOrder || bIsORSPushOrder && bIsORSCancleOrder || !retGetDbOrderAllFlag ) {
            QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:01:] bIsPushOrder: ;bIsRefundOrder: ;--->>>>>]")<<bIsPushOrder<<bIsRefundOrder;
            //error = QString::fromLocal8Bit("该订单已经被POS系统录入完成");
            error = QString::fromLocal8Bit("This Delivery Order Have Been Recorded In POS System Successfully");
            m_OrderEntryMutex.lock();
            m_simValidOrdersList.removeOne(orderObject->id);
            m_OrderEntryMutex.unlock();
            return true;
        }

        // 正向单不是最后一次录入必须结合订单入机类型，而退货是最后一次入机，故无需 额外条件组合判断;
        if( (orderObject->pushOrderType==1 || orderObject->orsPushOrderType==1) && (1==orderObject->forwardPosStatus) || (1==orderObject->negativePosStatus) ) {
            QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:01:] forwardPosStatus:  negativePosStatus: ;--->>>>>]")
                      <<orderObject->forwardPosStatus<<orderObject->negativePosStatus;
            error = QString::fromLocal8Bit("This Delivery Order Have Been Recorded In POS System Successfully");
            m_OrderEntryMutex.lock();
            m_simValidOrdersList.removeOne(orderObject->id);
            m_OrderEntryMutex.unlock();
            return true;
        }

        //检查Order Data Valid; 防止录入销售单时 接受到OMS推送取消订单请求且插件未锁屏时，列表录单请求被移除;
        if( m_simValidOrdersList.isEmpty() ) {
            error = QString::fromLocal8Bit("This Delivery Order:%1 Is Invalid, No Need Record  POS System").arg(orderObject->id);
            return true;
        }

        //检查: 录入销售单时未成功待排队,此时插件退单 并且订单数据已被退单数据更新，需要踢出待入机队列;
        if( 6 == orderObject->orderStatus && 0 == bIsPushOrder  ) {
            m_OrderEntryMutex.lock();
            m_simValidOrdersList.removeOne(orderObject->id);
            m_OrderEntryMutex.unlock();
            error = QString::fromLocal8Bit("This Delivery Order Had Refund: %1 Is Invalid, No Need Record  POS System").arg(orderObject->id);
            return true;
        }

        //录单时才触发隐藏 主窗口 + 锁定悬浮框;
        if(!m_bFloatFromLockSt){
            m_bFloatFromLockSt = true; //更新悬浮框的锁定状态=true;
        }
        emit doHideMainShowFloatFrom();
        emit doLockFloatForm();

        QJsonObject rObj, cObj;
        if(orderObject->pushOrderType==1 || orderObject->orsPushOrderType==1) {
            rObj.insert("fm_cmd", "put_order");
        } else {
            rObj.insert("fm_cmd", "refund_order");
        }
        rObj.insert("fm_ver", "1.0");
        cObj.insert("pay_id", "002");
        cObj.insert("pay_str", QString::fromLocal8Bit("FmTakeout"));
        int tempServiceType = 0,  tempOrderPayType = 0,  tempSbkAppPayType=0;
        QString tempSbkAppPayValue="0";
        // 转换成星巴克规定的订单类型;
        //星巴克的订单类型：1:新订单; 2:预订单; 3:客诉单; 4:MOP自测订单; 5:预约订单; 7:当日预约单；8拼单(使用父级订单类型)
        // 客诉单 支付方式 由现金 变更为  OrderPayType=1;在Simphony扩展程序将其转换成 84:MOD + 非码订单:orderId 入机;
        if(3 == orderObject->getOrderType()) {
            tempOrderPayType = 1;
        }
        // MOP自测订单 在下方处理;星巴克-预约订单:在下方处理;
        // OMS提供的数据://订单渠道: 星巴克-MOD,百度外卖,饿了么APP,美团外卖,星巴克-MOP;
        // MOD渠道对应的业务逻辑 ;
        else if ( "MOD" == orderObject->channel ) {
            // platformSource:平台来源:1 app;  2 ele;  3 ors;  4 WeChat ;   5 口碑;
            tempOrderPayType = 84;
            //星巴克App端支付方式: 1:支付宝; 2:微信; 3:银联; 4:SVC卡; 5/7:MOP使用券或星星抵扣 0元支付; 8:IStore订单; 9:银联支付(=3);
            if(4 == orderObject->payWay){
                tempSbkAppPayType = 14 ;
                //svc卡支付时传交易流水号协定:
                if(OrderObject::Refunded == orderObject->orderStatus ||OrderObject::SimExceptRefund == orderObject->orderStatus){
                    tempSbkAppPayValue = orderObject->refundFmId.isEmpty()?QString("0"):orderObject->refundFmId;
                }else{
                    tempSbkAppPayValue = orderObject->payfmId;
                }
            }else if(1 == orderObject->payWay){
                tempSbkAppPayType = 78;
                tempSbkAppPayValue = (orderObject->thirdPartyBatch).length()?orderObject->thirdPartyBatch :QString("0");
            }else if(2 == orderObject->payWay){
                tempSbkAppPayType = 77;
                tempSbkAppPayValue = (orderObject->thirdPartyBatch).length()?orderObject->thirdPartyBatch :QString("0");
            //防止后期 MOD 使用 券 + 星星折扣 +（券&星星折扣）用户不用实际支付任何金额，需要采用0元支付方式结单;
            //插件传给Simphony扩展程序时支付方式=1;在Simphony扩展程序将其转换成 84:MOD + 非码订单:orderId 入机;
            }else if(5 == orderObject->payWay || 7 == orderObject->payWay){
                tempOrderPayType = 1;
            }else{
                tempSbkAppPayType = -1;
                tempSbkAppPayValue = "-1";
            }

        } else if ( "WSG-MOD" == orderObject->channel ) {
            // platformSource:平台来源:1 app;  2 ele;  3 ors;  4 WeChat;   5 口碑;
            tempOrderPayType = 84;
            tempSbkAppPayType = -1;
            tempSbkAppPayValue = "-1";

       }// MOP渠道对应的业务逻辑;
        else if ( "MOP" == orderObject->channel || "EC-MOP" == orderObject->channel ){

            tempOrderPayType = 84;
            //星巴克App端支付方式: 1:支付宝; 2:微信; 3:银联; 4:SVC卡; 5/7:MOP使用券或星星抵扣 0元支付; 8:IStore订单; 9:银联支付(=3);
            if ( 4 == orderObject->payWay ) {
                tempSbkAppPayType = 14 ;
                //svc卡支付时传交易流水号协定:
                if(OrderObject::Refunded == orderObject->orderStatus ||OrderObject::SimExceptRefund == orderObject->orderStatus){
                    tempSbkAppPayValue = orderObject->refundFmId.isEmpty()?QString("0"):orderObject->refundFmId;
                }else{
                    tempSbkAppPayValue = orderObject->payfmId;
                }
            }else if(1 == orderObject->payWay){
                tempSbkAppPayType = 78;
                tempSbkAppPayValue = (orderObject->thirdPartyBatch).length()?orderObject->thirdPartyBatch :QString("0");
            }else if(2 == orderObject->payWay){
                tempSbkAppPayType = 77;
                tempSbkAppPayValue = (orderObject->thirdPartyBatch).length()?orderObject->thirdPartyBatch :QString("0");
            //针对使用 券 + 星星折扣 +（券&星星折扣）用户不用实际支付任何金额，需要采用0元支付方式结单;
            //插件传给Simphony扩展程序时支付方式=1;在Simphony扩展程序将其转换成 84:MOD + 非码订单:orderId 入机;
            }else if(5 == orderObject->payWay || 7 == orderObject->payWay){
                tempOrderPayType = 1;
            }else{
                tempSbkAppPayType = -1;
                tempSbkAppPayValue = "-1";
            }

            //MOP最后判断 是否是 MOP自测订单;
            if(4== orderObject->getOrderType()) {
                tempOrderPayType = 1;
            }

        }else if("MT-MOD" == orderObject->channel){
            tempOrderPayType = 84;
            tempSbkAppPayValue = orderObject->id;
            tempSbkAppPayType = 92;
            tempSbkAppPayValue = orderObject->thirdPartyOrderId;
        }else if("ELE" == orderObject->channel){
            tempOrderPayType = 83;
            tempSbkAppPayValue = orderObject->id;
        //星巴克-预约订单: 预约实物入机: 销售单订单类型:21; 退货单订单类型: 22;
        //为了配合服务端调整:兼容 预约退货 不区分 预约配送费 与 预约实物；必须重点注意退货时支付方式赋值;
        }else if("ORS" == orderObject->channel && orderObject->appointmentDayFlag ){
            // 端支付方式: 15纸质卷 16电子卷;需要循环商品列表中的券支付方式;
            // 星巴克-预约订单: 配送费入机: 销售单订单类型:23; 退货单订单类型: 24;
        }else if("ORS" == orderObject->channel && !orderObject->appointmentDayFlag ){
        }else{
            tempOrderPayType = 83;
            tempSbkAppPayValue = orderObject->id;
        }
        //如果是退单,更新订单的来源类型; 需要考虑 订单二次入机方式;
        //存在两种Case:正常退货单 && 【非预约日期(录配送费判断)/默认值是初始化0】; || 预约实物退货单 【&&预约实物送达日期 不支持此case】 || 预约退单:只能退配送费;
        // 预约如果出现退单，也只能退配送费和打包费[不存在退预约实物(券)]
        if (orderObject->pushOrderType==0) {
        }

        // 优先使用OMS传递的 globalServiceType 与 globalOrderType 值为准;
        if ( orderObject->globalServiceType ) {
                tempServiceType = orderObject->globalServiceType;
        }

        //需要重点注意订单对象的数据初始化问题;
        cObj.insert("orderOriginType", tempServiceType);
        cObj.insert("orderPayType", tempOrderPayType);
        cObj.insert("sbkAppPayType", tempSbkAppPayType);
        cObj.insert("sbkAppPayValue", tempSbkAppPayValue);
        cObj.insert("orderTransFlowNo", (orderObject->thirdPartyBatch).length()?orderObject->thirdPartyBatch:QString("0") ); //第三方交易流水号

        // 2020-10-14 筛选出能与Simphony 通信 可占用的字段; begin------->
        cObj.insert("packFree", 0);
        cObj.insert("packDiscount",0);
        cObj.insert("deliveryFree", 0);
        cObj.insert("deliveryDiscount", 0);
        cObj.insert("waybillId", (orderObject->waybillId).length()?orderObject->waybillId:QString("0") );
        // 2020-10-14 筛选出能与Simphony 通信的字段;   end------->

        //只有这个字段（dis_shop_fee）传给Simphony(代表平台优惠给POS系统),对应的字段是dis_shop_fee :平台优惠总额 只能通过 dis_shop_fee 字段传递给 POS;
        // 目前已经通过本地数据库表字段存储传递, 无需这样传递;
        //cObj.insert("dis_shop_fee", abs(orderObject->disPlateformFee)); // 商家承担优惠金额（实际传递的是: 平台优惠金额 orderObject->disPlateformFee）;
        // 目前设定 CommonFlag 为通用标志：对应Dll: discountFee  Simphony: globalCommonFlag 数字: 个位:标识***   十位标识*** ；百位标识***；千位标识***；万位***;
        int commonFlag = 0;
        //commonFlag = commonFlag + 31281;
        cObj.insert("dis_shop_fee", commonFlag);

        // 整单折扣在Simphony扩展程序中没有实际意义,目前使用此字段透传 插件的版本号信息;
        QString pluginVersion = APP_VERSION ;
        pluginVersion = pluginVersion.mid(4);
        cObj.insert("orderDiscount", pluginVersion.remove(QChar('.'),Qt::CaseInsensitive).toInt() );
        cObj.insert("order_status",orderObject->orderStatus);//订单的状态
        cObj.insert("products_fee", orderObject->productPrice);    // 商品金额
        //只有星巴克App 才挂MSR的虚拟卡号;目前饿了么也要挂MSR的虚拟卡号;卡号是空 则 MSR_NO='-1' 卡号不入机;
        QString temp_MSR_NO;
        temp_MSR_NO = (orderObject->msr_no.length()==0)?orderObject->customerId:orderObject->msr_no;
        temp_MSR_NO = (temp_MSR_NO.length()==0)?QString::fromLocal8Bit("-1"):temp_MSR_NO;
        cObj.insert("msr_card_no", temp_MSR_NO); // MSR卡号

        if("ELE" == orderObject->channel || "MT-MOD" == orderObject->channel ){
            cObj.insert("thirdPartyOrderId",orderObject->thirdPartyOrderId);
        } else {
            cObj.insert("thirdPartyOrderId","0");
        }
        cObj.insert("paid_trans_id",orderObject->id);
        /************************************************************************************/
        int hasCashbox = 0 ,hasRefundAuth = 0;
        hasCashbox = GetCaboxAReAuth::getInstance().getUserHasCashBox(m_cashierId);
        hasRefundAuth =  GetCaboxAReAuth::getInstance().getUserRefundAuth(m_cashierId);
        QLOG_INFO()<<QString::fromLocal8Bit("[<<<<---Simphony_Script请求[ACTION:01:] 获取当前用户是否绑定钱箱:hasCashbox:%1; 当前用户是否拥有退货权限:hasRefundAuth:%2:--->>>>>]").arg(hasCashbox).arg(hasRefundAuth);
        cObj.insert("hasCashbox",hasCashbox);
        cObj.insert("hasRefundAuth",hasRefundAuth);
        /************************************************************************************/
        rObj.insert("pay_id", cObj);
        QJsonArray products;
        QJsonArray coupons;
        QJsonArray payments;
        QJsonArray orderCoupons;
        /**********************************************************************************/
        // 循环订单的最外层商品列表；
        /**********************************************************************************/
        for(int i=0; i < orderObject->proList.count(); i++) {
            dishesObject* dish=orderObject->proList.at(i);
            //初步设定20个促销优惠折扣类型(其value值对应 为 折扣已添加数量): 万能优惠 + 星星优惠 + 券-B账户优惠 + SVC-B账户优惠
            int promotTypeTotal = 20;
            int promotTypeArray[20] = {0};

            // 安全检查:Sku,Qty ...:不合法直接跳过录单【①主商品属性：code中含有Default字符串（不区分大小写）+ ②code中以非数字开头 + ③商品数量是0】 直接跳过录单;
            QString tempCodeLeftHead = dish->code.left(1);
            if (dish->code.contains("Default",Qt::CaseInsensitive) || (tempCodeLeftHead<QString('0') || tempCodeLeftHead>QString('9'))
                    || !dish->qty || dish->code.length()<3 || dish->code.length()>9 ) {
                //①code中以非数字开头直接退出本次录单
                //②code中长度小于3位 直接退出本次录单; [ '34' , '16' ]
                //③code中长度大于9位 直接退出本次录单; [ '1234567890' ]
                //④code 异常, 向oms 汇报异常;
                error = QString::fromLocal8Bit("This Order Has PosKey Is Combo Error Or Default*  Or  qty Is Zore  Or  Sku Length < 3 Or  Sku Length > 9");
                m_OrderEntryMutex.lock();
                m_simValidOrdersList.removeOne(orderObject->id);
                m_OrderEntryMutex.unlock();
                m_bFloatFromLockSt = false; //解锁悬浮框的锁定标志;
                emit doUnLockFloatFrom();   //解锁悬浮框锁定
                // 存储订单入机前异常信息并汇报OMS;
                QString requestType = orderObject->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel,requestType, QString("2"), QString(""), error, QString("1010"));
                return true;
            }
            /**********************************************************************************/
            // 针对同一商品，多份数量需要将其，拆分成单份;[如果不拆分，将导致多份商品中配料价格出现 漏钱:POS中的账将会出现少金额]
            // 新增 一种case: 餐具费项目需要合并, 进行不拆分 处理: qtyNoSplit
            /**********************************************************************************/
            if (dish->qtyNoSplit ) {       // ------> 不拆分主商品数量 --Begin ---->>>
                //声明临时栈对象: 多个主商品;
                QJsonObject noSplitMainProObj;
                QJsonArray noSplitSubProductArry;
                QJsonObject noSplitSubObj;
                noSplitMainProObj.insert("consume_num", dish->qty);
                noSplitMainProObj.insert("pid", dish->chgPrcFlgCode);   // 传递含改价标识重新组装的sku;
                noSplitMainProObj.insert("original_price", dish->price);
                /**********************************************************************************/
                // 处理原始的配料信息;
                /**********************************************************************************/
                if(!dish->sub_products.isEmpty()) {
                    for(int j=0; j < dish->sub_products.count(); j++) {
                        dishesObject* subDish=dish->sub_products.at(j);
                        //安全检查:Sku,Qty ...:不合法直接跳过录单
                        if(!subDish->code.isEmpty() && !subDish->code.contains("Default",Qt::CaseInsensitive) && subDish->qty ) {
                            //①code中以非数字开头直接退出本次录单;
                            //②code中长度小于3位 直接退出本次录单; [ '34' , '16' ]
                            //③code中长度大于9位 直接退出本次录单; [ '1234567890' ]
                            //④code 异常, 向oms 汇报异常;
                            QString  tempSubCodeLeftHead  = subDish->code.left(1);
                            if ( tempSubCodeLeftHead<QString('0') || tempSubCodeLeftHead>QString('9')  ||  subDish->code.length()<3 ||  subDish->code.length()>9 ) {
                                error = QString::fromLocal8Bit("This Order SubProduct PosKey Is String And No Contains Default Or Sku Length < 3 Or Sku Length > 9 ");
                                m_OrderEntryMutex.lock();
                                m_simValidOrdersList.removeOne(orderObject->id);
                                m_OrderEntryMutex.unlock();

                                m_bFloatFromLockSt = false; //解锁悬浮框的锁定标志;
                                emit doUnLockFloatFrom();   //解锁悬浮框锁定

                                // 存储订单入机前异常信息并汇报OMS;
                                QString requestType = orderObject->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                                _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel,requestType, QString("2"), QString(""), error, QString("1011") );
                                return true;
                            }
                            noSplitSubObj.insert("consume_num", subDish->qty);
                            noSplitSubObj.insert("pid", subDish->code);      // 传递含改价标识重新组装的sku; 目前客制化不存在改价可能,故不替换：subDish->chgPrcFlgCode
                            noSplitSubObj.insert("original_price", subDish->price);
                            noSplitSubProductArry.push_back(noSplitSubObj);
                        }
                    }
                }
                /**********************************************************************************/
                // 处理商品的属性(热 -> 特别热)的额外配料信息;
                /**********************************************************************************/
                if(dish->options.length()){
                    noSplitSubObj.insert("consume_num", 1);
                    noSplitSubObj.insert("pid", dish->options);
                    noSplitSubObj.insert("original_price", 0);
                    noSplitSubProductArry.push_back(noSplitSubObj);
                }
                /**********************************************************************************/
                // 不拆分商品合并：优惠折扣数量默认为 1 但是整单体现是 * 主商品数量;
                // 商品促销优惠数组存在: dish->itemsDiscount 则不会再取接口返回的 星星优惠 与 万能优惠;
                if ( !dish->itemsDiscount.isEmpty() ) {
                    for(int m=0; m < dish->itemsDiscount.count(); m++) {
                        PromotionItemObject* promotionObj= dish->itemsDiscount.at(m);
                        if (promotionObj->promotionQty && promotionObj->discountFee && promotionObj->promotionSku.length() ) {
                            noSplitSubObj.insert("consume_num", 1);
                            noSplitSubObj.insert("pid", promotionObj->promotionSku);
                            noSplitSubObj.insert("original_price",  promotionObj->promotionQty * promotionObj->discountFee);
                            noSplitSubProductArry.push_back(noSplitSubObj);
                        }
                    }
                }
                /**********************************************************************************/
                // 汇总插入子商品[sub_products];
                if(noSplitSubProductArry.size()){
                    noSplitMainProObj.insert("sub_products",noSplitSubProductArry);
                } // end 整合子商品结束；
                //products.insert(i, tObj); //防止default*的主商品码出现,上面代码出现continue;导致 i出现跳数，插入时出现崩溃;
                products.push_back(noSplitMainProObj);
                // ------> 不拆分主商品数量 --End   ---->>>

            } else {    // ------> 拆分主商品数量 --Begin ---->>>
                for (int temp_qty = 0; temp_qty < dish->qty; temp_qty++) {
                    //声明临时栈对象: 单个主商品 + 子商品列表 + 子商品;
                    QJsonObject tObj;
                    QJsonArray subProduct;
                    QJsonObject sObj;
                    tObj.insert("consume_num", 1);
                    tObj.insert("pid", dish->chgPrcFlgCode);   // 传递含改价标识重新组装的sku;
                    tObj.insert("original_price", dish->price);
                    /**********************************************************************************/
                    // 处理原始的配料信息;
                    if(!dish->sub_products.isEmpty()) {
                        for(int j=0; j < dish->sub_products.count(); j++) {
                            dishesObject* subDish=dish->sub_products.at(j);
                            //安全检查:Sku,Qty ...:不合法直接跳过录单
                            if(!subDish->code.isEmpty() && !subDish->code.contains("Default",Qt::CaseInsensitive) && subDish->qty ) {
                                //①code中以非数字开头直接退出本次录单;
                                //②code中长度小于3位 直接退出本次录单; [ '34' , '16' ]
                                //③code中长度大于9位 直接退出本次录单; [ '1234567890' ]
                                //④code 异常, 向oms 汇报异常;
                                QString  tempSubCodeLeftHead  = subDish->code.left(1);
                                if ( tempSubCodeLeftHead<QString('0') || tempSubCodeLeftHead>QString('9')  ||  subDish->code.length()<3 ||  subDish->code.length()>9 ) {
                                    error = QString::fromLocal8Bit("This Order SubProduct PosKey Is String And No Contains Default Or Sku Length < 3 Or Sku Length > 9 ");
                                    m_OrderEntryMutex.lock();
                                    m_simValidOrdersList.removeOne(orderObject->id);
                                    m_OrderEntryMutex.unlock();

                                    m_bFloatFromLockSt = false; //解锁悬浮框的锁定标志;
                                    emit doUnLockFloatFrom();   //解锁悬浮框锁定

                                    // 存储订单入机前异常信息并汇报OMS;
                                    QString requestType = orderObject->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                                    _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel,requestType, QString("2"), QString(""), error, QString("1011") );

                                    return true;
                                }
                                sObj.insert("consume_num", subDish->qty);
                                sObj.insert("pid", subDish->code);     // 传递含改价标识重新组装的sku; 目前客制化不存在改价可能,故不替换：subDish->chgPrcFlgCode
                                sObj.insert("original_price", subDish->price);
                                subProduct.push_back(sObj);
                            }
                        }
                    }
                    /**********************************************************************************/
                    // 处理商品的属性(热 -> 特别热)的额外配料信息;
                    if(dish->options.length()){
                        sObj.insert("consume_num", 1);
                        sObj.insert("pid", dish->options);
                        sObj.insert("original_price", 0);
                        subProduct.push_back(sObj);
                    }
                    /**********************************************************************************/
                    // 处理商品的优惠金额信息;针对单个商品多数量情况：需要将这部分优惠折扣金额放在前面 拆分数量的商品上
                    // [多少个折扣券，放在前几个商品上，一个上面下对应一个折扣项];
                    // 商品促销优惠数组存在: dish->itemsDiscount 则不会再取接口返回的 星星优惠 与 万能优惠;
                    if ( !dish->itemsDiscount.isEmpty() ) {
                        for(int m=0; m < dish->itemsDiscount.count(); m++) {
                            PromotionItemObject* promotionObj= dish->itemsDiscount.at(m);
                            if (promotionObj->promotionQty && promotionObj->discountFee && promotionObj->promotionSku.length() ) {
                                // 合理平铺折扣数量: 万能优惠 + 星星优惠  + 券B账户优惠 + SVC卡-B账户优惠;
                                for ( int  p = 1; p < promotTypeTotal ; p++) {
                                    if ( p == promotionObj->type && promotTypeArray[p] < promotionObj->promotionQty ) {
                                        sObj.insert("consume_num", 1);
                                        sObj.insert("pid", promotionObj->promotionSku);
                                        sObj.insert("original_price",  promotionObj->discountFee);
                                        subProduct.push_back(sObj);
                                        promotTypeArray[p]++;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    /**********************************************************************************/
                    // 汇总插入子商品[sub_products];
                    if(subProduct.size()){
                        tObj.insert("sub_products",subProduct);
                    } // end 整合子商品结束；
                    //products.insert(i, tObj); //防止default*的主商品码出现,上面代码出现continue;导致 i出现跳数，插入时出现崩溃;
                    products.push_back(tObj);
                }  // ------> 拆分主商品数量 --End ---->>>

            }

        }

        //**********************************整合WSG券信息-begin*****************************************//
        // 循环订单的WSG券 列表 [进入循环条件: 存在券列表;];
        /**********************************************************************************/
        for(int i=0; i < orderObject->coupList.count() && "WSG-MOD" == orderObject->channel ; i++) {
            CouponsObject* coupon=orderObject->coupList.at(i);
            QJsonObject tCoupObj;
            /**********************************************************/
            // 先整合非门店售券的所有三方券列表数据;
            /**********************************************************/
            //为了后续追踪,录入一个MOD(84)0元支付方式;
            if(0==i){
                QJsonObject tStarbusAppFmIdObj;;
                tStarbusAppFmIdObj.insert("couponSeq",QString::number(0) ) ;         //券的序号
                tStarbusAppFmIdObj.insert("couponCode",orderObject->id.right(24));   //存放非码订单号（防止存不下，自动截取后24位）： couponCode目前最长19位长度;DLL设置24长度;
                tStarbusAppFmIdObj.insert("couponType",QString("0"));
                tStarbusAppFmIdObj.insert("payMethodId",QString("84")); //订单支付方式:MOD(84) 0元支付方式 ;
                tStarbusAppFmIdObj.insert("consumeFactAmount",0);
                coupons.push_back(tStarbusAppFmIdObj);
            }

            //先跳过门店售券,现金支付:最后在补录一个现金支付方式;
            if(!coupon->storeChannel){
                tCoupObj.insert("couponSeq",QString::number(i+1) ) ;             //券的序号
                tCoupObj.insert("couponCode",coupon->code);   //准确的券号码；例: 7019380051100056143 目前最长 19位长度;
                tCoupObj.insert("couponType",coupon->couponType);
                tCoupObj.insert("payMethodId",coupon->payMethodId); //券支付方式: 15纸质卷 16电子卷 ;
                tCoupObj.insert("consumeFactAmount",coupon->consumeFactAmount); //券实际支付金额 (单位:分);
                coupons.push_back(tCoupObj);
            }
            /**********************************************************/
            // 整合所有券核销的商品+券折扣 列表数据;
            /**********************************************************/
            for (int tempSkuSeq = 0; tempSkuSeq < coupon->skus.size(); tempSkuSeq++) {
                QString tempSkuCode = coupon->skus[tempSkuSeq]->code;
                int  tempSkuQty   = coupon->skus[tempSkuSeq]->qty;
                //安全检查:Sku,Qty ...:不合法直接跳过录单
                if(tempSkuCode.isEmpty() || tempSkuCode.contains("Default",Qt::CaseInsensitive)  || tempSkuCode.left(1) < QString('0') || tempSkuCode.left(1) > QString('9')
                        || tempSkuCode.length()<3 ||  tempSkuCode.length()>9 || 0== tempSkuQty  ) {
                    //①code中 空, 含default字符串, 以及 非数字开头直接退出本次录单;
                    //②code中长度小于3位 直接退出本次录单; [ '34' , '16' ]
                    //③code中长度大于9位 直接退出本次录单; [ '1234567890' ]
                    //④code 异常, 向oms 汇报异常;
                    error = QString::fromLocal8Bit("This Order Coupon Product PosKey Is String And No Contains Default Or Sku Length < 3 Or Sku Length > 9 ");
                    m_OrderEntryMutex.lock();
                    m_simValidOrdersList.removeOne(orderObject->id);
                    m_OrderEntryMutex.unlock();
                    m_bFloatFromLockSt = false; //解锁悬浮框的锁定标志;
                    emit doUnLockFloatFrom();   //解锁悬浮框锁定
                    // 存储订单入机前异常信息并汇报OMS;
                    QString requestType = orderObject->orderStatus==6?QString::fromLocal8Bit("6"):QString::fromLocal8Bit("3");
                    _AddOrUpdateReportOmsList(orderObject->id,  orderObject->channel,requestType, QString("2"), QString(""), error, QString("1010") );
                    return true;
                }

                //声明临时栈对象: 单个券关联商品;
                QJsonObject tCoupProductObj;
                tCoupProductObj.insert("couponSeq", QString::number(i+1) );
                tCoupProductObj.insert("consume_num", coupon->skus[tempSkuSeq]->qty );
                tCoupProductObj.insert("pid", coupon->skus[tempSkuSeq]->code);
                //需要考虑 门店券 蛋糕的Combo头开始会限定后续蛋糕子项的价格后面的价格是否会都是0;
                if (coupon->skus[tempSkuSeq]->isCoupon) {
                    tCoupProductObj.insert("original_price", coupon->skus[tempSkuSeq]->price );
                }else{
                    tCoupProductObj.insert("original_price",0);
                }
                products.push_back(tCoupProductObj);
                //如果单品是券menuItem: 需要将券折扣挂在此券单品名下;
                if ( coupon->skus[tempSkuSeq]->isCoupon ) {
                    if ( !coupon->itemsDiscount.isEmpty() ) {
                        for(int m=0; m < coupon->itemsDiscount.count(); m++) {
                            PromotionItemObject* promotionObj= coupon->itemsDiscount.at(m);
                            if (promotionObj->promotionQty && promotionObj->discountFee && promotionObj->promotionSku.length() ) {
                                QJsonObject tCoupProductDiscObj;
                                tCoupProductDiscObj.insert("consume_num", promotionObj->promotionQty);
                                tCoupProductDiscObj.insert("pid", promotionObj->promotionSku);
                                tCoupProductDiscObj.insert("original_price",  promotionObj->discountFee);
                                products.push_back(tCoupProductDiscObj);
                            }
                        }
                    }
                }

            }

        }
        //开头已经新增一条【MOD:84 0元支付方式】
        //**********************************整合WSG券信息-end*****************************************//

        //**********************************整合多支付方式信息【银联】-begin*****************************************//
        // 循环订单的 多支付方式列表【银联】 [进入循环条件: 存在多支付方式列表];
        /**********************************************************************************/
        for(int i=0; i < orderObject->paymentList.count() ; i++) {
            PaymentObject* payment=orderObject->paymentList.at(i);
            QJsonObject tPaymentObj;
            //如果是ELEME的istore 订单，需要额外录入一个标志IStore订单: 8==orderObject->payWay
            //如果是App银联支付的多笔支付方式;也必须额外录入一条84的支付方式;
            if(0==i){
                /**** orderObject->payWay: 8 ->IStore渠道订单(87:istore 0元支付方式); 3/9 ->App银联支付标志(84:MOD 0元支付方式) ****/
                /**** orderObject->payWay: 11 -> 招行一招付[ 84-0MOD; 61-积分抵扣; *-一招付;  *招行满减Tender ] ****/
                QJsonObject tStarbAppOrderPayFlagObj;
                tStarbAppOrderPayFlagObj.insert("couponSeq",QString::number(0) ) ; //支付方式的序号
                tStarbAppOrderPayFlagObj.insert("couponType",QString("0"));
                //存放非码订单号（防止存不下，自动截取后24位）： couponCode目前最长19位长度;DLL设置24长度;
                tStarbAppOrderPayFlagObj.insert("couponCode",orderObject->id.right(24));
                tStarbAppOrderPayFlagObj.insert("payMethodId",QString("84"));
                tStarbAppOrderPayFlagObj.insert("consumeFactAmount",0);
                payments.push_back(tStarbAppOrderPayFlagObj);
            }
            tPaymentObj.insert("couponSeq",QString::number(i+1) ) ;  //券的序号
            // 准确的券号码；例: 7019380051100056143 目前最长 19位长度;  //退货订单: 需要录入 refundFmId;
            // App银联支付: 最多存在两条相同 Upp FmId 的交易支付记录;
            // 但是IStore渠道的多笔SVC不同交易Upp FmId 将仍会是bug 【后台退单(OK); + 插件上退单(bug);】;
            if( 9 == orderObject->payWay || 3 == orderObject->payWay || 11 == orderObject->payWay ) {
                if(OrderObject::Refunded == orderObject->orderStatus ||OrderObject::SimExceptRefund == orderObject->orderStatus){
                    tPaymentObj.insert("couponCode",orderObject->refundFmId.isEmpty()?QString("0"):orderObject->refundFmId);
                } else {
                    tPaymentObj.insert("couponCode",payment->paymentFmId);
                }
            } else {
                //准确的券号码；例: 7019380051100056143 目前最长 19位长度;
                tPaymentObj.insert("couponCode",payment->paymentFmId);
            }
            tPaymentObj.insert("couponType",QString("0"));
            tPaymentObj.insert("payMethodId",payment->payMethodId); //券支付方式: 15纸质卷 16电子卷 ;
            tPaymentObj.insert("consumeFactAmount",payment->paymentMoney); //券实际支付金额 (单位:分);
            payments.push_back(tPaymentObj);
        }
        //**********************************整合多支付方式信息【银联】-end*****************************************//

        //**********************************整合 订单组合券 信息-begin*****************************************//
        // 循环订单组合券列表 [进入循环条件: 存在订单组合券列表];
        // 三种可能场景:  ① 银联支付列表空 && WSG券支付列表空 ② 银联支付列表空 && WSG券支付列表非空 ③银联支付列表非空 && WSG券支付列表空
        /**********************************************************************************/
        for(int i=0; i < orderObject->orderCoupList.count(); i++) {
            CouponsObject* orderCoupon=orderObject->orderCoupList.at(i);
            QJsonObject tOrderCoupObj;
            // 银联支付列表空 && WSG券支付列表空;
            if (0==i && payments.isEmpty() && coupons.isEmpty() ) {
                QJsonObject tOmsOrderIdObj;;
                tOmsOrderIdObj.insert("couponSeq",QString::number(0) ) ;         //券的序号
                tOmsOrderIdObj.insert("couponCode",orderObject->id.right(24));   //存放非码订单号(防止存不下,自动截取后24位) couponCode目前最长19位长度;DLL设置24长度;
                tOmsOrderIdObj.insert("couponType",QString("0"));
                tOmsOrderIdObj.insert("payMethodId",QString("84"));   //订单支付方式:MOD(84) 0元支付方式 ;
                tOmsOrderIdObj.insert("consumeFactAmount",0);
                orderCoupons.push_back(tOmsOrderIdObj);
            }

            if (!orderCoupon->storeChannel) {
                tOrderCoupObj.insert("couponSeq",QString::number( orderCoupons.size() ) ) ;   //券的序号
                tOrderCoupObj.insert("couponCode",orderCoupon->code);   //准确的券号码；例: 7019380051100056143 目前最长 19位长度;DLL设置24长度;
                tOrderCoupObj.insert("couponType",orderCoupon->couponType);
                tOrderCoupObj.insert("payMethodId",orderCoupon->payMethodId); //券支付方式: 15纸质卷 16电子卷 ;
                tOrderCoupObj.insert("consumeFactAmount",orderCoupon->consumeFactAmount); //券实际支付金额 (单位:分);
                orderCoupons.push_back(tOrderCoupObj);
            }
            // 添加组合支付后 其他方式的支付方式: 微信 / 支付宝 / SVC / 等等【不含 ELE】
            if ( (orderObject->orderCoupList.count() -1) == i ) {
                if ( !orderObject->paymentList.isEmpty() ||  !orderObject->coupList.isEmpty()  ) {
                    QLOG_INFO()<<QString::fromLocal8Bit("--- paymentList.size()=%1, coupList.size()=%2 至少一个支付List非空, 无需整合常规支付方式---")
                                 .arg( orderObject->paymentList.size() ).arg( orderObject->coupList.size() );
                } else {
                    // 添加常规支付方式和交易流水: 微信 / 支付宝 / SVC / 等等【不含 ELE】
                    if ( tempSbkAppPayValue.length() > 4 ) {
                        tOrderCoupObj.insert("couponSeq",QString::number(orderCoupons.size() ) ) ;  //券的序号
                        // svc:长度20; 支付宝:长度28; 微信:长度28; DLL设置24长度,只能使用Simphony程序中接受完整的 tempSbkAppPayValue;
                        tOrderCoupObj.insert("couponCode",tempSbkAppPayValue.mid(6) );
                        tOrderCoupObj.insert("couponType",QString("-1"));
                        tOrderCoupObj.insert("payMethodId",tempSbkAppPayType); //混合支付尾部支付: 78:支付宝; 77:微信; *:银联; 14:SVC卡;
                        tOrderCoupObj.insert("consumeFactAmount", -1 ); //券实际支付金额 (单位:分);
                        orderCoupons.push_back(tOrderCoupObj);
                    }
                }
            }

        }
        //整合WSG券 + 整合银联支付 已经新增一条【MOD:84 0元支付方式】
        //**********************************整合 订单组合券 信息-end*****************************************//


        //向商品列表中 添加 是否打包的SKU;
        if(orderObject->isPackage && orderObject->packageSku.length()) {
            QJsonObject tPackageObj;
            tPackageObj.insert("consume_num", 1);
            tPackageObj.insert("pid", orderObject->packageSku);
            tPackageObj.insert("original_price", 0);
            products.push_back(tPackageObj);
        }
        /* 需要将 到店做 SKU 分配的每个主商品的配料的最尾部:此部分逻辑放到 服务端处理;向商品列表中 添加 是否到店做SKU;*/

        //**********************************整合包装费-begin*****************************************//
        // 向商品列表尾部 添加 包装费项 + 包装费折扣项;
        // 包装费 >0  + MOP 也不能入机【特别说明:WSG-MOD 配送费及配送费折扣信息存储 coupons中;故在此处排除】;
        if ( orderObject->packageFee > 0 && ( "MOD"==orderObject->channel || "ELE" == orderObject->channel || "MT-MOD" == orderObject->channel )  ) {
            QJsonObject tPackageFeeObj;
            tPackageFeeObj.insert("consume_num", orderObject->packageFee/100);
            tPackageFeeObj.insert("pid", "6000201"); //包装费SKU;
            tPackageFeeObj.insert("original_price", 100);
            products.push_back(tPackageFeeObj);
            //星巴克APP/预约系统的支付方式是84; ELE的支付方式是83; [MOP不应该存在打包费且不存在包装费折扣]
            if( orderObject->packDiscount>0 ){
                QJsonObject tPackDiscountObj;
                tPackDiscountObj.insert("consume_num", 1);
                if ( "ELE" == orderObject->channel ) {
                    tPackDiscountObj.insert("pid","10400"); //ELEME万能折扣码;
                } else if ( "MT-MOD" == orderObject->channel ) {
                    tPackDiscountObj.insert("pid","10400"); // MT万能折扣码;  by 待更新 wuyang 2021-08
                } else {
                    tPackDiscountObj.insert("pid","285"); //星巴克APP万能折扣码;
                }
                tPackDiscountObj.insert("original_price", orderObject->packDiscount);
                products.push_back(tPackDiscountObj);
            }
        //打包费是0元时( MOP 包装费不能入机):需录入打包费[非-MOP(销售退货),非-MOP测试];
        } else if ( 0 == orderObject->packageFee && ( "MOD"==orderObject->channel || "ELE" == orderObject->channel  || "MT-MOD" == orderObject->channel ) ) {
            QJsonObject tPackageFeeObj;
            tPackageFeeObj.insert("consume_num", 1);
            tPackageFeeObj.insert("pid","6000201"); //包装费SKU;
            tPackageFeeObj.insert("original_price", 0);
            products.push_back(tPackageFeeObj);
        }
        //**********************************整合包装费-end*****************************************//

        //**********************************整合配送费-begin*****************************************//
        //向商品列表尾部 添加 配送费项 + 配送费折扣项; 【特别说明:WSG-MOD 配送费及配送费折扣信息存储 coupons中;故在此处排除】
        //上游oms 开关已完全打开: 配送费已添加到商品列表中; 顾无需此处配送费整合逻辑;
        //*********************************整合配送费-end******************************************//

        //****************************整合订单商品列表末尾追加一个MenuItem:9107815 无其他-begin******************//
        //此操作是防止一种异常情况发生: 退货 + 最后一个商品尾部存在一个折扣 + 且后面无客制化且无卡号 + 直接挂支付方式;
        //避免在退货的dsc事件中 挂 支付方式信息;
        if(1){
            QJsonObject tDefaultWuQiTaObj;
            tDefaultWuQiTaObj.insert("consume_num", 1);
            tDefaultWuQiTaObj.insert("pid","9107815"); //无其他-SKU;
            tDefaultWuQiTaObj.insert("original_price", 0);
            products.push_back(tDefaultWuQiTaObj);
        }
        //****************************整合订单商品列表末尾追加一个MenuItem: 无其他-end******************//
        //组装完成JSON 对象的商品数据；
        rObj.insert("products", products);
        //如果存在预约券信息，则不可能存在<多条支付方式>可能[App的银联支付+istore的多张SVC卡消费记录],两者相斥，但公用一个Dll[coupons]数据传输通道;
        QJsonValue tmpOrderCoup;
        if( coupons.count() ) {
            while ( orderCoupons.size() ){
                tmpOrderCoup = orderCoupons.first();
                coupons.push_back(tmpOrderCoup);
                orderCoupons.removeFirst();
            }
            rObj.insert("coupons", coupons);
        } else {
            while ( orderCoupons.size() ){
                tmpOrderCoup = orderCoupons.first();
                payments.push_back(tmpOrderCoup);
                orderCoupons.removeFirst();
            }
            rObj.insert("coupons", payments);
        }
        data= rObj;
    }
    return result;
}


QString FlowControl::_Penny2Dollar(int penny)
{
    double dollar = (double)penny/100;
    return QString::number(dollar,'f',1);
}

void FlowControl::onGetBusinessStatus()
{
}


void FlowControl::onGetOMSAllOrders()
{
    QLOG_INFO()<<__FUNCTION__;
    if(!m_bLoginResult) {
        emit showAlert(AlertForm::MSGERROR, QString::fromLocal8Bit("门店还未登录"));
        return ;
    }
    // 类登陆后的获取全部订单动作;
    QLOG_INFO() << QString(" FlowControl::onGetOMSAllOrders only _AddOrderPull begin.");
    _AddOrderPull(QString(),QString());
     emit showAlert(AlertForm::SYNCDATA, QString::fromLocal8Bit("正在获取平台全部订单,稍后刷新......"));
    QLOG_INFO() << QString(" FlowControl::onGetOMSAllOrders only _AddOrderPull end.");
}



void FlowControl::onProcessOrder(const QString &operation, const QString &orderId)
{
    if(!operation.compare(OPERATION_GETDELIVERS))
    {
        _ConfirmOrder(orderId);
    }else if(!operation.compare(OPERATION_CONFRIM))
    {
        _ConfirmOrder(orderId);
    }
    else if(!operation.compare(OPERATION_SENDOUT))
    {
        _SendOrder(orderId);
    }else if(!operation.compare(OPERATION_COMPLETE))
    {
        _CompleteOrder(orderId);
    }else if(!operation.compare(OPERATION_REFUSEREFUND))
    {
        _RefuseRefund(orderId);
    }else if(!operation.compare(OPERATION_REFUNDORDER))
    {
        _RefundOrder(orderId,5,QString::fromLocal8Bit("同意退款"),QString());
    }
}


bool FlowControl::onRecvSocketPushedMsg(QByteArray &msgData, int & actionId) {
    bool recvRet = false;

    if ( 11 == actionId ) {
        QJsonDocument document = QJsonDocument::fromJson(msgData);
        if ( document.isNull() ) {
            QLOG_ERROR()<<QString("onRecvSocketPushedMsg  QJsonDocument::fromJson(*) Is Null , ActionId : %1").arg(actionId);
        } else {
            QJsonObject orderDataObject = document.object();
            QJsonObject unusedData;
            QString error;
            recvRet = _ResponseOMS11Request(orderDataObject, unusedData, error);
            QLOG_INFO()<<QString("onRecvSocketPushedMsg  recvRet: %1, error: %2").arg(recvRet?1:0).arg(error);
        }

    } else if ( 21 == actionId ) {
        QLOG_INFO() << "onRecvSocketPushedMsg::  ActionID: 21 , Wait Process";
    } else {
        QLOG_ERROR() << "onRecvSocketPushedMsg::  OMS Push Plugin Action Out Of Range";
    }

    return recvRet;
}


void FlowControl::onGetOrderDetails(const QString& orderId)
{
    emit hideAlert();
    if ( !orderId.isEmpty() ) {
        QMap<QString, OrderObject*>::iterator orderIterator;
        orderIterator = m_FmOrdersMap.find(orderId);
        if ( orderIterator == m_FmOrdersMap.end() ){
            QLOG_ERROR() << QString("[<<<<---FlowControl::onGetOrderDetails: OrderId:%1 No Find In m_FmOrdersMap, Can't Get UI Detail--->>>>]").arg(orderId);
        } else {
            emit showOrderDetails(m_FmOrdersMap.value(orderId));
        }
    } else {
        QLOG_INFO() << QString("[<<<<---FlowControl::onGetOrderDetails: OrderId:%1 Is Empty --->>>>]").arg(orderId);
        return;
    }

}


void FlowControl::onGetEcMopOrderDetails(const QString& orderId, const QString& channel)
{
    // 入参非法;
    if ( orderId.isEmpty() || channel.isEmpty() || orderId.length() < 17 ||  orderId.length() > 25 ) {
        QLOG_INFO() << QString("[<<<<---FlowControl::onGetEcMopOrderDetails: OrderId:%1 /  channel:%2  Is Empty / Error  --->>>>]").arg( orderId ).arg( channel );
        emit showAlert(AlertForm::MSGERROR,  QString::fromLocal8Bit("扫描订单号异常") );
        return;
    } else {
        // 入参有效;
        // 判断插件是否登录成功了，没有登录成功，弹框提示;
        if ( !m_bLoginResult  ) {
            emit showAlert(AlertForm::MSGERROR,  QString::fromLocal8Bit("插件程序还未成功登录") );
            return;
        }
        // 组装请求报文 [ 含门店编号:便于 OMS 校验此订单是否属于本门店 ] , 获取订单详情数据 ;[ 失败则弹框提示]
        bool pullOrderDetailRet = _PullOrderDetail( orderId, channel);
        if ( pullOrderDetailRet ) {
            // 展示跳转订单详情页面; // 同一线程, 理论无需 Sleep
            Sleep(1000*3);
            emit showOrderDetails(m_FmOrdersMap.value(orderId));
        }
    }

}


void FlowControl::onSerachOrder(const QString &text)
{
    QLOG_INFO() << QString::fromLocal8Bit("[<<<<---FlowControl::onSerachOrder:输入的数字串:%1 --->>>>]").arg(text);
    QMap<QString,QString> orderMap;
    if(!text.isEmpty()) {
        QMap<QString, OrderObject*>::iterator order;
        for(order = m_FmOrdersMap.begin(); order!=m_FmOrdersMap.end(); order++) {
            QString orderId = order.key();
            QString phoneId = order.value()->consigneePhone;
            QString thirdPartyOrderId = order.value()->thirdPartyOrderId;
            while (!orderId.at(0).isDigit()) {
              orderId = orderId.mid(1);
            }
            if(orderId.startsWith(text)) {
                orderMap.insert(QString::fromLocal8Bit("订单号:")+orderId,QString::fromLocal8Bit("三方订单号:")+thirdPartyOrderId);
            }
            //移除手机号检索
            /*
            if(phoneId.startsWith(text)) {
                orderMap.insert(QString::fromLocal8Bit("订单号:")+orderId,QString::fromLocal8Bit("手机号:")+phoneId);
            }
            */
            //新增第三方订单号检索;
            if(thirdPartyOrderId.startsWith(text)) {
                orderMap.insert(QString::fromLocal8Bit("订单号:")+orderId,QString::fromLocal8Bit("三方订单号:")+thirdPartyOrderId);
            }
        }
    }
    emit showSearchOrderResult(orderMap);
}


void FlowControl::onProcessRejectOrder(const QString &orderId, const int &reasonCode,const QString &reason)
{
    _RefuseOrder(orderId, reasonCode,reason);
}


void FlowControl::onProcessRepealOrder(const QString &orderId, const int &reasonCode,const QString &reason,const QString& dishesListString)
{
    QLOG_INFO() << QString("[<<<<---FlowControl::onProcessRepealOrder: --->>>>]");
    _RefundOrder(orderId,reasonCode,reason,dishesListString);
}


void FlowControl::onProcessReTryInputOrder(const QString &orderId)
{
    QLOG_INFO() << QString("[<<<<---FlowControl::onProcessReTryInputOrder: OrderId: %1 --->>>>]").arg(orderId);
    //先判断非码订单容器不为空;
    if ( !m_FmOrdersMap.isEmpty() ) {
        QMap<QString, OrderObject*>::iterator TempOrder;
        //遍历订单容器列表,找到指定订单;
        for( TempOrder = m_FmOrdersMap.begin(); TempOrder != m_FmOrdersMap.end(); TempOrder++ ) {
            if( TempOrder.key() == orderId) {

                OrderObject* TempOrderObject = TempOrder.value();
                bool btryLock = m_PullOrderDataMutex.tryLock(VALUE_TRYLOCKNETTIMEOUT);
                if (!btryLock) {
                    QLOG_ERROR()<<"[<<<<----FlowControl::onProcessReTryInputOrder Try Lock Failed ---->>>>>]";
                    return;
                }
                /***组装从FM外卖service端的拉单请求参数***/
                PullOrderInfo* orderPull = new PullOrderInfo();
                orderPull->orderId=orderId;
                orderPull->channel=TempOrderObject->channel;
                orderPull->pageNumber=1;
                orderPull->pageSize=30;
                m_orderPullList.append(orderPull);
                m_PullOrderDataMutex.unlock();
            }
        }
    } else {
        QLOG_INFO() << QString("[<<<<---FlowControl::onProcessReTryInputOrder: m_FmOrdersMap Is Empty --->>>>]");
    }
}
